/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.rice.kim.dao.impl;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.naming.Name;
import javax.naming.directory.SearchControls;
import org.apache.commons.lang.StringUtils;
import org.kuali.rice.core.util.BufferedLogger;
import org.kuali.rice.coreservice.framework.parameter.ParameterService;
import org.kuali.rice.kim.api.identity.entity.Entity;
import org.kuali.rice.kim.api.identity.entity.EntityDefault;
import org.kuali.rice.kim.api.identity.principal.EntityNamePrincipalName;
import org.kuali.rice.kim.api.identity.principal.Principal;
import org.kuali.rice.kim.api.identity.privacy.EntityPrivacyPreferences;
import org.kuali.rice.kim.dao.LdapPrincipalDao;
import org.kuali.rice.kim.impl.identity.PersonImpl;
import org.kuali.rice.kim.util.Constants;
import org.kuali.rice.kns.lookup.LookupUtils;
import org.springframework.ldap.SizeLimitExceededException;
import org.springframework.ldap.core.ContextMapper;
import org.springframework.ldap.core.ContextMapperCallbackHandler;
import org.springframework.ldap.core.DistinguishedName;
import org.springframework.ldap.core.LdapTemplate;
import org.springframework.ldap.core.NameClassPairCallbackHandler;
import org.springframework.ldap.filter.AndFilter;
import org.springframework.ldap.filter.Filter;
import org.springframework.ldap.filter.LikeFilter;
import org.springframework.ldap.filter.NotFilter;
import org.springframework.ldap.filter.OrFilter;

public class LdapPrincipalDaoImpl
implements LdapPrincipalDao {
    private Constants kimConstants;
    private LdapTemplate template;
    private ParameterService parameterService;
    private Map<String, ContextMapper> contextMappers;

    @Override
    public Principal getPrincipal(String principalId) {
        if (principalId == null) {
            return null;
        }
        HashMap<String, Object> criteria = new HashMap<String, Object>();
        criteria.put(this.getKimConstants().getKimLdapIdProperty(), principalId);
        List<Principal> results = this.search(Principal.class, criteria);
        if (results.size() > 0) {
            return results.get(0);
        }
        return null;
    }

    @Override
    public Principal getPrincipalByName(String principalName) {
        if (principalName == null) {
            return null;
        }
        HashMap<String, Object> criteria = new HashMap<String, Object>();
        criteria.put(this.getKimConstants().getKimLdapNameProperty(), principalName);
        List<Principal> results = this.search(Principal.class, criteria);
        if (results.size() > 0) {
            return results.get(0);
        }
        return null;
    }

    @Override
    public <T> List<T> search(Class<T> type, Map<String, Object> criteria) {
        AndFilter filter = new AndFilter();
        for (Map.Entry<String, Object> entry : criteria.entrySet()) {
            if (entry.getValue() == null) {
                entry.setValue("null");
            }
            if (entry.getValue() instanceof Iterable) {
                OrFilter orFilter = new OrFilter();
                for (String value : (Iterable)entry.getValue()) {
                    if (value.startsWith("!")) {
                        orFilter.or((Filter)new NotFilter((Filter)new LikeFilter(entry.getKey(), value.substring(1))));
                        continue;
                    }
                    orFilter.or((Filter)new LikeFilter(entry.getKey(), value));
                }
                filter.and((Filter)orFilter);
                continue;
            }
            if (((String)entry.getValue()).startsWith("!")) {
                filter.and((Filter)new NotFilter((Filter)new LikeFilter(entry.getKey(), ((String)entry.getValue()).substring(1))));
                continue;
            }
            filter.and((Filter)new LikeFilter(entry.getKey(), (String)entry.getValue()));
        }
        BufferedLogger.info("Using filter ", filter);
        BufferedLogger.debug("Looking up mapper for ", type.getSimpleName());
        ContextMapper customMapper = this.contextMappers.get(type.getSimpleName());
        CustomContextMapperCallbackHandler callbackHandler = new CustomContextMapperCallbackHandler(customMapper);
        try {
            this.getLdapTemplate().search((Name)DistinguishedName.EMPTY_PATH, filter.encode(), this.getSearchControls(), (NameClassPairCallbackHandler)callbackHandler);
        }
        catch (SizeLimitExceededException sizeLimitExceededException) {
            // empty catch block
        }
        return callbackHandler.getList();
    }

    protected SearchControls getSearchControls() {
        SearchControls retval = new SearchControls();
        retval.setCountLimit(LookupUtils.getSearchResultsLimit(PersonImpl.class).longValue());
        retval.setSearchScope(2);
        return retval;
    }

    @Override
    public Entity getEntity(String entityId) {
        if (entityId == null) {
            return null;
        }
        HashMap<String, Object> criteria = new HashMap<String, Object>();
        criteria.put(this.getKimConstants().getKimLdapIdProperty(), entityId);
        List<Entity> results = this.search(Entity.class, criteria);
        BufferedLogger.debug("Got results from info lookup ", results, " with size ", results.size());
        if (results.size() > 0) {
            return results.get(0);
        }
        return null;
    }

    @Override
    public Entity getEntityByPrincipalId(String principalId) {
        if (principalId == null) {
            return null;
        }
        Principal principal = this.getPrincipal(principalId);
        if (principal != null && !StringUtils.isBlank((String)principal.getEntityId())) {
            return this.getEntity(principal.getEntityId());
        }
        return null;
    }

    @Override
    public EntityDefault getEntityDefault(String entityId) {
        if (entityId == null) {
            return null;
        }
        HashMap<String, Object> criteria = new HashMap<String, Object>();
        criteria.put(this.getKimConstants().getKimLdapIdProperty(), entityId);
        List<EntityDefault> results = this.search(EntityDefault.class, criteria);
        BufferedLogger.debug("Got results from info lookup ", results, " with size ", results.size());
        if (results.size() > 0) {
            return results.get(0);
        }
        return null;
    }

    @Override
    public EntityDefault getEntityDefaultByPrincipalId(String principalId) {
        return this.getEntityDefault(principalId);
    }

    @Override
    public EntityDefault getEntityDefaultByPrincipalName(String principalName) {
        HashMap<String, Object> criteria = new HashMap<String, Object>();
        criteria.put(this.getKimConstants().getKimLdapNameProperty(), principalName);
        List<EntityDefault> results = this.search(EntityDefault.class, criteria);
        if (results.size() > 0) {
            return results.get(0);
        }
        return null;
    }

    @Override
    public Entity getEntityByPrincipalName(String principalName) {
        HashMap<String, Object> criteria = new HashMap<String, Object>();
        criteria.put(this.getKimConstants().getKimLdapNameProperty(), principalName);
        List<Entity> results = this.search(Entity.class, criteria);
        if (results.size() > 0) {
            return results.get(0);
        }
        return null;
    }

    public List<EntityDefault> lookupEntityDefault(Map<String, String> searchCriteria, boolean unbounded) {
        ArrayList<EntityDefault> results = new ArrayList();
        Map<String, Object> criteria = this.getLdapLookupCriteria(searchCriteria);
        results = this.search(EntityDefault.class, criteria);
        return results;
    }

    @Override
    public List<String> lookupEntityIds(Map<String, String> searchCriteria) {
        ArrayList<String> results = new ArrayList<String>();
        Map<String, Object> criteria = this.getLdapLookupCriteria(searchCriteria);
        for (Entity entity : this.search(Entity.class, criteria)) {
            results.add(entity.getId());
        }
        return results;
    }

    protected Map<String, Object> getLdapLookupCriteria(Map<String, String> searchCriteria) {
        HashMap<String, Object> criteria = new HashMap<String, Object>();
        boolean hasTaxId = false;
        for (Map.Entry<String, String> criteriaEntry : searchCriteria.entrySet()) {
            BufferedLogger.debug(String.format("Searching with criteria %s = %s", criteriaEntry.getKey(), criteriaEntry.getValue()));
            String valueName = criteriaEntry.getKey();
            Object value = criteriaEntry.getValue();
            if (!criteriaEntry.getValue().equals("*")) {
                valueName = String.format("%s.%s", criteriaEntry.getKey(), criteriaEntry.getValue());
            }
            if (!value.equals("*") && this.isMapped(valueName)) {
                value = this.getLdapValue(valueName);
                BufferedLogger.debug(value, " mapped to valueName ", valueName);
            }
            if (this.isMapped(criteriaEntry.getKey())) {
                BufferedLogger.debug(String.format("Setting attribute to (%s, %s)", this.getLdapAttribute(criteriaEntry.getKey()), value));
                String key = this.getLdapAttribute(criteriaEntry.getKey());
                if (criteria.containsKey(key)) continue;
                criteria.put(key, value);
                continue;
            }
            if (criteriaEntry.getKey().equalsIgnoreCase(this.getKimConstants().getExternalIdProperty())) {
                criteria.put(this.getKimConstants().getKimLdapIdProperty(), value);
                continue;
            }
            if (!criteriaEntry.getKey().equalsIgnoreCase(this.getKimConstants().getExternalIdTypeProperty()) || !value.toString().equals(this.getKimConstants().getTaxExternalIdTypeCode())) continue;
            hasTaxId = true;
        }
        return criteria;
    }

    @Override
    public EntityPrivacyPreferences getEntityPrivacyPreferences(String entityId) {
        if (entityId == null) {
            return null;
        }
        HashMap<String, Object> criteria = new HashMap<String, Object>();
        criteria.put(this.getKimConstants().getKimLdapIdProperty(), entityId);
        List<EntityPrivacyPreferences> results = this.search(EntityPrivacyPreferences.class, criteria);
        if (results.size() > 0) {
            return results.get(0);
        }
        return null;
    }

    @Override
    public Map<String, EntityNamePrincipalName> getDefaultNamesForPrincipalIds(List<String> principalIds) {
        HashMap<String, Object> criteria = new HashMap<String, Object>();
        HashMap<String, EntityNamePrincipalName> retval = new HashMap<String, EntityNamePrincipalName>();
        criteria.put(this.getKimConstants().getKimLdapIdProperty(), principalIds);
        List<EntityNamePrincipalName> results = this.search(EntityNamePrincipalName.class, criteria);
        for (EntityNamePrincipalName nameInfo : results) {
            retval.put(nameInfo.getPrincipalName(), nameInfo);
        }
        return retval;
    }

    @Override
    public Map<String, EntityNamePrincipalName> getDefaultNamesForEntityIds(List<String> entityIds) {
        return this.getDefaultNamesForPrincipalIds(entityIds);
    }

    protected Matcher getKimAttributeMatcher(String kimAttribute) {
        String mappedParamValue = this.getParameterService().getParameterValueAsString(this.getKimConstants().getParameterNamespaceCode(), this.getKimConstants().getParameterDetailTypeCode(), this.getKimConstants().getMappedParameterName());
        String regexStr = String.format("(%s|.*;%s)=([^=;]*).*", kimAttribute, kimAttribute);
        BufferedLogger.debug("Matching KIM attribute with regex ", regexStr);
        Matcher retval = Pattern.compile(regexStr).matcher(mappedParamValue);
        if (!retval.matches()) {
            mappedParamValue = this.getParameterService().getParameterValueAsString(this.getKimConstants().getParameterNamespaceCode(), this.getKimConstants().getParameterDetailTypeCode(), this.getKimConstants().getMappedValuesName());
            retval = Pattern.compile(regexStr).matcher(mappedParamValue);
        }
        return retval;
    }

    protected boolean isMapped(String kimAttribute) {
        BufferedLogger.debug("Matching " + kimAttribute);
        BufferedLogger.debug("Does ", kimAttribute, " match? ", this.getKimAttributeMatcher(kimAttribute).matches());
        return this.getKimAttributeMatcher(kimAttribute).matches();
    }

    protected String getLdapAttribute(String kimAttribute) {
        Matcher matcher = this.getKimAttributeMatcher(kimAttribute);
        BufferedLogger.debug("Does ", kimAttribute, " match? ", matcher.matches());
        if (matcher.matches()) {
            return matcher.group(2);
        }
        return null;
    }

    protected Object getLdapValue(String kimAttribute) {
        Matcher matcher = this.getKimAttributeMatcher(kimAttribute);
        BufferedLogger.debug("Does ", kimAttribute, " match? ", matcher.matches());
        if (!matcher.matches()) {
            return null;
        }
        String value = matcher.group(2);
        if (value.contains(",")) {
            return Arrays.asList(value.split(","));
        }
        return value;
    }

    public void setKimConstants(Constants constants) {
        this.kimConstants = constants;
    }

    @Override
    public Constants getKimConstants() {
        return this.kimConstants;
    }

    public ParameterService getParameterService() {
        return this.parameterService;
    }

    public void setParameterService(ParameterService service) {
        this.parameterService = service;
    }

    @Override
    public LdapTemplate getLdapTemplate() {
        return this.template;
    }

    @Override
    public void setLdapTemplate(LdapTemplate template) {
        this.template = template;
    }

    @Override
    public Map<String, ContextMapper> getContextMappers() {
        return this.contextMappers;
    }

    public void setContextMappers(Map<String, ContextMapper> contextMappers) {
        this.contextMappers = contextMappers;
    }

    private static final class CustomContextMapperCallbackHandler
    extends ContextMapperCallbackHandler {
        public CustomContextMapperCallbackHandler(ContextMapper mapper) {
            super(mapper);
        }
    }
}

