/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.rice.kns.web.struts.action;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.lang.StringUtils;
import org.apache.log4j.Logger;
import org.apache.struts.action.ActionForm;
import org.apache.struts.action.ActionForward;
import org.apache.struts.action.ActionMapping;
import org.kuali.rice.kim.api.services.KimApiServiceLocator;
import org.kuali.rice.kns.lookup.LookupUtils;
import org.kuali.rice.kns.lookup.Lookupable;
import org.kuali.rice.kns.service.DocumentHelperService;
import org.kuali.rice.kns.service.KNSServiceLocator;
import org.kuali.rice.kns.service.MaintenanceDocumentDictionaryService;
import org.kuali.rice.kns.web.struts.action.KualiAction;
import org.kuali.rice.kns.web.struts.form.LookupForm;
import org.kuali.rice.kns.web.ui.Field;
import org.kuali.rice.kns.web.ui.ResultRow;
import org.kuali.rice.kns.web.ui.Row;
import org.kuali.rice.krad.exception.AuthorizationException;
import org.kuali.rice.krad.lookup.CollectionIncomplete;
import org.kuali.rice.krad.util.GlobalVariables;
import org.kuali.rice.krad.util.KRADUtils;
import org.springframework.web.util.HtmlUtils;

public class KualiLookupAction
extends KualiAction {
    private static final Logger LOG = Logger.getLogger(KualiLookupAction.class);
    private static MaintenanceDocumentDictionaryService maintenanceDocumentDictionaryService;
    private static DocumentHelperService documentHelperService;

    @Override
    protected void checkAuthorization(ActionForm form, String methodToCall) throws AuthorizationException {
        if (!(form instanceof LookupForm)) {
            super.checkAuthorization(form, methodToCall);
        } else {
            try {
                Class<?> businessObjectClass = Class.forName(((LookupForm)form).getBusinessObjectClassName());
                if (!KimApiServiceLocator.getPermissionService().isAuthorizedByTemplate(GlobalVariables.getUserSession().getPrincipalId(), "KR-NS", "Look Up Records", KRADUtils.getNamespaceAndComponentSimpleName(businessObjectClass), Collections.emptyMap())) {
                    throw new AuthorizationException(GlobalVariables.getUserSession().getPerson().getPrincipalName(), "Look Up Records", businessObjectClass.getSimpleName());
                }
            }
            catch (ClassNotFoundException e) {
                LOG.warn((Object)("Unable to load BusinessObject class: " + ((LookupForm)form).getBusinessObjectClassName()), (Throwable)e);
                super.checkAuthorization(form, methodToCall);
            }
        }
    }

    private static MaintenanceDocumentDictionaryService getMaintenanceDocumentDictionaryService() {
        if (maintenanceDocumentDictionaryService == null) {
            maintenanceDocumentDictionaryService = KNSServiceLocator.getMaintenanceDocumentDictionaryService();
        }
        return maintenanceDocumentDictionaryService;
    }

    private static DocumentHelperService getDocumentHelperService() {
        if (documentHelperService == null) {
            documentHelperService = KNSServiceLocator.getDocumentHelperService();
        }
        return documentHelperService;
    }

    protected void suppressActionsIfNeeded(ActionForm form) throws ClassNotFoundException {
        if (form instanceof LookupForm && ((LookupForm)form).getBusinessObjectClassName() != null) {
            Class<?> businessObjectClass = Class.forName(((LookupForm)form).getBusinessObjectClassName());
            String documentTypeName = KualiLookupAction.getMaintenanceDocumentDictionaryService().getDocumentTypeName(businessObjectClass);
            if (documentTypeName != null && !KualiLookupAction.getDocumentHelperService().getDocumentAuthorizer(documentTypeName).canInitiate(documentTypeName, GlobalVariables.getUserSession().getPerson())) {
                ((LookupForm)form).setSuppressActions(true);
            }
        }
    }

    private void setCriteriaEnabled(ActionForm form) {
        LookupForm lookupForm = (LookupForm)form;
        if (lookupForm.isLookupCriteriaEnabled()) {
            // empty if block
        }
    }

    private void suppressNonMaintActionsIfNeeded(ActionForm form) {
        LookupForm lookupForm = (LookupForm)form;
        if (lookupForm.getLookupable() != null && StringUtils.isNotEmpty((String)lookupForm.getLookupable().getSupplementalMenuBar())) {
            lookupForm.setSupplementalActionsEnabled(true);
        }
    }

    @Override
    public ActionForward execute(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        LookupForm lookupForm = (LookupForm)form;
        request.setAttribute("maintenanceViewMode", (Object)"lookup");
        this.suppressActionsIfNeeded(form);
        this.suppressNonMaintActionsIfNeeded(form);
        this.setCriteriaEnabled(form);
        this.hideHeaderBarIfNeeded(form, request);
        int numCols = KNSServiceLocator.getBusinessObjectDictionaryService().getLookupNumberOfColumns(Class.forName(lookupForm.getBusinessObjectClassName()));
        lookupForm.setNumColumns(numCols);
        ActionForward forward = super.execute(mapping, form, request, response);
        lookupForm.getLookupable().applyConditionalLogicForFieldDisplay();
        return forward;
    }

    private void hideHeaderBarIfNeeded(ActionForm form, HttpServletRequest request) {
        if (!((LookupForm)form).isHeaderBarEnabled()) {
            ((LookupForm)form).setHeaderBarEnabled(false);
        }
    }

    public ActionForward start(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        return mapping.findForward("basic");
    }

    public ActionForward search(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        Lookupable kualiLookupable;
        LookupForm lookupForm = (LookupForm)form;
        String methodToCall = this.findMethodToCall(form, request);
        if (methodToCall.equalsIgnoreCase("search")) {
            GlobalVariables.getUserSession().removeObjectsByPrefix("search");
        }
        if ((kualiLookupable = lookupForm.getLookupable()) == null) {
            LOG.error((Object)"Lookupable is null.");
            throw new RuntimeException("Lookupable is null.");
        }
        Collection<Object> displayList = new ArrayList();
        ArrayList<ResultRow> resultTable = new ArrayList<ResultRow>();
        kualiLookupable.validateSearchParameters(lookupForm.getFields());
        boolean bounded = true;
        displayList = kualiLookupable.performLookup(lookupForm, resultTable, bounded);
        if (kualiLookupable.isSearchUsingOnlyPrimaryKeyValues()) {
            lookupForm.setSearchUsingOnlyPrimaryKeyValues(true);
            lookupForm.setPrimaryKeyFieldLabels(kualiLookupable.getPrimaryKeyFieldLabels());
        } else {
            lookupForm.setSearchUsingOnlyPrimaryKeyValues(false);
            lookupForm.setPrimaryKeyFieldLabels("");
        }
        if (displayList instanceof CollectionIncomplete) {
            request.setAttribute("reqSearchResultsActualSize", (Object)((CollectionIncomplete)displayList).getActualSizeIfTruncated());
        } else {
            request.setAttribute("reqSearchResultsActualSize", (Object)displayList.size());
        }
        int resultsLimit = LookupUtils.getSearchResultsLimit(Class.forName(lookupForm.getBusinessObjectClassName()));
        request.setAttribute("reqSearchResultsLimitedSize", (Object)resultsLimit);
        boolean hasActionUrls = false;
        Iterator<ResultRow> iterator = resultTable.iterator();
        while (!hasActionUrls && iterator.hasNext()) {
            if (!StringUtils.isNotBlank((String)HtmlUtils.htmlUnescape((String)iterator.next().getActionUrls()).replace('\u00a0', ' '))) continue;
            hasActionUrls = true;
        }
        lookupForm.setActionUrlsExist(hasActionUrls);
        request.setAttribute("reqSearchResults", resultTable);
        if (request.getParameter("searchResultKey") != null) {
            GlobalVariables.getUserSession().removeObject(request.getParameter("searchResultKey"));
        }
        request.setAttribute("searchResultKey", (Object)GlobalVariables.getUserSession().addObjectWithGeneratedKey(resultTable, "searchResults"));
        request.getParameter("refreshCaller");
        return mapping.findForward("basic");
    }

    @Override
    public ActionForward refresh(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        LookupForm lookupForm = (LookupForm)form;
        Lookupable kualiLookupable = lookupForm.getLookupable();
        if (kualiLookupable == null) {
            LOG.error((Object)"Lookupable is null.");
            throw new RuntimeException("Lookupable is null.");
        }
        if (StringUtils.equals((String)lookupForm.getRefreshCaller(), (String)"customLookupAction")) {
            return this.customLookupableMethodCall(mapping, lookupForm, request, response);
        }
        HashMap<String, String> fieldValues = new HashMap<String, String>();
        Map<String, String> values = lookupForm.getFields();
        for (Row row : kualiLookupable.getRows()) {
            for (Field field : row.getFields()) {
                if (field.getPropertyName() != null && !field.getPropertyName().equals("")) {
                    if (request.getParameter(field.getPropertyName()) != null) {
                        if (!Field.MULTI_VALUE_FIELD_TYPES.contains(field.getFieldType())) {
                            field.setPropertyValue(request.getParameter(field.getPropertyName()));
                        } else {
                            field.setPropertyValues(request.getParameterValues(field.getPropertyName()));
                        }
                    }
                } else if (values.get(field.getPropertyName()) != null) {
                    field.setPropertyValue(values.get(field.getPropertyName()));
                }
                kualiLookupable.applyFieldAuthorizationsFromNestedLookups(field);
                fieldValues.put(field.getPropertyName(), field.getPropertyValue());
            }
        }
        fieldValues.put("docFormKey", lookupForm.getFormKey());
        fieldValues.put("backLocation", lookupForm.getBackLocation());
        fieldValues.put("docNum", lookupForm.getDocNum());
        if (kualiLookupable.checkForAdditionalFields(fieldValues)) {
            for (Row row : kualiLookupable.getRows()) {
                for (Field element : row.getFields()) {
                    Field field = element;
                    if (field.getPropertyName() == null || field.getPropertyName().equals("")) continue;
                    if (request.getParameter(field.getPropertyName()) != null) {
                        if (!Field.MULTI_VALUE_FIELD_TYPES.contains(field.getFieldType())) {
                            field.setPropertyValue(request.getParameter(field.getPropertyName()));
                        } else {
                            field.setPropertyValues(request.getParameterValues(field.getPropertyName()));
                        }
                        fieldValues.put(field.getPropertyName(), request.getParameter(field.getPropertyName()));
                        continue;
                    }
                    if (values.get(field.getPropertyName()) == null) continue;
                    field.setPropertyValue(values.get(field.getPropertyName()));
                }
            }
        }
        return mapping.findForward("basic");
    }

    public ActionForward cancel(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        LookupForm lookupForm = (LookupForm)form;
        String backUrl = lookupForm.getBackLocation() + "?methodToCall=refresh&docFormKey=" + lookupForm.getFormKey() + "&docNum=" + lookupForm.getDocNum();
        return new ActionForward(backUrl, true);
    }

    public ActionForward clearValues(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws IOException, ServletException {
        LookupForm lookupForm = (LookupForm)form;
        Lookupable kualiLookupable = lookupForm.getLookupable();
        if (kualiLookupable == null) {
            LOG.error((Object)"Lookupable is null.");
            throw new RuntimeException("Lookupable is null.");
        }
        kualiLookupable.performClear(lookupForm);
        return mapping.findForward("basic");
    }

    public ActionForward viewResults(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        LookupForm lookupForm = (LookupForm)form;
        if (lookupForm.isSearchUsingOnlyPrimaryKeyValues()) {
            lookupForm.setPrimaryKeyFieldLabels(lookupForm.getLookupable().getPrimaryKeyFieldLabels());
        }
        request.setAttribute("searchResultKey", (Object)request.getParameter("searchResultKey"));
        request.setAttribute("reqSearchResults", GlobalVariables.getUserSession().retrieveObject(request.getParameter("searchResultKey")));
        request.setAttribute("reqSearchResultsActualSize", (Object)request.getParameter("reqSearchResultsActualSize"));
        return mapping.findForward("basic");
    }

    public ActionForward customLookupableMethodCall(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        Lookupable kualiLookupable = ((LookupForm)form).getLookupable();
        if (kualiLookupable == null) {
            LOG.error((Object)"Lookupable is null.");
            throw new RuntimeException("Lookupable is null.");
        }
        boolean ignoreErrors = false;
        if (StringUtils.equals((String)((LookupForm)form).getRefreshCaller(), (String)"customLookupAction")) {
            ignoreErrors = true;
        }
        if (kualiLookupable.performCustomAction(ignoreErrors)) {
            return this.search(mapping, form, request, response);
        }
        return mapping.findForward("basic");
    }
}

