/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.rice.kns.web.struts.form;

import java.util.Collections;
import java.util.Comparator;
import java.util.Date;
import java.util.List;
import org.apache.commons.beanutils.BeanComparator;
import org.apache.commons.beanutils.PropertyUtils;
import org.apache.commons.lang.StringUtils;
import org.kuali.rice.kns.util.TableRenderUtil;

public class KualiTableRenderFormMetadata {
    private int viewedPageNumber;
    private int totalNumberOfPages;
    private int firstRowIndex;
    private int lastRowIndex;
    private int switchToPageNumber;
    private int resultsActualSize;
    private int resultsLimitedSize;
    private int previouslySortedColumnIndex;
    private int columnToSortIndex;
    private String columnToSortName;
    private String previouslySortedColumnName;
    private boolean sortDescending = false;

    public int getColumnToSortIndex() {
        return this.columnToSortIndex;
    }

    public void setColumnToSortIndex(int columnToSortIndex) {
        this.columnToSortIndex = columnToSortIndex;
    }

    public int getPreviouslySortedColumnIndex() {
        return this.previouslySortedColumnIndex;
    }

    public void setPreviouslySortedColumnIndex(int previouslySortedColumnIndex) {
        this.previouslySortedColumnIndex = previouslySortedColumnIndex;
    }

    public int getResultsActualSize() {
        return this.resultsActualSize;
    }

    public void setResultsActualSize(int resultsActualSize) {
        this.resultsActualSize = resultsActualSize;
    }

    public int getResultsLimitedSize() {
        return this.resultsLimitedSize;
    }

    public void setResultsLimitedSize(int resultsLimitedSize) {
        this.resultsLimitedSize = resultsLimitedSize;
    }

    public int getSwitchToPageNumber() {
        return this.switchToPageNumber;
    }

    public void setSwitchToPageNumber(int switchToPageNumber) {
        this.switchToPageNumber = switchToPageNumber;
    }

    public int getViewedPageNumber() {
        return this.viewedPageNumber;
    }

    public void setViewedPageNumber(int viewedPageNumber) {
        this.viewedPageNumber = viewedPageNumber;
    }

    public int getTotalNumberOfPages() {
        return this.totalNumberOfPages;
    }

    public void setTotalNumberOfPages(int totalNumberOfPages) {
        this.totalNumberOfPages = totalNumberOfPages;
    }

    public int getFirstRowIndex() {
        return this.firstRowIndex;
    }

    public void setFirstRowIndex(int firstRowIndex) {
        this.firstRowIndex = firstRowIndex;
    }

    public int getLastRowIndex() {
        return this.lastRowIndex;
    }

    public void setLastRowIndex(int lastRowIndex) {
        this.lastRowIndex = lastRowIndex;
    }

    public boolean isSortDescending() {
        return this.sortDescending;
    }

    public void setSortDescending(boolean sortDescending) {
        this.sortDescending = sortDescending;
    }

    public String getColumnToSortName() {
        return this.columnToSortName;
    }

    public void setColumnToSortName(String columnToSortName) {
        this.columnToSortName = columnToSortName;
    }

    public String getPreviouslySortedColumnName() {
        return this.previouslySortedColumnName;
    }

    public void setPreviouslySortedColumnName(String previouslySortedColumnName) {
        this.previouslySortedColumnName = previouslySortedColumnName;
    }

    public void jumpToFirstPage(int listSize, int maxRowsPerPage) {
        this.jumpToPage(0, listSize, maxRowsPerPage);
    }

    public void jumpToLastPage(int listSize, int maxRowsPerPage) {
        this.jumpToPage(TableRenderUtil.computeTotalNumberOfPages(listSize, maxRowsPerPage) - 1, listSize, maxRowsPerPage);
    }

    public void jumpToPage(int pageNumber, int listSize, int maxRowsPerPage) {
        int totalPages = TableRenderUtil.computeTotalNumberOfPages(listSize, maxRowsPerPage);
        this.setTotalNumberOfPages(totalPages);
        if (pageNumber >= totalPages) {
            pageNumber = totalPages - 1;
        }
        this.setViewedPageNumber(pageNumber);
        this.setFirstRowIndex(TableRenderUtil.computeStartIndexForPage(pageNumber, listSize, maxRowsPerPage));
        this.setLastRowIndex(TableRenderUtil.computeLastIndexForPage(pageNumber, listSize, maxRowsPerPage));
    }

    public void sort(List<?> items, int maxRowsPerPage) {
        if (items == null || items.size() <= 1) {
            return;
        }
        String columnToSortOn = this.getColumnToSortName();
        if (StringUtils.isEmpty((String)columnToSortOn)) {
            return;
        }
        String previouslySortedColumnName = this.getPreviouslySortedColumnName();
        Object firstItem = items.get(0);
        Object comparator = null;
        Comparator<Object> subComparator = new Comparator<Object>(){

            @Override
            public int compare(Object o1, Object o2) {
                if (o1 == null) {
                    return -1;
                }
                if (o2 == null) {
                    return 1;
                }
                if (o1 instanceof Date && o2 instanceof Date) {
                    Date d1 = (Date)o1;
                    Date d2 = (Date)o2;
                    return d1.compareTo(d2);
                }
                String s1 = o1.toString();
                String s2 = o2.toString();
                int n1 = s1.length();
                int n2 = s2.length();
                int i1 = 0;
                for (int i2 = 0; i1 < n1 && i2 < n2; ++i1, ++i2) {
                    char c2;
                    char c1 = s1.charAt(i1);
                    if (c1 == (c2 = s2.charAt(i2)) || (c1 = Character.toUpperCase(c1)) == (c2 = Character.toUpperCase(c2)) || (c1 = Character.toLowerCase(c1)) == (c2 = Character.toLowerCase(c2))) continue;
                    return c1 - c2;
                }
                return n1 - n2;
            }
        };
        comparator = PropertyUtils.isReadable(firstItem, (String)columnToSortOn) ? new BeanComparator(columnToSortOn, (Comparator)subComparator) : new BeanComparator("qualifierAsMap(" + columnToSortOn + ")", (Comparator)subComparator);
        if (!StringUtils.isEmpty((String)columnToSortOn) && !StringUtils.isEmpty((String)previouslySortedColumnName) && columnToSortOn.equals(previouslySortedColumnName)) {
            if (this.isSortDescending()) {
                comparator = Collections.reverseOrder(comparator);
            }
            this.setSortDescending(!this.isSortDescending());
        } else {
            this.setPreviouslySortedColumnName(columnToSortOn);
            this.setSortDescending(true);
        }
        if (this.getSwitchToPageNumber() == this.getViewedPageNumber()) {
            Collections.sort(items, comparator);
        }
        this.jumpToFirstPage(items.size(), maxRowsPerPage);
    }
}

