/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.rice.maintainable;

import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.kuali.rice.kns.maintenance.KualiMaintainableImpl;
import org.kuali.rice.kns.maintenance.Maintainable;

public class KualiMaintainableTest {
    Maintainable maintainable = null;

    @Before
    public void setUp() throws Exception {
        this.maintainable = new KualiMaintainableImpl();
    }

    @Test
    public void testGetShowInactiveRecords_Default() throws Exception {
        boolean displayInactive = this.maintainable.getShowInactiveRecords("fooCollection");
        Assert.assertTrue((String)"display setting returned true for unset collection", (boolean)displayInactive);
    }

    @Test
    public void testGetShowInactiveRecords_NullParam() throws Exception {
        boolean failedAsExpected = false;
        try {
            this.maintainable.getShowInactiveRecords(null);
        }
        catch (IllegalArgumentException expected) {
            failedAsExpected = true;
        }
        Assert.assertTrue((String)"exception not thrown for null collection name", (boolean)failedAsExpected);
    }

    @Test
    public void testSetShowInactiveRecords_DisplayCollectionInActive() throws Exception {
        this.maintainable.setShowInactiveRecords("collection1", true);
        Assert.assertTrue((String)"state failure on set inactive display to true", (boolean)this.maintainable.getShowInactiveRecords("collection1"));
    }

    @Test
    public void testSetShowInactiveRecords_NoDisplayCollectionInActive() throws Exception {
        this.maintainable.setShowInactiveRecords("collection1", false);
        Assert.assertFalse((String)"state failure on set inactive display to false", (boolean)this.maintainable.getShowInactiveRecords("collection1"));
    }

    @Test
    public void testSetShowInactiveRecords_DisplaySubCollectionInActive() throws Exception {
        this.maintainable.setShowInactiveRecords("collection1.subCollection", true);
        Assert.assertTrue((String)"state failure on set inactive display to true", (boolean)this.maintainable.getShowInactiveRecords("collection1.subCollection"));
    }

    @Test
    public void testSetShowInactiveRecords_NoDisplaySubCollectionInActive() throws Exception {
        this.maintainable.setShowInactiveRecords("collection1.subCollection", false);
        Assert.assertFalse((String)"state failure on set inactive display to false", (boolean)this.maintainable.getShowInactiveRecords("collection1.subCollection"));
    }

    @Test
    public void testSetShowInactiveRecords_NullParam() throws Exception {
        boolean failedAsExpected = false;
        try {
            this.maintainable.setShowInactiveRecords(null, true);
        }
        catch (IllegalArgumentException expected) {
            failedAsExpected = true;
        }
        Assert.assertTrue((String)"exception not thrown for null collection name", (boolean)failedAsExpected);
    }
}

