/*-
 * #%L
 * %%
 * Copyright (C) 2005 - 2024 Kuali, Inc. - All Rights Reserved
 * %%
 * You may use and modify this code under the terms of the Kuali, Inc.
 * Pre-Release License Agreement. You may not distribute it.
 * 
 * You should have received a copy of the Kuali, Inc. Pre-Release License
 * Agreement with this file. If not, please write to license@kuali.co.
 * #L%
 */

package org.kuali.rice.core.framework.persistence.ojb;

import java.sql.Connection;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

import javax.sql.DataSource;

import org.apache.ojb.broker.accesslayer.ConnectionFactoryNotPooledImpl;
import org.apache.ojb.broker.accesslayer.LookupException;
import org.apache.ojb.broker.metadata.JdbcConnectionDescriptor;
import org.springframework.beans.factory.BeanFactory;
import org.springframework.jdbc.datasource.TransactionAwareDataSourceProxy;

@Deprecated
public class RiceDataSourceConnectionFactory extends ConnectionFactoryNotPooledImpl {

	/**
	 * BeanFactories to retrieve DataSource beans from.
	 */
	private static List<BeanFactory> beanFactories = new ArrayList<BeanFactory>();

	public static void addBeanFactory(BeanFactory beanFactory) {
		beanFactories.add(beanFactory);
	}

	/**
	 * Map that holds already retrieved DataSources,
	 * with JCD alias Strings as keys and DataSources as values.
	 */
	private Map<String, DataSource> dataSources = new HashMap<String, DataSource>();

	public RiceDataSourceConnectionFactory() {
		if (beanFactories.isEmpty()) {
			throw new IllegalStateException("No BeanFactories found for configuration - must specify RiceOjbConfigurer as a Spring bean.");
		}
	}

	@Override
    public Connection lookupConnection(JdbcConnectionDescriptor jcd) throws LookupException {
		try {
			DataSource dataSource = null;
			synchronized (this.dataSources) {
				dataSource = this.dataSources.get(jcd.getJcdAlias());
				if (dataSource == null) {
					dataSource = getDataSource(jcd.getJcdAlias());
					this.dataSources.put(jcd.getJcdAlias(), dataSource);
				}
			}
			return dataSource.getConnection();
		}
		catch (Exception ex) {
			throw new LookupException("Could not obtain connection from data source", ex);
		}
	}

	/**
	 * Return the DataSource to use for the given JCD alias.
	 * <p>This implementation fetches looks for a bean with the
	 * JCD alias name in the provided Spring BeanFactory.
	 * @param jcdAlias the JCD alias to retrieve a DataSource for
	 * @return the DataSource to use
	 */

	protected DataSource getDataSource(String jcdAlias) throws LookupException {
		DataSource dataSource = null;
		for (BeanFactory beanFactory : beanFactories) {
			if (beanFactory.containsBean(jcdAlias)) {
				dataSource = (DataSource) beanFactory.getBean(jcdAlias, DataSource.class);
				break;
			}
		}
		if (dataSource == null) {
			throw new LookupException("Could not lookup datasource with alias " + jcdAlias);
		} else if (dataSource instanceof TransactionAwareDataSourceProxy) {
			return dataSource;
		} else {
			return new TransactionAwareDataSourceProxy(dataSource);
		}
	}

}
