/*-
 * #%L
 * %%
 * Copyright (C) 2005 - 2024 Kuali, Inc. - All Rights Reserved
 * %%
 * You may use and modify this code under the terms of the Kuali, Inc.
 * Pre-Release License Agreement. You may not distribute it.
 * 
 * You should have received a copy of the Kuali, Inc. Pre-Release License
 * Agreement with this file. If not, please write to license@kuali.co.
 * #L%
 */

package org.kuali.rice.core.framework.persistence.ojb.conversion;

import java.security.GeneralSecurityException;

import org.apache.ojb.broker.accesslayer.conversions.FieldConversion;
import org.kuali.rice.core.api.CoreApiServiceLocator;

/**
 * This class calls core service to encrypt values going to the database and decrypt values coming back from the database.
 * 
 * 
 */

public class OjbKualiEncryptDecryptFieldConversion implements FieldConversion {
    private static final long serialVersionUID = 2450111778124335242L;

    /**
     * @see FieldConversion#javaToSql(Object)
     */
    @Override
    public Object javaToSql(Object source) {
        Object converted = source;

        try {
        	//check if the encryption service is enable before using it
        	if(CoreApiServiceLocator.getEncryptionService().isEnabled()) {
            	converted = CoreApiServiceLocator.getEncryptionService().encrypt(converted);
        	}
        }
        catch (GeneralSecurityException e) {
            throw new RuntimeException("Unable to encrypt value to db: " + e.getMessage(), e);
        }

        return converted;
    }

    /**
     * @see FieldConversion#sqlToJava(Object)
     */
    @Override
    public Object sqlToJava(Object source) {
        String converted = "";
        if (source != null) {
            converted = source.toString();
        }

        try {
        	//check if the encryption service is enable before using it
        	if(CoreApiServiceLocator.getEncryptionService().isEnabled()) {
            	converted = CoreApiServiceLocator.getEncryptionService().decrypt(converted);
        	}
        }
        catch (GeneralSecurityException e) {
            throw new RuntimeException("Unable to decrypt value from db: " + e.getMessage(), e);
        }

        return converted;
    }
}
