/*-
 * #%L
 * %%
 * Copyright (C) 2005 - 2024 Kuali, Inc. - All Rights Reserved
 * %%
 * You may use and modify this code under the terms of the Kuali, Inc.
 * Pre-Release License Agreement. You may not distribute it.
 * 
 * You should have received a copy of the Kuali, Inc. Pre-Release License
 * Agreement with this file. If not, please write to license@kuali.co.
 * #L%
 */

package org.kuali.rice.kns.datadictionary.validation.charlevel;

import org.kuali.rice.krad.datadictionary.exporter.ExportMap;
import org.kuali.rice.krad.datadictionary.validation.CharacterLevelValidationPattern;

/**
 * Pattern for matching numeric characters
 * 
 * @deprecated Use {@link org.kuali.rice.krad.datadictionary.validation.constraint.NumericPatternConstraint}.
 */
@Deprecated
public class NumericValidationPattern extends CharacterLevelValidationPattern {
    /**
     * @see org.kuali.rice.krad.datadictionary.validation.ValidationPattern#getRegexString()
     */
    @Override
    protected String getRegexString() {
        return "[0-9]";
    }

    /**
     * @see org.kuali.rice.krad.datadictionary.validation.CharacterLevelValidationPattern#extendExportMap(org.kuali.bo.datadictionary.exporter.ExportMap)
     */
    @Override
    public void extendExportMap(ExportMap exportMap) {
        exportMap.set("type", "numeric");
    }
}
