/*-
 * #%L
 * %%
 * Copyright (C) 2005 - 2024 Kuali, Inc. - All Rights Reserved
 * %%
 * You may use and modify this code under the terms of the Kuali, Inc.
 * Pre-Release License Agreement. You may not distribute it.
 * 
 * You should have received a copy of the Kuali, Inc. Pre-Release License
 * Agreement with this file. If not, please write to license@kuali.co.
 * #L%
 */

package org.kuali.rice.kns.document.authorization;

import org.kuali.rice.kim.api.identity.Person;
import org.kuali.rice.kns.authorization.BusinessObjectAuthorizer;
import org.kuali.rice.krad.document.Document;

import java.util.Set;

/**
 * The DocumentAuthorizer class associated with a given Document is used to
 * dynamically determine what editing mode and what actions are allowed for a
 * given user on a given document instance.
 * 
 * @deprecated Use {@link org.kuali.rice.krad.document.DocumentAuthorizer}.
 */
@Deprecated
public interface DocumentAuthorizer extends BusinessObjectAuthorizer, org.kuali.rice.krad.document.DocumentAuthorizer {
	public Set<String> getDocumentActions(Document document, Person user,
			Set<String> documentActions);

    @Override
	public boolean canDeleteNoteAttachment(Document document, String attachmentTypeCode, String createdBySelfOnly, Person user);
	
	@Override
    public boolean canViewNoteAttachment(Document document, String attachmentTypeCode, Person user);
}
