/*-
 * #%L
 * %%
 * Copyright (C) 2005 - 2024 Kuali, Inc. - All Rights Reserved
 * %%
 * You may use and modify this code under the terms of the Kuali, Inc.
 * Pre-Release License Agreement. You may not distribute it.
 * 
 * You should have received a copy of the Kuali, Inc. Pre-Release License
 * Agreement with this file. If not, please write to license@kuali.co.
 * #L%
 */

package org.kuali.rice.kns.util;

import org.kuali.rice.kns.web.struts.form.KualiForm;
import org.kuali.rice.krad.util.GlobalVariables;

/**
 * @author Kuali Rice Team (rice.collab@kuali.org)
 *
 * @deprecated Only used in KNS classes, use KRAD.
 */
@Deprecated
public final class KNSGlobalVariables {

    private KNSGlobalVariables() {
        throw new UnsupportedOperationException("do not call");
    }

    private static final ThreadLocal<KualiForm> KUALI_FORMS = new ThreadLocal<>();

    private static final ThreadLocal<MessageList> MESSAGE_LISTS = ThreadLocal.withInitial(MessageList::new);

    /**
     * @return ArrayList containing messages.
     */
    @Deprecated
    public static MessageList getMessageList() {
        return MESSAGE_LISTS.get();
    }

    /**
     * Sets a new message list
     *
     */
    @Deprecated
    public static void setMessageList(MessageList messageList) {
        MESSAGE_LISTS.set(messageList);
    }

    /**
     * @return KualiForm that has been assigned to this thread of execution.
     */
    @Deprecated
    public static KualiForm getKualiForm() {
        return KUALI_FORMS.get();
    }

    /**
     * sets the kualiForm object into the global variable for this thread
     *
     */
    @Deprecated
    public static void setKualiForm(KualiForm kualiForm) {
        KUALI_FORMS.set(kualiForm);
    }

    @Deprecated
    public static void clear() {
        GlobalVariables.clear();
        MESSAGE_LISTS.set(new MessageList());
        KUALI_FORMS.set(null);
    }
}
