/*-
 * #%L
 * %%
 * Copyright (C) 2005 - 2024 Kuali, Inc. - All Rights Reserved
 * %%
 * You may use and modify this code under the terms of the Kuali, Inc.
 * Pre-Release License Agreement. You may not distribute it.
 * 
 * You should have received a copy of the Kuali, Inc. Pre-Release License
 * Agreement with this file. If not, please write to license@kuali.co.
 * #L%
 */

package org.kuali.rice.kns.util;

import org.kuali.rice.krad.util.MessageMap;

import java.util.List;
import java.util.Set;

/**
 * An implementation of {@link MessageContainer} that makes warning messages accessible by the JSP layer
 * 
 * @author Kuali Rice Team (rice.collab@kuali.org)
 *
 * @deprecated Only used in KNS classes, use KRAD.
 */
@Deprecated
public class WarningContainer extends MessageContainer {

	public WarningContainer(MessageMap errorMap) {
		super(errorMap);
	}

	@Override
	public int getMessageCount() {
		return getMessageMap().getWarningCount();
	}


	@Override
	protected Set<String> getMessagePropertyNames() {
		return getMessageMap().getAllPropertiesWithWarnings();
	}

	@Override
	public List<String> getMessagePropertyList() {
		return getMessageMap().getPropertiesWithWarnings();
	}

	@Override
	protected List getMessagesForProperty(String propertyName) {
		return getMessageMap().getWarningMessagesForProperty(propertyName);
	}
}
