/*-
 * #%L
 * %%
 * Copyright (C) 2005 - 2024 Kuali, Inc. - All Rights Reserved
 * %%
 * You may use and modify this code under the terms of the Kuali, Inc.
 * Pre-Release License Agreement. You may not distribute it.
 * 
 * You should have received a copy of the Kuali, Inc. Pre-Release License
 * Agreement with this file. If not, please write to license@kuali.co.
 * #L%
 */

package org.kuali.rice.kns.web.struts.action;

import org.apache.logging.log4j.Logger;
import org.apache.logging.log4j.LogManager;
import org.apache.struts.config.ModuleConfig;
import org.apache.struts.upload.CommonsMultipartRequestHandler;

import java.util.List;

/**
 * Subclass of the MultipartRequestHandler used by Struts.  This one allows the maximum upload size to be set
 * by the application rather than by an init parameter. 
 * 
 * @author Kuali Rice Team (rice.collab@kuali.org)
 *
 * @deprecated KNS Struts deprecated, use KRAD and the Spring MVC framework.
 */
@Deprecated
public class KualiMultipartRequestHandler extends CommonsMultipartRequestHandler {
    private static final Logger LOG = LogManager.getLogger(KualiMultipartRequestHandler.class);

    private String sizeMax;
    
    /**
     * Returns the maximum allowable size, in bytes, of an uploaded file. The
     * value is obtained from the current module's controller configuration.
     *
     * @param mc The current module's configuration.
     *
     * @return The maximum allowable file size, in bytes.
     */
    @Override
    public long getSizeMax(ModuleConfig mc) {
        return convertSizeToBytes( sizeMax, super.getSizeMax(mc) );
    }

    public String getSizeMaxString() {
        return sizeMax;
    }    

    public void setSizeMax( String sizeString ) {
    	this.sizeMax = sizeString;
    }
    
//    public long convertSizeToBytes(String sizeString, long defaultSize) {
//	return super.convertSizeToBytes(sizeString, defaultSize);
//    }
    
    /**
     * Sets the max size string to the item in the list that represents the largest size.
     */
    public void setMaxUploadSizeToMaxOfList( List<String> sizes ) {
	long maxSize = 0L;
	for ( String size : sizes ) {
	    long currSize = convertSizeToBytes(size, 0L);
	    if ( currSize == 0L ) {
		LOG.warn( "Unable to parse max size (" + size + ").  Ignoring." );
	    }
	    if ( currSize > maxSize ) {
		maxSize = currSize;
		sizeMax = size;
	    }
	}
    }
    
    public long calculateMaxUploadSizeToMaxOfList( List<String> sizes ) {
    	long maxSize = 0L;
    	for ( String size : sizes ) {
    	    long currSize = convertSizeToBytes(size, 0L);
    	    if ( currSize == 0L ) {
    		LOG.warn( "Unable to parse max size (" + size + ").  Ignoring." );
    	    }
    	    if ( currSize > maxSize ) {
    		maxSize = currSize;    		
    	    }
    	}
    	return maxSize;
    }
    
}
