/*-
 * #%L
 * %%
 * Copyright (C) 2005 - 2024 Kuali, Inc. - All Rights Reserved
 * %%
 * You may use and modify this code under the terms of the Kuali, Inc.
 * Pre-Release License Agreement. You may not distribute it.
 * 
 * You should have received a copy of the Kuali, Inc. Pre-Release License
 * Agreement with this file. If not, please write to license@kuali.co.
 * #L%
 */

package org.kuali.rice.kns.web.taglib.html;

import org.apache.commons.lang.StringUtils;
import org.apache.struts.action.ActionForm;
import org.apache.struts.taglib.html.CancelTag;
import org.kuali.rice.kns.util.WebUtils;
import org.kuali.rice.kns.web.struts.form.pojo.PojoForm;

import javax.servlet.jsp.JspException;

/**
 * @deprecated KNS Struts deprecated, use KRAD and the Spring MVC framework.
 */
@Deprecated
public class KNSCancelTag extends CancelTag {

	protected String prepareStyles() throws JspException {
		final StringBuffer styles = new StringBuffer(super.prepareStyles());
		prepareAttribute(styles, "aria-label", message(getTitle(), getTitleKey()));

		return styles.toString();
	}

	@Override
	public int doEndTag() throws JspException {
		int returnVal = super.doEndTag();
		if (!getDisabled() && !getReadonly()) {
        	String name = prepareName();
        	if (StringUtils.isNotBlank(name)) {
	        	ActionForm form = WebUtils.getKualiForm(pageContext);
	            if(form instanceof PojoForm) {
	            	((PojoForm) form).registerEditableProperty(name);
	            }
        	}
        }
		return returnVal;
	}

}
