/*-
 * #%L
 * %%
 * Copyright (C) 2005 - 2024 Kuali, Inc. - All Rights Reserved
 * %%
 * You may use and modify this code under the terms of the Kuali, Inc.
 * Pre-Release License Agreement. You may not distribute it.
 * 
 * You should have received a copy of the Kuali, Inc. Pre-Release License
 * Agreement with this file. If not, please write to license@kuali.co.
 * #L%
 */

package org.kuali.rice.krad.dao;

import java.util.List;

import org.kuali.rice.krad.maintenance.MaintenanceLock;
import org.kuali.rice.krad.util.LegacyDataFramework;

/**
 * This interface defines basic methods that MaintenanceDocument Dao's must provide
 * @deprecated use new KRAD Data framework {@link org.kuali.rice.krad.data.DataObjectService}
 */
@Deprecated
@LegacyDataFramework
public interface MaintenanceDocumentDao {
    /**
     * 
     * This method looks for a document that is locking the given lockingRepresentation. If one is found, then it
     * retrieves the documentNumber, and returns it.
     * 
     * @param lockingRepresentation - locking representation to check for
     * @param documentNumber - document number to ignore, optional argument
     * @return returns an empty string if no locking document is found, otherwise returns the documentNumber of the locking document
     * 
     */
    public String getLockingDocumentNumber(String lockingRepresentation, String documentNumber);

}
