/*-
 * #%L
 * %%
 * Copyright (C) 2005 - 2024 Kuali, Inc. - All Rights Reserved
 * %%
 * You may use and modify this code under the terms of the Kuali, Inc.
 * Pre-Release License Agreement. You may not distribute it.
 * 
 * You should have received a copy of the Kuali, Inc. Pre-Release License
 * Agreement with this file. If not, please write to license@kuali.co.
 * #L%
 */

package org.kuali.rice.krad.dao.impl;

import org.apache.ojb.broker.Identity;
import org.apache.ojb.broker.core.IdentityFactoryImpl;
import org.apache.ojb.broker.core.proxy.ProxyHelper;
import org.kuali.rice.core.framework.persistence.ojb.IndirectionHandlerByteBuddyImpl;
import org.kuali.rice.core.framework.persistence.ojb.dao.PlatformAwareDaoBaseOjb;
import org.kuali.rice.krad.dao.PersistenceDao;
import org.kuali.rice.krad.util.LegacyDataFramework;

@Deprecated
@LegacyDataFramework
public class PersistenceDaoOjb extends PlatformAwareDaoBaseOjb implements PersistenceDao {

    /**
     * @see org.kuali.rice.krad.dao.PersistenceDao#clearCache()
     */
    @Override
	public void clearCache() {
        getPersistenceBroker(true).clearCache();
    }

    /**
     * @see org.kuali.rice.krad.dao.PersistenceDao#resolveProxy(java.lang.Object)
     */
    @Override
	public Object resolveProxy(Object o) {
        final Identity ident = new IdentityFactoryImpl(getPersistenceBroker(true)).buildIdentity(o);
        final IndirectionHandlerByteBuddyImpl ih = new IndirectionHandlerByteBuddyImpl(getPersistenceBroker(true).getPBKey(), ident);
        return ih.getRealSubject();
    }

    /**
     * @see org.kuali.rice.krad.dao.PersistenceDao#retrieveAllReferences(java.lang.Object)
     */
    @Override
	public void retrieveAllReferences(Object o) {
        getPersistenceBroker(true).retrieveAllReferences(o);
    }

    /**
     * @see org.kuali.rice.krad.dao.PersistenceDao#retrieveReference(java.lang.Object, java.lang.String)
     */
    @Override
	public void retrieveReference(Object o, String referenceName) {
        getPersistenceBroker(true).retrieveReference(o, referenceName);
    }

	/**
	 * Asks ProxyHelper if the object is proxied
	 *
	 * @see org.kuali.rice.krad.dao.PersistenceDao#isProxied(java.lang.Object)
	 */
	@Override
	public boolean isProxied(Object object) {
		return ProxyHelper.isProxy(object);
	}

}
