/*-
 * #%L
 * %%
 * Copyright (C) 2005 - 2025 Kuali, Inc. - All Rights Reserved
 * %%
 * You may use and modify this code under the terms of the Kuali, Inc.
 * Pre-Release License Agreement. You may not distribute it.
 * 
 * You should have received a copy of the Kuali, Inc. Pre-Release License
 * Agreement with this file. If not, please write to license@kuali.co.
 * #L%
 */

package org.kuali.rice.krad.dao.proxy;

import org.apache.commons.lang.StringUtils;
import org.apache.ojb.broker.core.proxy.ProxyHelper;
import org.kuali.rice.krad.bo.ModuleConfiguration;
import org.kuali.rice.krad.dao.PersistenceDao;
import org.kuali.rice.krad.dao.impl.PersistenceDaoOjb;
import org.kuali.rice.krad.service.KRADServiceLocatorWeb;
import org.kuali.rice.krad.service.KualiModuleService;
import org.kuali.rice.krad.service.ModuleService;
import org.kuali.rice.krad.util.LegacyUtils;
import org.kuali.rice.krad.util.ObjectUtils;
import org.springframework.transaction.annotation.Transactional;

import java.util.HashMap;

@Deprecated
@Transactional
public class PersistenceDaoProxy implements PersistenceDao {
	private PersistenceDao persistenceDaoOjb;
	private static KualiModuleService kualiModuleService;
	private static HashMap<String, PersistenceDao> persistenceDaoValues = new HashMap<String, PersistenceDao>();

	public void setPersistenceDaoOjb(PersistenceDao persistenceDaoOjb) {
		this.persistenceDaoOjb = persistenceDaoOjb;
	}
	
    private PersistenceDao getDao(Class clazz) {
        ModuleService moduleService = getKualiModuleService().getResponsibleModuleService(clazz);
        if (moduleService != null) {
            ModuleConfiguration moduleConfig = moduleService.getModuleConfiguration();
            String dataSourceName = "";
            if (moduleConfig != null) {
                dataSourceName = moduleConfig.getDataSourceName();
            }

            if (StringUtils.isNotEmpty(dataSourceName)) {
                if (persistenceDaoValues.get(dataSourceName) != null) {
                    return persistenceDaoValues.get(dataSourceName);
                } else {
                    //using OJB
                    PersistenceDaoOjb persistDaoOjb = new PersistenceDaoOjb();
                    persistDaoOjb.setJcdAlias(dataSourceName);

                    persistenceDaoValues.put(dataSourceName, persistDaoOjb);
                    return persistDaoOjb;
                }

            }
        }
    	return persistenceDaoOjb;
    }

	/**
     * @see org.kuali.rice.krad.dao.PersistenceDao#clearCache()
     */
    @Override
    public void clearCache() {
        persistenceDaoOjb.clearCache();
    }

    /**
     * @see org.kuali.rice.krad.dao.PersistenceDao#resolveProxy(java.lang.Object)
     */
    @Override
    public Object resolveProxy(Object o) {
    	return getDao(ObjectUtils.materializeClassForProxiedObject(o)).resolveProxy(o);
    }

    /**
     * @see org.kuali.rice.krad.dao.PersistenceDao#retrieveAllReferences(java.lang.Object)
     */
    @Override
    public void retrieveAllReferences(Object o) {
    	getDao(ObjectUtils.materializeClassForProxiedObject(o)).retrieveAllReferences(o);
    }

    /**
     * @see org.kuali.rice.krad.dao.PersistenceDao#retrieveReference(java.lang.Object, java.lang.String)
     */
    @Override
    public void retrieveReference(Object o, String referenceName) {
    	getDao(ObjectUtils.materializeClassForProxiedObject(o)).retrieveReference(o, referenceName);
    }
 
    /**
	 * Asks proper DAO implementation if the object is proxied
	 * 
	 * @see org.kuali.rice.krad.dao.PersistenceDao#isProxied(java.lang.Object)
	 */
	@Override
    public boolean isProxied(Object object) {
		//if (object instanceof HibernateProxy) return true;
		if (ProxyHelper.isProxy(object)) return true;
		return false;
	}

	private static KualiModuleService getKualiModuleService() {
        if (kualiModuleService == null) {
            kualiModuleService = KRADServiceLocatorWeb.getKualiModuleService();
        }
        return kualiModuleService;
    }
}
