/*-
 * #%L
 * %%
 * Copyright (C) 2005 - 2025 Kuali, Inc. - All Rights Reserved
 * %%
 * You may use and modify this code under the terms of the Kuali, Inc.
 * Pre-Release License Agreement. You may not distribute it.
 * 
 * You should have received a copy of the Kuali, Inc. Pre-Release License
 * Agreement with this file. If not, please write to license@kuali.co.
 * #L%
 */

package org.kuali.rice.core.framework.persistence.ojb.conversion;

import org.apache.ojb.broker.accesslayer.conversions.FieldConversion;

public abstract class OjbCharBooleanConversionBase implements FieldConversion {

    protected abstract String getTrueValue();

    protected abstract String getFalseValue();


    /**
     * @see FieldConversion#javaToSql(Object)
     */
    @Override
    public Object javaToSql(Object source) {
        Object result = source;
        if (source instanceof Boolean) {
            if (source != null) {
                Boolean b = (Boolean) source;
                result = b.booleanValue() ? getTrueValue() : getFalseValue();
            }
        }
        return result;
    }

    /**
     * @see FieldConversion#sqlToJava(Object)
     */
    @Override
    public Object sqlToJava(Object source) {
        Object result = source;
        if (source instanceof String) {
            if (source != null) {
                String s = (String) source;
                result = getTrueValue().equals(s) ? Boolean.TRUE : getFalseValue().equals(s) ? Boolean.FALSE : null;
                if (result == null) {
                    throw new RuntimeException("Expected '" + getTrueValue() + "' or '" + getFalseValue() + "' but saw '" + source + "'");
                }
            }
        }
        return result;
    }

}
