/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.rice.krad.exception;

import java.util.Collections;
import java.util.Map;
import org.kuali.rice.core.api.exception.KualiException;

public class AuthorizationException
extends KualiException {
    private static final long serialVersionUID = -3874239711783179351L;
    protected final String userId;
    protected final String action;
    protected final String targetType;
    protected final Map<String, Object> additionalDetails;

    public AuthorizationException(String userId, String action, String targetType) {
        this(userId, action, targetType, Collections.emptyMap());
    }

    public AuthorizationException(String userId, String action, String targetType, Map<String, Object> additionalDetails) {
        this(userId, action, targetType, "user '" + userId + "' is not authorized to take action '" + action + "' on targets of type '" + targetType + "'" + (additionalDetails != null && !additionalDetails.isEmpty() ? " Additional Details : " + additionalDetails : ""), additionalDetails);
    }

    public AuthorizationException(String userId, String action, String targetType, String message, Map<String, Object> additionalDetails) {
        super(message);
        this.userId = userId;
        this.action = action;
        this.targetType = targetType;
        this.additionalDetails = additionalDetails;
    }

    public String getUserId() {
        return this.userId;
    }

    public String getAction() {
        return this.action;
    }

    public String getTargetType() {
        return this.targetType;
    }

    public Map<String, Object> getAdditionalDetails() {
        return this.additionalDetails;
    }

    @Deprecated
    public String getErrorMessageKey() {
        return "error.authorization.general";
    }
}

