/*-
 * #%L
 * %%
 * Copyright (C) 2005 - 2024 Kuali, Inc. - All Rights Reserved
 * %%
 * You may use and modify this code under the terms of the Kuali, Inc.
 * Pre-Release License Agreement. You may not distribute it.
 * 
 * You should have received a copy of the Kuali, Inc. Pre-Release License
 * Agreement with this file. If not, please write to license@kuali.co.
 * #L%
 */

package org.kuali.rice.krad.bo;

import org.kuali.rice.core.api.mo.common.active.MutableInactivatable;

import java.sql.Timestamp;

/**
 * Business objects that have effective dating (from to dates) should implement this interface. This
 * translates the effective dates in terms of active/inactive status so the features built for
 * {@link MutableInactivatable} in the frameworks can be taken advantage of
 */
public interface InactivatableFromTo extends MutableInactivatable {

	/**
	 * Sets the date for which record will be active
	 * 
	 * @param from
	 *            - Timestamp value to set
	 */
	public void setActiveFromDate(Timestamp from);
	
	/**
	 * Gets the date for which the record become active
	 *
	 * @return Timestamp
	 */
	public Timestamp getActiveFromDate();

	/**
	 * Sets the date for which record will be active to
	 * 
	 * @param from
	 *            - Timestamp value to set
	 */
	public void setActiveToDate(Timestamp to);
	
	/**
	 * Gets the date for which the record become inactive
	 *
	 * @return Timestamp
	 */
	public Timestamp getActiveToDate();

	/**
	 * Gets the date for which the record is being compared to in determining active/inactive
	 * 
	 * @return Timestamp
	 */
	public Timestamp getActiveAsOfDate();

	/**
	 * Sets the date for which the record should be compared to in determining active/inactive, if
	 * not set then the current date will be used
	 * 
	 * @param activeAsOfDate
	 *            - Timestamp value to set
	 */
	public void setActiveAsOfDate(Timestamp activeAsOfDate);

}
