/*-
 * #%L
 * %%
 * Copyright (C) 2005 - 2024 Kuali, Inc. - All Rights Reserved
 * %%
 * You may use and modify this code under the terms of the Kuali, Inc.
 * Pre-Release License Agreement. You may not distribute it.
 * 
 * You should have received a copy of the Kuali, Inc. Pre-Release License
 * Agreement with this file. If not, please write to license@kuali.co.
 * #L%
 */

package org.kuali.rice.krad.exception;

import org.kuali.rice.core.api.util.RiceKeyConstants;

import java.util.Collections;
import java.util.Map;

/**
 * Represents an exception that is thrown when a given user is not authorized to take a given action on the given
 * document type
 *
 * @author Kuali Rice Team (rice.collab@kuali.org)
 */
public class DocumentTypeAuthorizationException extends AuthorizationException {
    private static final long serialVersionUID = 1548057953855152103L;

    public DocumentTypeAuthorizationException(String userId, String action, String documentType) {
        this(userId, action, documentType, Collections.<String, Object>emptyMap());
    }

    public DocumentTypeAuthorizationException(String userId, String action, String documentType,
            Map<String, Object> requestAuthDetails) {
        super(userId, action, documentType, requestAuthDetails);
    }

    /**
     * @see AuthorizationException#getErrorMessageKey()
     */
    @Override
    public String getErrorMessageKey() {
        return RiceKeyConstants.AUTHORIZATION_ERROR_DOCTYPE;
    }
}
