/*-
 * #%L
 * %%
 * Copyright (C) 2005 - 2024 Kuali, Inc. - All Rights Reserved
 * %%
 * You may use and modify this code under the terms of the Kuali, Inc.
 * Pre-Release License Agreement. You may not distribute it.
 * 
 * You should have received a copy of the Kuali, Inc. Pre-Release License
 * Agreement with this file. If not, please write to license@kuali.co.
 * #L%
 */

package org.kuali.rice.krad.exception;

import org.kuali.rice.core.framework.persistence.jta.NoRollbackRuntimeException;

/**
 * @author Kuali Rice Team (rice.collab@kuali.org)
 */
public class ValidationException extends NoRollbackRuntimeException {
    private static final long serialVersionUID = 2098470374196729509L;

    /**
     * Create an ValidationException with the given message
     *
     * @param message
     */
    public ValidationException(String message) {
        super(message);
    }

    /**
     * Create an ValidationException with the given message and cause
     *
     * @param message
     * @param cause
     */
    public ValidationException(String message, Throwable cause) {
        super(message, cause);
    }
}
