/*-
 * #%L
 * %%
 * Copyright (C) 2005 - 2024 Kuali, Inc. - All Rights Reserved
 * %%
 * You may use and modify this code under the terms of the Kuali, Inc.
 * Pre-Release License Agreement. You may not distribute it.
 * 
 * You should have received a copy of the Kuali, Inc. Pre-Release License
 * Agreement with this file. If not, please write to license@kuali.co.
 * #L%
 */

package org.kuali.rice.krad.util;

import org.kuali.rice.core.api.mo.common.Coded;

/**
 * Defines the different types of Notes which can be used with the notes
 * and attachments framework. 
 * 
 * @author Kuali Rice Team (rice.collab@kuali.org)
 *
 */
public enum NoteType implements Coded {
    
	BUSINESS_OBJECT("BO"), DOCUMENT_HEADER("DH");
    
	private final String noteTypeCode;

    private NoteType(String noteTypeCode) {
        this.noteTypeCode = noteTypeCode;
    }

    @Override
    public String getCode() {
        return this.noteTypeCode;
    }

}
