/*-
 * #%L
 * %%
 * Copyright (C) 2005 - 2024 Kuali, Inc. - All Rights Reserved
 * %%
 * You may use and modify this code under the terms of the Kuali, Inc.
 * Pre-Release License Agreement. You may not distribute it.
 * 
 * You should have received a copy of the Kuali, Inc. Pre-Release License
 * Agreement with this file. If not, please write to license@kuali.co.
 * #L%
 */

package org.kuali.rice.krad.util;

import java.io.Serializable;
import java.util.Map;

/**
 * Holds information on an action (ticket type name) and context (ticketContext) that has been performed and can be placed in the
 * UserSession objectMap. This can be checked for by subsequent session requests to determine if the action has already taken place (for
 * example a Question or document action where the action is not recorded on the document or form).
 */
public class SessionTicket implements Serializable {
	private String ticketTypeName;
	private Map<String, String> ticketContext;

	public SessionTicket(String ticketTypeName) {
		this.ticketTypeName = ticketTypeName;
	}

	public String getTicketTypeName() {
		return this.ticketTypeName;
	}

	public void setTicketTypeName(String ticketTypeName) {
		this.ticketTypeName = ticketTypeName;
	}

	public Map<String, String> getTicketContext() {
		return this.ticketContext;
	}

	public void setTicketContext(Map<String, String> ticketContext) {
		this.ticketContext = ticketContext;
	}
}
