/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.rice.krad.util;

import java.beans.PropertyDescriptor;
import java.io.Serializable;
import java.lang.reflect.InvocationTargetException;
import java.util.Collections;
import java.util.Comparator;
import java.util.Iterator;
import java.util.List;
import org.apache.commons.beanutils.PropertyUtils;
import org.apache.commons.collections.comparators.ComparableComparator;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.kuali.rice.core.api.exception.KualiException;
import org.kuali.rice.core.api.util.type.TypeUtils;

public class BeanPropertyComparator
implements Comparator,
Serializable {
    private static final Logger LOG = LogManager.getLogger(BeanPropertyComparator.class);
    private static final long serialVersionUID = -2675700473766186018L;
    boolean ignoreCase;
    private List propertyNames;
    private Comparator stringComparator;
    private Comparator booleanComparator;
    private Comparator genericComparator;

    public BeanPropertyComparator(List propertyNames) {
        this(propertyNames, true);
    }

    public BeanPropertyComparator(List propertyNames, boolean ignoreCase) {
        if (propertyNames == null) {
            throw new IllegalArgumentException("invalid (null) propertyNames list");
        }
        if (propertyNames.size() == 0) {
            throw new IllegalArgumentException("invalid (empty) propertyNames list");
        }
        this.propertyNames = Collections.unmodifiableList(propertyNames);
        this.ignoreCase = ignoreCase;
        this.stringComparator = ignoreCase ? String.CASE_INSENSITIVE_ORDER : ComparableComparator.getInstance();
        this.booleanComparator = new Comparator(this){

            public int compare(Object o1, Object o2) {
                int compared = 0;
                Boolean b1 = (Boolean)o1;
                Boolean b2 = (Boolean)o2;
                if (!b1.equals(b2)) {
                    compared = b1.equals(Boolean.FALSE) ? -1 : 1;
                }
                return compared;
            }
        };
        this.genericComparator = ComparableComparator.getInstance();
    }

    public int compare(Object o1, Object o2) {
        int compared = 0;
        try {
            Iterator i = this.propertyNames.iterator();
            while (compared == 0 && i.hasNext()) {
                String currentProperty = i.next().toString();
                Comparator currentComparator = null;
                try {
                    PropertyDescriptor propertyDescriptor = PropertyUtils.getPropertyDescriptor((Object)o1, (String)currentProperty);
                    Class<?> propertyClass = propertyDescriptor.getPropertyType();
                    currentComparator = propertyClass.equals(String.class) ? this.stringComparator : (TypeUtils.isBooleanClass(propertyClass) ? this.booleanComparator : this.genericComparator);
                }
                catch (NullPointerException e) {
                    LOG.info("unable to find property '" + o1.getClass().getName() + "." + currentProperty + "'", (Throwable)e);
                    compared = -999;
                }
                Object value1 = PropertyUtils.getProperty((Object)o1, (String)currentProperty);
                Object value2 = PropertyUtils.getProperty((Object)o2, (String)currentProperty);
                if (value1 == null && value2 == null) {
                    return 0;
                }
                if (value1 == null) {
                    return -1;
                }
                if (value2 == null) {
                    return 1;
                }
                compared = currentComparator.compare(value1, value2);
            }
        }
        catch (IllegalAccessException e) {
            throw new BeanComparisonException("unable to compare property values", e);
        }
        catch (NoSuchMethodException e) {
            throw new BeanComparisonException("unable to compare property values", e);
        }
        catch (InvocationTargetException e) {
            LOG.error("unable to compare property values", e.getCause());
            compared = -999;
        }
        return compared;
    }

    public static class BeanComparisonException
    extends KualiException {
        private static final long serialVersionUID = 2622379680100640029L;

        public BeanComparisonException(String message, Throwable t) {
            super(message, t);
        }
    }
}

