/*-
 * #%L
 * %%
 * Copyright (C) 2005 - 2025 Kuali, Inc. - All Rights Reserved
 * %%
 * You may use and modify this code under the terms of the Kuali, Inc.
 * Pre-Release License Agreement. You may not distribute it.
 * 
 * You should have received a copy of the Kuali, Inc. Pre-Release License
 * Agreement with this file. If not, please write to license@kuali.co.
 * #L%
 */

package org.kuali.rice.krad.exception;

/**
 * This class used by Kuali's Pessimistic Locking mechanism
 * 
 * @author Kuali Rice Team (rice.collab@kuali.org)
 *
 */
public class PessimisticLockingException extends RuntimeException {

    private static final long serialVersionUID = -6565593932651796413L;

    /**
     * This constructs a {@link PessimisticLockingException} object to be used
     * but the system's manual pessimistic locking mechanism
     * 
     * @param message - the message that defines the exception
     */
    public PessimisticLockingException(String message) {
        super(message);
    }

}
