/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.rice.krad.data.provider.impl;

import com.google.common.base.Predicate;
import com.google.common.collect.Iterables;
import com.google.common.collect.LinkedHashMultimap;
import com.google.common.collect.Multimap;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import org.apache.commons.lang.ClassUtils;
import org.apache.commons.lang.Validate;
import org.apache.log4j.Logger;
import org.kuali.rice.krad.data.DataObjectService;
import org.kuali.rice.krad.data.KradDataServiceLocator;
import org.kuali.rice.krad.data.provider.MetadataProvider;
import org.kuali.rice.krad.data.provider.PersistenceProvider;
import org.kuali.rice.krad.data.provider.Provider;
import org.kuali.rice.krad.data.provider.ProviderRegistry;
import org.springframework.aop.framework.Advised;
import org.springframework.aop.support.AopUtils;

public class ProviderRegistryImpl
implements ProviderRegistry {
    private static final Logger LOG = Logger.getLogger(ProviderRegistry.class);
    private static final String GET_DATA_OBJECT_SERVICE_METHOD_NAME = "getDataObjectService";
    private static final String SET_DATA_OBJECT_SERVICE_METHOD_NAME = "setDataObjectService";
    private final Multimap<Class<? extends Provider>, Provider> providersByType = LinkedHashMultimap.create();

    protected Iterable<Class<? extends Provider>> enumerateProviderInterfaces(Provider provider) {
        List interfaces = ClassUtils.getAllInterfaces(provider.getClass());
        Iterable providerInterfaces = Iterables.filter((Iterable)interfaces, (Predicate)new Predicate<Class>(){

            public boolean apply(Class input) {
                return Provider.class.isAssignableFrom(input);
            }
        });
        return providerInterfaces;
    }

    @Override
    public synchronized void registerProvider(Provider provider) {
        Validate.notNull((Object)provider, (String)"Provider must be non-null");
        if (this.hasDataObjectServiceMethod(provider, GET_DATA_OBJECT_SERVICE_METHOD_NAME, new Class[0])) {
            this.injectDataObjectService(provider);
        }
        for (Class<? extends Provider> providerInterface : this.enumerateProviderInterfaces(provider)) {
            this.providersByType.put(providerInterface, (Object)provider);
        }
    }

    @Override
    public synchronized boolean unregisterProvider(Provider provider) {
        Validate.notNull((Object)provider, (String)"Provider must be non-null");
        boolean removed = false;
        Collection providers = this.providersByType.values();
        while (providers.remove(provider)) {
            removed = true;
        }
        return removed;
    }

    @Override
    public synchronized List<Provider> getProviders() {
        return Collections.unmodifiableList(new ArrayList(this.providersByType.get(Provider.class)));
    }

    @Override
    public synchronized List<Provider> getProvidersForType(Class<? extends Provider> providerType) {
        Validate.isTrue((providerType != null ? 1 : 0) != 0, (String)"Provider type must be non-null");
        return Collections.unmodifiableList(new ArrayList(this.providersByType.get(providerType)));
    }

    @Override
    public synchronized List<MetadataProvider> getMetadataProviders() {
        Collection metadataProviders = this.providersByType.get(MetadataProvider.class);
        return Collections.unmodifiableList(new ArrayList(metadataProviders));
    }

    @Override
    public synchronized PersistenceProvider getPersistenceProvider(Class<?> type) {
        Validate.notNull(type, (String)"Data object type must be non-null");
        Collection persistenceProviders = this.providersByType.get(PersistenceProvider.class);
        for (Provider provider : persistenceProviders) {
            PersistenceProvider persistenceProvider = (PersistenceProvider)provider;
            if (!persistenceProvider.handles(type)) continue;
            return persistenceProvider;
        }
        return null;
    }

    @Override
    public MetadataProvider getMetadataProvider(Class<?> type) {
        Validate.notNull(type, (String)"Data object type must be non-null");
        List<MetadataProvider> metadataProviders = this.getMetadataProviders();
        for (MetadataProvider provider : metadataProviders) {
            if (!provider.handles(type)) continue;
            return provider;
        }
        return null;
    }

    protected boolean hasDataObjectServiceMethod(Provider provider, String methodName, Class[] args) {
        Method methodToFind;
        try {
            methodToFind = this.unwrapProxy(provider).getClass().getMethod(methodName, args);
        }
        catch (Exception e) {
            return false;
        }
        return methodToFind != null;
    }

    private Object unwrapProxy(Object bean) throws Exception {
        if (AopUtils.isAopProxy((Object)bean) && bean instanceof Advised) {
            Advised advised = (Advised)bean;
            bean = advised.getTargetSource().getTarget();
        }
        return bean;
    }

    private void injectDataObjectService(Provider provider) {
        try {
            Method getterMethod = this.unwrapProxy(provider).getClass().getMethod(GET_DATA_OBJECT_SERVICE_METHOD_NAME, new Class[0]);
            if (getterMethod.invoke(this.unwrapProxy(provider), new Object[0]) == null && this.hasDataObjectServiceMethod(provider, SET_DATA_OBJECT_SERVICE_METHOD_NAME, new Class[]{DataObjectService.class})) {
                Method setterMethod = this.unwrapProxy(provider).getClass().getMethod(SET_DATA_OBJECT_SERVICE_METHOD_NAME, DataObjectService.class);
                setterMethod.invoke(this.unwrapProxy(provider), KradDataServiceLocator.getDataObjectService());
            }
        }
        catch (Exception e) {
            LOG.warn((Object)("Error injecting DataObjectService while registering provider:  " + provider.getClass()));
        }
    }
}

