/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.rice.krad.data.jpa;

import java.util.Arrays;
import java.util.List;
import java.util.Map;
import javax.persistence.EntityManagerFactory;
import javax.persistence.Persistence;
import org.apache.commons.lang3.StringUtils;
import org.junit.Assert;
import org.junit.BeforeClass;
import org.junit.Test;
import org.kuali.rice.core.api.data.DataType;
import org.kuali.rice.krad.data.jpa.eclipselink.EclipseLinkJpaMetadataProviderImpl;
import org.kuali.rice.krad.data.jpa.testbo.CollectionDataObject;
import org.kuali.rice.krad.data.jpa.testbo.TestDataObject;
import org.kuali.rice.krad.data.jpa.testbo.TestDataObjectExtension;
import org.kuali.rice.krad.data.jpa.testbo.TestDataObjectTwoPkFields;
import org.kuali.rice.krad.data.jpa.testbo.TestNonPersistableObject;
import org.kuali.rice.krad.data.metadata.DataObjectAttribute;
import org.kuali.rice.krad.data.metadata.DataObjectAttributeRelationship;
import org.kuali.rice.krad.data.metadata.DataObjectCollection;
import org.kuali.rice.krad.data.metadata.DataObjectMetadata;
import org.kuali.rice.krad.data.metadata.DataObjectRelationship;
import org.kuali.rice.krad.data.metadata.MetadataChild;

public class JpaMetadataProviderTest {
    static EclipseLinkJpaMetadataProviderImpl metadataProvider;

    @BeforeClass
    public static void setUpBeforeClass() throws Exception {
        metadataProvider = new EclipseLinkJpaMetadataProviderImpl();
        EntityManagerFactory entityManagerFactory = Persistence.createEntityManagerFactory((String)"krad-data-unit-test");
        metadataProvider.setEntityManager(entityManagerFactory.createEntityManager());
    }

    @Test
    public void testGetMetadataForType() throws Exception {
        DataObjectMetadata metadata = metadataProvider.getMetadataForType(TestDataObject.class);
        Assert.assertNotNull((String)"Returned metadata should not be null", (Object)metadata);
        metadata = metadataProvider.getMetadataForType(Class.forName("org.kuali.rice.krad.data.jpa.testbo.TestDataObject"));
        Assert.assertNotNull((String)"Returned metadata should not be null", (Object)metadata);
    }

    @Test
    public void testGetAllMetadata() throws Exception {
        Map metadata = metadataProvider.provideMetadata();
        Assert.assertNotNull((String)"Returned metadata should not be null", (Object)metadata);
        Assert.assertFalse((String)"metadata map should not have been empty", (boolean)metadata.isEmpty());
        Assert.assertTrue((String)"Should have had an entry for TestDataObject", (boolean)metadata.containsKey(TestDataObject.class));
        Assert.assertTrue((String)"Should have had an entry for TestDataObject (when class name specified)", (boolean)metadata.containsKey(Class.forName("org.kuali.rice.krad.data.jpa.testbo.TestDataObject")));
    }

    @Test
    public void testGetMetadataForClass_ClassData() {
        DataObjectMetadata metadata = metadataProvider.getMetadataForType(TestDataObject.class);
        System.err.println(metadata);
        Assert.assertEquals((String)"Incorrect Data Object Type", TestDataObject.class, (Object)metadata.getType());
        Assert.assertEquals((String)"Incorrect Type Label", (Object)"Test Data Object", (Object)metadata.getLabel());
        Assert.assertEquals((String)"Table name not set as the backing object name", (Object)"KRTST_TEST_TABLE_T", (Object)metadata.getBackingObjectName());
    }

    @Test
    public void testGetMetadataForClass_VersionAttribute() {
        DataObjectMetadata metadata = metadataProvider.getMetadataForType(TestDataObject.class);
        Assert.assertEquals((String)"Incorrect Version Setting on TestDataObject", (Object)Boolean.FALSE, (Object)metadata.isSupportsOptimisticLocking());
        metadata = metadataProvider.getMetadataForType(TestDataObjectTwoPkFields.class);
        Assert.assertEquals((String)"Incorrect Version Setting on TestDataObjectTwoPkFields", (Object)Boolean.TRUE, (Object)metadata.isSupportsOptimisticLocking());
    }

    @Test
    public void testGetMetadataForClass_Attributes() {
        DataObjectMetadata metadata = metadataProvider.getMetadataForType(TestDataObject.class);
        List attributes = metadata.getAttributes();
        System.err.println(attributes);
        Assert.assertNotNull((String)"Returned attributes should not have been null", (Object)attributes);
        Assert.assertFalse((String)"Returned attributes should not have been empty", (boolean)attributes.isEmpty());
        DataObjectAttribute firstAttribute = metadata.getAttribute("primaryKeyProperty");
        Assert.assertEquals((String)"property name incorrect", (Object)"primaryKeyProperty", (Object)firstAttribute.getName());
        Assert.assertEquals((String)"Property label incorrect", (Object)"Primary Key Property", (Object)firstAttribute.getLabel());
        Assert.assertEquals((String)"Column name not set as the backing object name", (Object)"PK_PROP", (Object)firstAttribute.getBackingObjectName());
    }

    @Test
    public void testGetMetadataForClass_Attribute_Types() {
        DataObjectMetadata metadata = metadataProvider.getMetadataForType(TestDataObject.class);
        DataObjectAttribute attribute = metadata.getAttribute("stringProperty");
        Assert.assertEquals((String)"property DataType incorrect", (Object)DataType.STRING, (Object)attribute.getDataType());
        attribute = metadata.getAttribute("dateProperty");
        Assert.assertEquals((String)"property DataType incorrect", (Object)DataType.DATE, (Object)attribute.getDataType());
        attribute = metadata.getAttribute("currencyProperty");
        Assert.assertEquals((String)"property DataType incorrect", (Object)DataType.CURRENCY, (Object)attribute.getDataType());
    }

    @Test
    public void testGetMetadataForClass_Attribute_Type_Unknown() {
        DataObjectMetadata metadata = metadataProvider.getMetadataForType(TestDataObject.class);
        DataObjectAttribute attribute = metadata.getAttribute("nonStandardDataType");
        Assert.assertEquals((String)"nonStandardDataType property DataType incorrect", (Object)DataType.STRING, (Object)attribute.getDataType());
    }

    @Test
    public void testGetMetadataForClass_Attribute_Non_OJB_Property() {
        DataObjectMetadata metadata = metadataProvider.getMetadataForType(TestDataObject.class);
        DataObjectAttribute attribute = metadata.getAttribute("nonPersistedProperty");
        Assert.assertNull((String)"nonPersistedProperty should not exist", (Object)attribute);
    }

    @Test
    public void testGetMetadataForCollection() {
        DataObjectMetadata metadata = metadataProvider.getMetadataForType(TestDataObject.class);
        List collections = metadata.getCollections();
        Assert.assertNotNull((String)"Collections object should not be null", (Object)collections);
        Assert.assertEquals((String)"Collections size incorrect", (long)4L, (long)collections.size());
        List<String> collectionNames = Arrays.asList(((DataObjectCollection)collections.get(0)).getName(), ((DataObjectCollection)collections.get(1)).getName(), ((DataObjectCollection)collections.get(2)).getName(), ((DataObjectCollection)collections.get(3)).getName());
        int index = collectionNames.indexOf("collectionProperty");
        Assert.assertTrue((index > -1 && index < 4 ? 1 : 0) != 0);
        DataObjectCollection collection = (DataObjectCollection)collections.get(index);
        Assert.assertEquals((String)"property name incorrect", (Object)"collectionProperty", (Object)collection.getName());
        Assert.assertEquals((String)"collection backing object incorrect", (Object)"KRTST_TEST_COLL_T", (Object)collection.getBackingObjectName());
        Assert.assertEquals((String)"collection label incorrect", (Object)"Collection Property", (Object)collection.getLabel());
        Assert.assertEquals((String)"collection item label incorrect", (Object)"Collection Data Object", (Object)collection.getElementLabel());
        collection = metadata.getCollection("collectionPropertyTwo");
        Assert.assertNotNull((String)"Collection object for collectionPropertyTwo should not be null", (Object)collection);
        Assert.assertEquals((String)"property name incorrect", (Object)"collectionPropertyTwo", (Object)collection.getName());
        Assert.assertNotNull((String)"attribute relationships must not be null", (Object)collection.getAttributeRelationships());
        Assert.assertEquals((String)"attribute relationships size incorrect", (long)1L, (long)collection.getAttributeRelationships().size());
        DataObjectAttributeRelationship relationship = (DataObjectAttributeRelationship)collection.getAttributeRelationships().get(0);
        Assert.assertEquals((String)"parent attribute name mismatch", (Object)"stringProperty", (Object)relationship.getParentAttributeName());
        Assert.assertEquals((String)"child attribute name mismatch", (Object)"primaryKeyPropertyUsingDifferentName", (Object)relationship.getChildAttributeName());
        Assert.assertNotNull((String)"collection default sort list must not be null", (Object)collection.getDefaultOrdering());
        Assert.assertEquals((String)"collection default sort size incorrect", (long)1L, (long)collection.getDefaultOrdering().size());
    }

    @Test
    public void testGetMetadataForCollection_Indirect() {
        DataObjectMetadata metadata = metadataProvider.getMetadataForType(TestDataObject.class);
        DataObjectCollection collection = metadata.getCollection("indirectCollection");
        Assert.assertNotNull((String)"Collection object for indirectCollection should not be null", (Object)collection);
        Assert.assertTrue((String)"Should be labeled as indirect", (boolean)collection.isIndirectCollection());
        Assert.assertTrue((String)"attribute relationship list should be empty: collection.getAttributeRelationships()", (boolean)collection.getAttributeRelationships().isEmpty());
    }

    @Test
    public void testGetMetadataForRelationship_referencedObject_main() {
        DataObjectMetadata metadata = metadataProvider.getMetadataForType(TestDataObject.class);
        List relationships = metadata.getRelationships();
        System.err.println(relationships);
        Assert.assertNotNull((String)"Relationships object should not be null", (Object)relationships);
        Assert.assertEquals((String)"Relationships size incorrect", (long)4L, (long)relationships.size());
        DataObjectRelationship relationship = metadata.getRelationship("referencedObject");
        Assert.assertNotNull((String)"retrieval by property name failed", (Object)relationship);
        Assert.assertEquals((String)"property name incorrect", (Object)"referencedObject", (Object)relationship.getName());
        Assert.assertEquals((String)"collection backing object incorrect", (Object)"KRTST_TEST_REF_OBJ_T", (Object)relationship.getBackingObjectName());
        Assert.assertEquals((String)"collection label incorrect", (Object)"Referenced Object", (Object)relationship.getLabel());
    }

    @Test
    public void testGetMetadataForRelationship_referencedObject_properties() {
        DataObjectMetadata metadata = metadataProvider.getMetadataForType(TestDataObject.class);
        DataObjectRelationship relationship = metadata.getRelationship("referencedObject");
        Assert.assertNotNull((String)"retrieval by property name failed", (Object)relationship);
        Assert.assertTrue((String)"relationship should have been proxied", (boolean)relationship.isLoadedDynamicallyUponUse());
        Assert.assertFalse((String)"loaded with parent should be false", (boolean)relationship.isLoadedAtParentLoadTime());
        Assert.assertFalse((String)"saved with parent should be false", (boolean)relationship.isSavedWithParent());
        Assert.assertFalse((String)"deleted with parent should be false", (boolean)relationship.isDeletedWithParent());
        Assert.assertTrue((String)"read-only should be true", (boolean)relationship.isReadOnly());
    }

    @Test
    public void testGetMetadataForRelationship_referencedObject_attributes() {
        DataObjectMetadata metadata = metadataProvider.getMetadataForType(TestDataObject.class);
        DataObjectRelationship relationship = metadata.getRelationship("referencedObject");
        Assert.assertNotNull((String)"retrieval by property name failed", (Object)relationship);
        Assert.assertNotNull((String)"attribute relationships must not be null", (Object)relationship.getAttributeRelationships());
        Assert.assertEquals((String)"attribute relationships size incorrect", (long)1L, (long)relationship.getAttributeRelationships().size());
        DataObjectAttributeRelationship linkingAttributes = (DataObjectAttributeRelationship)relationship.getAttributeRelationships().get(0);
        Assert.assertEquals((String)"parent attribute name mismatch", (Object)"stringProperty", (Object)linkingAttributes.getParentAttributeName());
        Assert.assertEquals((String)"child attribute name mismatch", (Object)"stringProperty", (Object)linkingAttributes.getChildAttributeName());
    }

    @Test
    public void testGetMetadataForRelationship_anotherReferencedObject_main() {
        DataObjectMetadata metadata = metadataProvider.getMetadataForType(TestDataObject.class);
        DataObjectRelationship relationship = metadata.getRelationship("anotherReferencedObject");
        Assert.assertNotNull((String)"retrieval by property name failed", (Object)relationship);
        System.err.println("anotherReferencedObject: " + relationship);
        Assert.assertEquals((String)"property name incorrect", (Object)"anotherReferencedObject", (Object)relationship.getName());
        Assert.assertEquals((String)"collection backing object incorrect", (Object)"KRTST_TEST_ANOTHER_REF_OBJ_T", (Object)relationship.getBackingObjectName());
        Assert.assertEquals((String)"collection label incorrect", (Object)"Another Referenced Object", (Object)relationship.getLabel());
    }

    @Test
    public void testGetMetadataForRelationship_anotherReferencedObject_properties() {
        DataObjectMetadata metadata = metadataProvider.getMetadataForType(TestDataObject.class);
        DataObjectRelationship relationship = metadata.getRelationship("anotherReferencedObject");
        Assert.assertNotNull((String)"retrieval by property name failed", (Object)relationship);
        System.err.println("anotherReferencedObject: " + relationship);
        Assert.assertFalse((String)"relationship should not have been proxied", (boolean)relationship.isLoadedDynamicallyUponUse());
        Assert.assertTrue((String)"loaded with parent should be true", (boolean)relationship.isLoadedAtParentLoadTime());
        Assert.assertFalse((String)"saved with parent should be false", (boolean)relationship.isSavedWithParent());
        Assert.assertFalse((String)"deleted with parent should be false", (boolean)relationship.isDeletedWithParent());
        Assert.assertTrue((String)"read-only should be true", (boolean)relationship.isReadOnly());
    }

    @Test
    public void testGetMetadataForRelationship_anotherReferencedObject_attributes() {
        DataObjectMetadata metadata = metadataProvider.getMetadataForType(TestDataObject.class);
        DataObjectRelationship relationship = metadata.getRelationship("anotherReferencedObject");
        Assert.assertNotNull((String)"retrieval by property name failed", (Object)relationship);
        System.err.println("anotherReferencedObject: " + relationship);
        Assert.assertNotNull((String)"attribute relationships must not be null", (Object)relationship.getAttributeRelationships());
        Assert.assertEquals((String)"attribute relationships size incorrect", (long)2L, (long)relationship.getAttributeRelationships().size());
        DataObjectAttributeRelationship linkingAttribute = (DataObjectAttributeRelationship)relationship.getAttributeRelationships().get(0);
        if (StringUtils.equals((CharSequence)linkingAttribute.getParentAttributeName(), (CharSequence)"stringProperty")) {
            Assert.assertEquals((String)"first parent attribute name mismatch", (Object)"stringProperty", (Object)linkingAttribute.getParentAttributeName());
            Assert.assertEquals((String)"first child attribute name mismatch", (Object)"stringProperty", (Object)linkingAttribute.getChildAttributeName());
            linkingAttribute = (DataObjectAttributeRelationship)relationship.getAttributeRelationships().get(1);
            Assert.assertEquals((String)"second parent attribute name mismatch", (Object)"dateProperty", (Object)linkingAttribute.getParentAttributeName());
            Assert.assertEquals((String)"second child attribute name mismatch", (Object)"dateProperty", (Object)linkingAttribute.getChildAttributeName());
        } else {
            Assert.assertEquals((String)"second parent attribute name mismatch", (Object)"dateProperty", (Object)linkingAttribute.getParentAttributeName());
            Assert.assertEquals((String)"second child attribute name mismatch", (Object)"dateProperty", (Object)linkingAttribute.getChildAttributeName());
            linkingAttribute = (DataObjectAttributeRelationship)relationship.getAttributeRelationships().get(1);
            Assert.assertEquals((String)"first parent attribute name mismatch", (Object)"stringProperty", (Object)linkingAttribute.getParentAttributeName());
            Assert.assertEquals((String)"first child attribute name mismatch", (Object)"stringProperty", (Object)linkingAttribute.getChildAttributeName());
        }
    }

    @Test
    public void testGetMetadataForRelationship_yetAnotherReferencedObject_main() {
        DataObjectMetadata metadata = metadataProvider.getMetadataForType(TestDataObject.class);
        DataObjectRelationship relationship = metadata.getRelationship("anotherReferencedObject");
        Assert.assertNotNull((String)"retrieval by property name failed", (Object)relationship);
        System.err.println("anotherReferencedObject: " + relationship);
        Assert.assertEquals((String)"property name incorrect", (Object)"anotherReferencedObject", (Object)relationship.getName());
        Assert.assertEquals((String)"collection backing object incorrect", (Object)"KRTST_TEST_ANOTHER_REF_OBJ_T", (Object)relationship.getBackingObjectName());
        Assert.assertEquals((String)"collection label incorrect", (Object)"Another Referenced Object", (Object)relationship.getLabel());
    }

    @Test
    public void testGetMetadataForRelationship_yetAnotherReferencedObject_properties() {
        DataObjectMetadata metadata = metadataProvider.getMetadataForType(TestDataObject.class);
        DataObjectRelationship relationship = metadata.getRelationship("anotherReferencedObject");
        Assert.assertNotNull((String)"retrieval by property name failed", (Object)relationship);
        System.err.println("anotherReferencedObject: " + relationship);
        Assert.assertFalse((String)"relationship should not have been proxied", (boolean)relationship.isLoadedDynamicallyUponUse());
        Assert.assertTrue((String)"loaded with parent should be true", (boolean)relationship.isLoadedAtParentLoadTime());
        Assert.assertFalse((String)"saved with parent should be false", (boolean)relationship.isSavedWithParent());
        Assert.assertFalse((String)"deleted with parent should be false", (boolean)relationship.isDeletedWithParent());
        Assert.assertTrue((String)"read-only should be true", (boolean)relationship.isReadOnly());
    }

    @Test
    public void testGetMetadataForRelationship_yetAnotherReferencedObject_attributes() {
        DataObjectMetadata metadata = metadataProvider.getMetadataForType(TestDataObject.class);
        DataObjectRelationship relationship = metadata.getRelationship("anotherReferencedObject");
        Assert.assertNotNull((String)"retrieval by property name failed", (Object)relationship);
        System.err.println("anotherReferencedObject: " + relationship);
        Assert.assertNotNull((String)"attribute relationships must not be null", (Object)relationship.getAttributeRelationships());
        Assert.assertEquals((String)"attribute relationships size incorrect", (long)2L, (long)relationship.getAttributeRelationships().size());
        DataObjectAttributeRelationship linkingAttribute = (DataObjectAttributeRelationship)relationship.getAttributeRelationships().get(0);
        if (StringUtils.equals((CharSequence)linkingAttribute.getParentAttributeName(), (CharSequence)"stringProperty")) {
            Assert.assertEquals((String)"first parent attribute name mismatch", (Object)"stringProperty", (Object)linkingAttribute.getParentAttributeName());
            Assert.assertEquals((String)"first child attribute name mismatch", (Object)"stringProperty", (Object)linkingAttribute.getChildAttributeName());
            linkingAttribute = (DataObjectAttributeRelationship)relationship.getAttributeRelationships().get(1);
            Assert.assertEquals((String)"second parent attribute name mismatch", (Object)"dateProperty", (Object)linkingAttribute.getParentAttributeName());
            Assert.assertEquals((String)"second child attribute name mismatch", (Object)"dateProperty", (Object)linkingAttribute.getChildAttributeName());
        } else {
            Assert.assertEquals((String)"second parent attribute name mismatch", (Object)"dateProperty", (Object)linkingAttribute.getParentAttributeName());
            Assert.assertEquals((String)"second child attribute name mismatch", (Object)"dateProperty", (Object)linkingAttribute.getChildAttributeName());
            linkingAttribute = (DataObjectAttributeRelationship)relationship.getAttributeRelationships().get(1);
            Assert.assertEquals((String)"first parent attribute name mismatch", (Object)"stringProperty", (Object)linkingAttribute.getParentAttributeName());
            Assert.assertEquals((String)"first child attribute name mismatch", (Object)"stringProperty", (Object)linkingAttribute.getChildAttributeName());
        }
    }

    @Test
    public void testGetMetadataForRelationship_extension() {
        DataObjectMetadata metadata = metadataProvider.getMetadataForType(TestDataObject.class);
        DataObjectRelationship relationship = metadata.getRelationship("extension");
        Assert.assertNotNull((String)"retrieval by property name failed", (Object)relationship);
        Assert.assertTrue((String)"Should have no attribute relationships.", (boolean)relationship.getAttributeRelationships().isEmpty());
        Assert.assertTrue((String)"should be loaded with parent", (boolean)relationship.isLoadedAtParentLoadTime());
        Assert.assertFalse((String)"should NOT be proxied", (boolean)relationship.isLoadedDynamicallyUponUse());
        Assert.assertFalse((String)"should NOT be read-only", (boolean)relationship.isReadOnly());
        Assert.assertTrue((String)"should be saved with parent", (boolean)relationship.isSavedWithParent());
        Assert.assertTrue((String)"should be deleted with parent", (boolean)relationship.isDeletedWithParent());
        Assert.assertEquals((String)"Should be related to TestDataObjectExtension", TestDataObjectExtension.class, (Object)relationship.getRelatedType());
        MetadataChild inverse = relationship.getInverseRelationship();
        Assert.assertNotNull((String)"extension relationship should have an inverse relationship", (Object)inverse);
        Assert.assertTrue((String)"Inverse should be a relationship and not a collection.", (boolean)(inverse instanceof DataObjectRelationship));
    }

    @Test
    public void testGetMetadataForRelationship_byLastAttribute_stringProperty() {
        DataObjectMetadata metadata = metadataProvider.getMetadataForType(TestDataObject.class);
        DataObjectRelationship relationship = metadata.getRelationshipByLastAttributeInRelationship("stringProperty");
        Assert.assertNotNull((String)"retrieval by last attribute name (stringProperty) failed", (Object)relationship);
        Assert.assertEquals((String)"retrieval by last attribute name (stringProperty) returned wrong relationship", (Object)"referencedObject", (Object)relationship.getName());
    }

    @Test
    public void testGetMetadataForRelationship_byLastAttribute_dateProperty() {
        DataObjectMetadata metadata = metadataProvider.getMetadataForType(TestDataObject.class);
        DataObjectRelationship relationship = metadata.getRelationshipByLastAttributeInRelationship("dateProperty");
        Assert.assertNotNull((String)"retrieval by last attribute name (dateProperty) failed", (Object)relationship);
        Assert.assertEquals((String)"retrieval by last attribute name (dateProperty) returned wrong relationship", (Object)"anotherReferencedObject", (Object)relationship.getName());
    }

    @Test
    public void testGetMetadataForRelationship_byLastAttribute_primaryKeyProperty() {
        DataObjectMetadata metadata = metadataProvider.getMetadataForType(TestDataObject.class);
        DataObjectRelationship relationship = metadata.getRelationshipByLastAttributeInRelationship("primaryKeyProperty");
        Assert.assertNotNull((String)"retrieval by last attribute name (primaryKeyProperty) failed", (Object)relationship);
        Assert.assertEquals((String)"retrieval by last attribute name (primaryKeyProperty) returned wrong relationship", (Object)"yetAnotherReferencedObject", (Object)relationship.getName());
    }

    @Test
    public void testGetMetadataForRelationship_byInvolvedAttribute() {
        DataObjectMetadata metadata = metadataProvider.getMetadataForType(TestDataObject.class);
        List rels = metadata.getRelationshipsInvolvingAttribute("stringProperty");
        Assert.assertNotNull((String)"retrieval by attribute name (stringProperty) failed", (Object)rels);
        Assert.assertEquals((String)"retrieval by attribute name (stringProperty): wrong number returned", (long)2L, (long)rels.size());
        rels = metadata.getRelationshipsInvolvingAttribute("dateProperty");
        Assert.assertNotNull((String)"retrieval by attribute name (dateProperty) failed", (Object)rels);
        Assert.assertEquals((String)"retrieval by attribute name (dateProperty): wrong number returned", (long)1L, (long)rels.size());
    }

    @Test
    public void testGetMetadataForClass_PKFields() {
        DataObjectMetadata metadata = metadataProvider.getMetadataForType(TestDataObject.class);
        Assert.assertNotNull((String)"PK field list should not have been null", (Object)metadata.getPrimaryKeyAttributeNames());
        Assert.assertEquals((String)"PK field list length incorrect", (long)1L, (long)metadata.getPrimaryKeyAttributeNames().size());
        Assert.assertEquals((String)"PK field wrong", (Object)"primaryKeyProperty", metadata.getPrimaryKeyAttributeNames().get(0));
        Assert.assertEquals((String)"Primary Display Field Wrong", (Object)"primaryKeyProperty", (Object)metadata.getPrimaryDisplayAttributeName());
    }

    @Test
    public void testGetMetadataForClass_PKFields_TwoFieldIdClass() {
        DataObjectMetadata metadata = metadataProvider.getMetadataForType(TestDataObjectTwoPkFields.class);
        Assert.assertNotNull((String)"PK field list should not have been null", (Object)metadata.getPrimaryKeyAttributeNames());
        System.err.println("PK Properties: " + metadata.getPrimaryKeyAttributeNames());
        Assert.assertEquals((String)"PK field list length incorrect", (long)2L, (long)metadata.getPrimaryKeyAttributeNames().size());
        Assert.assertEquals((String)"PK field 1 wrong", (Object)"primaryKeyProperty", metadata.getPrimaryKeyAttributeNames().get(0));
        Assert.assertEquals((String)"PK field 2 wrong", (Object)"primaryKeyPropertyTwo", metadata.getPrimaryKeyAttributeNames().get(1));
        Assert.assertEquals((String)"Primary Display Field Wrong", (Object)"primaryKeyPropertyTwo", (Object)metadata.getPrimaryDisplayAttributeName());
    }

    @Test
    public void testGetMetadataForClass_PKFields_TwoFieldNoIdClass() {
        DataObjectMetadata metadata = metadataProvider.getMetadataForType(CollectionDataObject.class);
        Assert.assertNotNull((String)"PK field list should not have been null", (Object)metadata.getPrimaryKeyAttributeNames());
        System.err.println("PK Properties: " + metadata.getPrimaryKeyAttributeNames());
        Assert.assertEquals((String)"PK field list length incorrect", (long)2L, (long)metadata.getPrimaryKeyAttributeNames().size());
        Assert.assertEquals((String)"PK field 1 wrong", (Object)"primaryKeyProperty", metadata.getPrimaryKeyAttributeNames().get(0));
        Assert.assertEquals((String)"PK field 2 wrong", (Object)"collectionKeyProperty", metadata.getPrimaryKeyAttributeNames().get(1));
        Assert.assertEquals((String)"Primary Display Field Wrong", (Object)"collectionKeyProperty", (Object)metadata.getPrimaryDisplayAttributeName());
    }

    @Test
    public void testIsClassPersistable_ValidType() {
        Assert.assertTrue((String)"TestDataObject should have been persistable", (boolean)metadataProvider.handles(TestDataObject.class));
    }

    @Test
    public void testIsClassPersistable_InvalidType() {
        Assert.assertFalse((String)"TestNonPersistableObject should not have been persistable", (boolean)metadataProvider.handles(TestNonPersistableObject.class));
    }

    @Test
    public void testAttributeSecurityIfEncrypted() {
        DataObjectMetadata metadata = metadataProvider.getMetadataForType(TestDataObject.class);
        DataObjectAttribute attribute = metadata.getAttribute("encryptedProperty");
        Assert.assertNotNull((String)"encryptedProperty Missing", (Object)attribute);
        Assert.assertTrue((String)"sensitive property not set on encryptedProperty", (boolean)attribute.isSensitive());
    }
}

