/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.rice.krad.data.jpa;

import java.util.List;
import javax.persistence.Query;
import org.kuali.rice.core.api.criteria.CountFlag;
import org.kuali.rice.core.api.criteria.GenericQueryResults;
import org.kuali.rice.core.api.criteria.QueryByCriteria;
import org.kuali.rice.krad.data.jpa.CriteriaQuery;
import org.kuali.rice.krad.data.jpa.QueryTranslator;

abstract class DataObjectCriteriaQueryBase<C, Q>
implements CriteriaQuery {
    DataObjectCriteriaQueryBase() {
    }

    protected abstract QueryTranslator<C, Q> getQueryTranslator();

    protected abstract int getRowCount(Q var1);

    protected abstract int getIncludedRowCount(Q var1, List var2);

    protected abstract <T> List<T> getResults(Q var1);

    protected abstract int executeUpdate(Query var1);

    @Override
    public <T> void deleteMatching(Class<T> type, QueryByCriteria criteria) {
        if (type == null) {
            throw new IllegalArgumentException("class type is null");
        }
        if (criteria == null || criteria.getPredicate() == null) {
            throw new IllegalArgumentException("criteria is null");
        }
        C parent = this.getQueryTranslator().translateCriteria(type, criteria);
        Query query = this.getQueryTranslator().createDeletionQuery(type, parent);
        this.executeUpdate(query);
    }

    @Override
    public <T> void deleteAll(Class<T> type) {
        if (type == null) {
            throw new IllegalArgumentException("class type is null");
        }
        C parent = this.getQueryTranslator().translateCriteria(type, QueryByCriteria.Builder.create().build());
        Query query = this.getQueryTranslator().createDeletionQuery(type, parent);
        this.executeUpdate(query);
    }

    @Override
    public <T> GenericQueryResults<T> lookup(Class<T> queryClass, QueryByCriteria criteria) {
        if (queryClass == null) {
            throw new IllegalArgumentException("queryClass is null");
        }
        if (criteria == null) {
            throw new IllegalArgumentException("criteria is null");
        }
        C parent = this.getQueryTranslator().translateCriteria(queryClass, criteria);
        switch (criteria.getCountFlag()) {
            case ONLY: {
                return this.forCountOnly(queryClass, criteria, parent);
            }
            case NONE: {
                return this.forRowResults(queryClass, criteria, parent, criteria.getCountFlag());
            }
            case INCLUDE: {
                return this.forRowResults(queryClass, criteria, parent, criteria.getCountFlag());
            }
        }
        throw new UnsupportedCountFlagException(criteria.getCountFlag());
    }

    protected <T> GenericQueryResults<T> forRowResults(Class<T> queryClass, QueryByCriteria criteria, C ojbCriteria, CountFlag flag) {
        Q query = this.getQueryTranslator().createQuery(queryClass, ojbCriteria);
        GenericQueryResults.Builder results = GenericQueryResults.Builder.create();
        this.getQueryTranslator().convertQueryFlags(criteria, query);
        List<T> rows = this.getResults(query);
        if (flag == CountFlag.INCLUDE) {
            results.setTotalRowCount(Integer.valueOf(this.getIncludedRowCount(query, rows)));
        }
        if (criteria.getMaxResults() != null && rows.size() > criteria.getMaxResults()) {
            results.setMoreResultsAvailable(true);
            rows.remove(criteria.getMaxResults());
        }
        results.setResults(rows);
        return results.build();
    }

    protected <T> GenericQueryResults<T> forCountOnly(Class<T> queryClass, QueryByCriteria criteria, C platformCriteria) {
        Q query = this.getQueryTranslator().createQuery(queryClass, platformCriteria);
        GenericQueryResults.Builder results = GenericQueryResults.Builder.create();
        results.setTotalRowCount(Integer.valueOf(this.getRowCount(query)));
        return results.build();
    }

    protected static class UnsupportedCountFlagException
    extends RuntimeException {
        protected UnsupportedCountFlagException(CountFlag flag) {
            super("Unsupported predicate [" + String.valueOf(flag) + "]");
        }
    }
}

