/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.rice.krad.data.jpa.eclipselink;

import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import javax.persistence.Entity;
import javax.persistence.EntityManager;
import javax.persistence.EntityManagerFactory;
import javax.persistence.FetchType;
import javax.persistence.Id;
import javax.persistence.ManyToOne;
import javax.persistence.metamodel.EntityType;
import javax.persistence.spi.PersistenceUnitInfo;
import javax.persistence.spi.PersistenceUnitTransactionType;
import javax.sql.DataSource;
import javax.transaction.TransactionManager;
import javax.transaction.UserTransaction;
import org.apache.commons.dbcp.BasicDataSource;
import org.eclipse.persistence.internal.jpa.EntityManagerFactoryDelegate;
import org.eclipse.persistence.internal.jpa.EntityManagerFactoryImpl;
import org.eclipse.persistence.jpa.JpaEntityManager;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.kuali.rice.core.api.config.property.Config;
import org.kuali.rice.core.api.config.property.ConfigContext;
import org.kuali.rice.core.framework.config.property.SimpleConfig;
import org.kuali.rice.core.framework.persistence.jta.Jta;
import org.kuali.rice.krad.data.jpa.KradEntityManagerFactoryBean;
import org.kuali.rice.krad.data.jpa.eclipselink.KradEclipseLinkEntityManagerFactoryBean;
import org.kuali.rice.krad.data.jpa.eclipselink.testentities.TestEntity;
import org.mockito.Mock;
import org.mockito.runners.MockitoJUnitRunner;
import org.springframework.context.support.ClassPathXmlApplicationContext;
import org.springframework.instrument.classloading.SimpleInstrumentableClassLoader;
import org.springframework.orm.jpa.persistenceunit.MutablePersistenceUnitInfo;
import org.springframework.orm.jpa.persistenceunit.PersistenceUnitPostProcessor;

@RunWith(value=MockitoJUnitRunner.class)
public class KradEclipseLinkEntityManagerFactoryBeanTest {
    @Mock
    TransactionManager transactionManager;
    @Mock
    UserTransaction userTransaction;
    private ClassPathXmlApplicationContext context;
    private EntityManagerFactory entityManagerFactory;

    @Before
    public void setUp() throws Exception {
        this.initializeConfig();
    }

    @After
    public void tearDown() throws Exception {
        if (this.context != null) {
            this.context.destroy();
        }
        ConfigContext.destroy();
    }

    private void initializeConfig() {
        SimpleConfig config = new SimpleConfig();
        config.putProperty("rice.krad.jpa.global.randomProperty", "randomValue");
        config.putProperty("rice.krad.jpa.global.eclipselink.weaving", "false");
        ConfigContext.init((Config)config);
    }

    private void loadContext(String springXmlFile) throws Exception {
        this.context = new ClassPathXmlApplicationContext(springXmlFile, this.getClass());
        Map factories = this.context.getBeansOfType(EntityManagerFactory.class);
        Assert.assertEquals((long)1L, (long)factories.size());
        this.entityManagerFactory = (EntityManagerFactory)factories.values().iterator().next();
    }

    @Test
    public void testMinimal() throws Exception {
        this.loadContext(this.getClass().getSimpleName() + "_Minimal.xml");
        Set minimalEntities = this.entityManagerFactory.getMetamodel().getEntities();
        Assert.assertEquals((long)0L, (long)minimalEntities.size());
        EntityManager entityManager = this.entityManagerFactory.createEntityManager();
        entityManager.close();
        Assert.assertFalse((boolean)this.isJtaEnabled());
    }

    @Test
    public void testFull() throws Exception {
        this.loadContext(this.getClass().getSimpleName() + "_Full.xml");
        Set fullEntities = this.entityManagerFactory.getMetamodel().getEntities();
        Assert.assertEquals((long)5L, (long)fullEntities.size());
        HashSet<Class> entityClasses = new HashSet<Class>();
        for (EntityType entityType : fullEntities) {
            entityClasses.add(entityType.getJavaType());
        }
        Assert.assertTrue((boolean)entityClasses.contains(TestEntity.class));
        Assert.assertTrue((boolean)entityClasses.contains(TestEntity1.class));
        Assert.assertTrue((boolean)entityClasses.contains(TestEntity2.class));
        Assert.assertTrue((boolean)entityClasses.contains(TestEntity3.class));
        Assert.assertTrue((boolean)entityClasses.contains(TestEntity4.class));
        Assert.assertFalse((boolean)this.isJtaEnabled());
    }

    @Test
    public void testJta() throws Exception {
        Jta.configure((TransactionManager)this.transactionManager, (UserTransaction)this.userTransaction);
        try {
            this.loadContext(this.getClass().getSimpleName() + "_Jta.xml");
            Assert.assertTrue((String)"JTA should be enabled.", (boolean)this.isJtaEnabled());
        }
        finally {
            Jta.reset();
        }
    }

    @Test
    public void testLoadTimeWeaving() throws Exception {
        this.loadContext(this.getClass().getSimpleName() + "_LoadTimeWeaving.xml");
        EntityManagerFactoryDelegate delegate = (EntityManagerFactoryDelegate)this.entityManagerFactory.unwrap(EntityManagerFactoryDelegate.class);
        PersistenceUnitInfo info = delegate.getSetupImpl().getPersistenceUnitInfo();
        Assert.assertTrue((boolean)(info.getClassLoader() instanceof SimpleInstrumentableClassLoader));
    }

    @Test(expected=IllegalStateException.class)
    public void testInvalidDataSourceConfiguration() throws Exception {
        KradEntityManagerFactoryBean factoryBean = new KradEntityManagerFactoryBean();
        factoryBean.setDataSource((DataSource)new BasicDataSource());
        factoryBean.setJtaDataSource((DataSource)new BasicDataSource());
        factoryBean.afterPropertiesSet();
    }

    @Test
    public void testGetDataSource() throws Exception {
        KradEclipseLinkEntityManagerFactoryBean factoryBean = new KradEclipseLinkEntityManagerFactoryBean();
        BasicDataSource dataSourceNonJta = new BasicDataSource();
        factoryBean.setDataSource((DataSource)dataSourceNonJta);
        Assert.assertEquals((Object)dataSourceNonJta, (Object)factoryBean.getDataSource());
        BasicDataSource dataSourceJta = new BasicDataSource();
        factoryBean.setJtaDataSource((DataSource)dataSourceJta);
        Assert.assertEquals((Object)dataSourceJta, (Object)factoryBean.getDataSource());
    }

    @Test
    public void testVariousGetters() throws Exception {
        this.loadContext(this.getClass().getSimpleName() + "_LoadTimeWeaving.xml");
        KradEclipseLinkEntityManagerFactoryBean factoryBean = (KradEclipseLinkEntityManagerFactoryBean)this.context.getBean(KradEclipseLinkEntityManagerFactoryBean.class);
        Assert.assertNotNull((Object)factoryBean);
        Assert.assertEquals((long)2L, (long)factoryBean.getPersistenceUnitPostProcessors().length);
        EntityManagerFactory entityManagerFactory = factoryBean.getNativeEntityManagerFactory();
        Assert.assertTrue((boolean)(entityManagerFactory instanceof EntityManagerFactoryImpl));
        Assert.assertEquals((Object)factoryBean.getBeanClassLoader(), (Object)this.getClass().getClassLoader());
        Assert.assertEquals(JpaEntityManager.class, (Object)factoryBean.getEntityManagerInterface());
    }

    private boolean isJtaEnabled() throws Exception {
        EntityManagerFactoryDelegate delegate = (EntityManagerFactoryDelegate)this.entityManagerFactory.unwrap(EntityManagerFactoryDelegate.class);
        PersistenceUnitInfo info = delegate.getSetupImpl().getPersistenceUnitInfo();
        return info.getJtaDataSource() != null && info.getTransactionType() == PersistenceUnitTransactionType.JTA;
    }

    @Entity
    public static final class TestEntity5 {
        @Id
        private String id;
        @ManyToOne(fetch=FetchType.LAZY)
        private TestEntity3 testEntity3;
    }

    public static final class TestEntity4 {
        private String id;
    }

    @Entity
    public static final class TestEntity3 {
        @Id
        private String id;
    }

    @Entity
    public static final class TestEntity2 {
        @Id
        private String id;
    }

    @Entity
    public static final class TestEntity1 {
        @Id
        private String id;
    }

    public static final class TestPersistenceUnitPostProcessor
    implements PersistenceUnitPostProcessor {
        public void postProcessPersistenceUnitInfo(MutablePersistenceUnitInfo pui) {
            pui.getManagedClassNames().add(TestEntity3.class.getName());
        }
    }
}

