/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.rice.krad.data.provider;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Random;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.TimeUnit;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.kuali.rice.krad.data.provider.MetadataProvider;
import org.kuali.rice.krad.data.provider.PersistenceProvider;
import org.kuali.rice.krad.data.provider.Provider;
import org.kuali.rice.krad.data.provider.ProviderRegistry;
import org.kuali.rice.krad.data.provider.impl.ProviderRegistryImpl;
import org.mockito.Matchers;
import org.mockito.Mockito;

public class ProviderRegistryImplTest {
    private static Class<A> TYPE_A = A.class;
    private static Class<B> TYPE_B = B.class;
    private ProviderRegistry registry;

    @Before
    public void setup() {
        this.registry = new ProviderRegistryImpl();
    }

    @Test
    public void testEmpty() {
        junit.framework.Assert.assertEquals((int)0, (int)this.registry.getProviders().size());
        junit.framework.Assert.assertEquals((int)0, (int)this.registry.getMetadataProviders().size());
        junit.framework.Assert.assertEquals((int)0, (int)this.registry.getProvidersForType(MetadataProvider.class).size());
        junit.framework.Assert.assertEquals((int)0, (int)this.registry.getProvidersForType(PersistenceProvider.class).size());
        junit.framework.Assert.assertEquals((int)0, (int)this.registry.getProvidersForType(CustomProvider.class).size());
        Assert.assertNull((Object)this.registry.getPersistenceProvider(String.class));
    }

    @Test(expected=IllegalArgumentException.class)
    public void testRegisterProviderIllegalArgument() {
        this.registry.registerProvider(null);
    }

    @Test(expected=IllegalArgumentException.class)
    public void testUnregisterProviderIllegalArgument() {
        this.registry.unregisterProvider(null);
    }

    @Test(expected=IllegalArgumentException.class)
    public void testGetProvidersForTypeIllegalArgument() {
        this.registry.getProvidersForType(null);
    }

    @Test(expected=IllegalArgumentException.class)
    public void testGetPersistenceProviderIllegalArgument() {
        this.registry.getPersistenceProvider(null);
    }

    @Test
    public void testRegisterProviders() {
        this.registry.registerProvider((Provider)Mockito.mock(Provider.class));
        junit.framework.Assert.assertEquals((int)1, (int)this.registry.getProviders().size());
        junit.framework.Assert.assertEquals((int)0, (int)this.registry.getMetadataProviders().size());
        junit.framework.Assert.assertEquals((int)0, (int)this.registry.getProvidersForType(MetadataProvider.class).size());
        junit.framework.Assert.assertEquals((int)0, (int)this.registry.getProvidersForType(PersistenceProvider.class).size());
        junit.framework.Assert.assertEquals((int)0, (int)this.registry.getProvidersForType(CustomProvider.class).size());
        Assert.assertNull((Object)this.registry.getPersistenceProvider(String.class));
        MetadataProvider mockMetadataProvider = (MetadataProvider)Mockito.mock(MetadataProvider.class);
        Mockito.when((Object)mockMetadataProvider.handles((Class)Matchers.any(Class.class))).thenReturn((Object)true);
        this.registry.registerProvider((Provider)mockMetadataProvider);
        junit.framework.Assert.assertEquals((int)2, (int)this.registry.getProviders().size());
        junit.framework.Assert.assertEquals((int)1, (int)this.registry.getMetadataProviders().size());
        junit.framework.Assert.assertEquals((int)1, (int)this.registry.getProvidersForType(MetadataProvider.class).size());
        junit.framework.Assert.assertEquals((int)0, (int)this.registry.getProvidersForType(PersistenceProvider.class).size());
        junit.framework.Assert.assertEquals((int)0, (int)this.registry.getProvidersForType(CustomProvider.class).size());
        Assert.assertNull((Object)this.registry.getPersistenceProvider(String.class));
        Assert.assertSame((Object)mockMetadataProvider, (Object)this.registry.getMetadataProvider(String.class));
        junit.framework.Assert.assertEquals((int)2, (int)this.registry.getProviders().size());
        junit.framework.Assert.assertEquals((int)1, (int)this.registry.getMetadataProviders().size());
        junit.framework.Assert.assertEquals((int)1, (int)this.registry.getProvidersForType(MetadataProvider.class).size());
        junit.framework.Assert.assertEquals((int)0, (int)this.registry.getProvidersForType(PersistenceProvider.class).size());
        junit.framework.Assert.assertEquals((int)0, (int)this.registry.getProvidersForType(CustomProvider.class).size());
        Assert.assertNull((Object)this.registry.getPersistenceProvider(String.class));
        Assert.assertSame((Object)mockMetadataProvider, (Object)this.registry.getMetadataProvider(String.class));
        PersistenceProvider pp = (PersistenceProvider)Mockito.mock(PersistenceProvider.class);
        Mockito.when((Object)pp.handles(TYPE_B)).thenReturn((Object)true);
        this.registry.registerProvider((Provider)pp);
        junit.framework.Assert.assertEquals((int)3, (int)this.registry.getProviders().size());
        junit.framework.Assert.assertEquals((int)1, (int)this.registry.getMetadataProviders().size());
        junit.framework.Assert.assertEquals((int)1, (int)this.registry.getProvidersForType(MetadataProvider.class).size());
        junit.framework.Assert.assertEquals((int)1, (int)this.registry.getProvidersForType(PersistenceProvider.class).size());
        junit.framework.Assert.assertEquals((int)0, (int)this.registry.getProvidersForType(CustomProvider.class).size());
        Assert.assertNull((Object)this.registry.getPersistenceProvider(String.class));
        Assert.assertSame((Object)pp, (Object)this.registry.getPersistenceProvider(B.class));
        Assert.assertSame((Object)mockMetadataProvider, (Object)this.registry.getMetadataProvider(String.class));
        this.registry.registerProvider((Provider)Mockito.mock(CustomProvider.class));
        junit.framework.Assert.assertEquals((int)4, (int)this.registry.getProviders().size());
        junit.framework.Assert.assertEquals((int)1, (int)this.registry.getMetadataProviders().size());
        junit.framework.Assert.assertEquals((int)1, (int)this.registry.getProvidersForType(MetadataProvider.class).size());
        junit.framework.Assert.assertEquals((int)1, (int)this.registry.getProvidersForType(PersistenceProvider.class).size());
        junit.framework.Assert.assertEquals((int)1, (int)this.registry.getProvidersForType(CustomProvider.class).size());
        Assert.assertNull((Object)this.registry.getPersistenceProvider(String.class));
        Assert.assertSame((Object)pp, (Object)this.registry.getPersistenceProvider(B.class));
        Assert.assertSame((Object)mockMetadataProvider, (Object)this.registry.getMetadataProvider(String.class));
        this.registry.registerProvider((Provider)Mockito.mock(MultiProvider.class));
        junit.framework.Assert.assertEquals((int)5, (int)this.registry.getProviders().size());
        junit.framework.Assert.assertEquals((int)2, (int)this.registry.getMetadataProviders().size());
        junit.framework.Assert.assertEquals((int)2, (int)this.registry.getProvidersForType(MetadataProvider.class).size());
        junit.framework.Assert.assertEquals((int)2, (int)this.registry.getProvidersForType(PersistenceProvider.class).size());
        junit.framework.Assert.assertEquals((int)2, (int)this.registry.getProvidersForType(CustomProvider.class).size());
        Assert.assertNull((Object)this.registry.getPersistenceProvider(String.class));
        Assert.assertSame((Object)pp, (Object)this.registry.getPersistenceProvider(B.class));
        Assert.assertSame((Object)mockMetadataProvider, (Object)this.registry.getMetadataProvider(String.class));
    }

    @Test
    public void testRegisterDuplicateProviders() {
        Provider p = (Provider)Mockito.mock(Provider.class);
        MetadataProvider mp1 = (MetadataProvider)Mockito.mock(MetadataProvider.class);
        MetadataProvider mp2 = (MetadataProvider)Mockito.mock(MetadataProvider.class);
        this.registry.registerProvider(p);
        junit.framework.Assert.assertEquals((int)1, (int)this.registry.getProviders().size());
        this.registry.registerProvider(p);
        junit.framework.Assert.assertEquals((int)1, (int)this.registry.getProviders().size());
        this.registry.registerProvider((Provider)mp1);
        junit.framework.Assert.assertEquals((int)2, (int)this.registry.getProviders().size());
        junit.framework.Assert.assertEquals((int)1, (int)this.registry.getMetadataProviders().size());
        this.registry.registerProvider((Provider)mp1);
        junit.framework.Assert.assertEquals((int)2, (int)this.registry.getProviders().size());
        junit.framework.Assert.assertEquals((int)1, (int)this.registry.getMetadataProviders().size());
        this.registry.registerProvider((Provider)mp2);
        junit.framework.Assert.assertEquals((int)3, (int)this.registry.getProviders().size());
        junit.framework.Assert.assertEquals((int)2, (int)this.registry.getMetadataProviders().size());
        this.registry.registerProvider((Provider)mp2);
        junit.framework.Assert.assertEquals((int)3, (int)this.registry.getProviders().size());
        junit.framework.Assert.assertEquals((int)2, (int)this.registry.getMetadataProviders().size());
    }

    @Test
    public void testRegisterUnregister() {
        Provider a = (Provider)Mockito.mock(Provider.class);
        Provider b = (Provider)Mockito.mock(Provider.class);
        Provider c = (Provider)Mockito.mock(Provider.class);
        Provider d = (Provider)Mockito.mock(Provider.class);
        this.registry.registerProvider(a);
        this.registry.registerProvider(b);
        this.registry.registerProvider(c);
        this.registry.registerProvider(d);
        junit.framework.Assert.assertEquals((int)4, (int)this.registry.getProviders().size());
        this.registry.unregisterProvider(c);
        this.registry.unregisterProvider(b);
        this.registry.unregisterProvider(d);
        this.registry.unregisterProvider(a);
        junit.framework.Assert.assertEquals((int)0, (int)this.registry.getProviders().size());
    }

    @Test
    public void testConcurrency() throws InterruptedException {
        final Class[] TYPES = new Class[]{Provider.class, MetadataProvider.class, PersistenceProvider.class, CustomProvider.class};
        int providers = 50;
        int threads = providers * 2;
        final LinkedBlockingQueue queue = new LinkedBlockingQueue();
        ExecutorService threadpool = Executors.newFixedThreadPool(threads);
        final Random random = new Random(System.currentTimeMillis());
        Object[] producers = new Callable[providers];
        Object[] consumers = new Callable[providers];
        Callable<Object> producer = new Callable<Object>(){

            @Override
            public Object call() throws Exception {
                Provider p = (Provider)Mockito.mock((Class)TYPES[random.nextInt(5)]);
                ProviderRegistryImplTest.this.registry.registerProvider(p);
                queue.add(p);
                return null;
            }
        };
        Callable<Object> consumer = new Callable<Object>(){

            @Override
            public Object call() throws Exception {
                Provider p = (Provider)queue.take();
                ProviderRegistryImplTest.this.registry.unregisterProvider(p);
                return null;
            }
        };
        Arrays.fill(producers, producer);
        Arrays.fill(consumers, consumer);
        ArrayList<Object> tasks = new ArrayList<Object>(providers * 2);
        tasks.addAll(Arrays.asList(producers));
        tasks.addAll(Arrays.asList(consumers));
        Collections.shuffle(tasks);
        System.out.println("Registering and unregistering " + providers + " providers");
        threadpool.invokeAll(tasks, 10L, TimeUnit.SECONDS);
        junit.framework.Assert.assertEquals((int)0, (int)this.registry.getProviders().size());
    }

    @Test
    public void testRegisterPersistenceProviders() {
        PersistenceProvider mockA = (PersistenceProvider)Mockito.mock(PersistenceProvider.class);
        Mockito.when((Object)mockA.handles((Class)Matchers.eq(TYPE_A))).thenReturn((Object)true);
        PersistenceProvider mockB = (PersistenceProvider)Mockito.mock(PersistenceProvider.class);
        Mockito.when((Object)mockB.handles((Class)Matchers.eq(TYPE_B))).thenReturn((Object)true);
        PersistenceProvider mockAB = (PersistenceProvider)Mockito.mock(PersistenceProvider.class);
        Mockito.when((Object)mockAB.handles((Class)Matchers.eq(TYPE_A))).thenReturn((Object)true);
        Mockito.when((Object)mockAB.handles((Class)Matchers.eq(TYPE_B))).thenReturn((Object)true);
        this.registry.registerProvider((Provider)mockA);
        junit.framework.Assert.assertEquals((int)1, (int)this.registry.getProviders().size());
        junit.framework.Assert.assertEquals((int)0, (int)this.registry.getMetadataProviders().size());
        junit.framework.Assert.assertEquals((int)1, (int)this.registry.getProvidersForType(PersistenceProvider.class).size());
        junit.framework.Assert.assertEquals((int)0, (int)this.registry.getProvidersForType(MetadataProvider.class).size());
        junit.framework.Assert.assertEquals((int)0, (int)this.registry.getProvidersForType(CustomProvider.class).size());
        Assert.assertSame((Object)mockA, (Object)this.registry.getPersistenceProvider(A.class));
        this.registry.registerProvider((Provider)mockB);
        junit.framework.Assert.assertEquals((int)2, (int)this.registry.getProviders().size());
        junit.framework.Assert.assertEquals((int)0, (int)this.registry.getMetadataProviders().size());
        junit.framework.Assert.assertEquals((int)2, (int)this.registry.getProvidersForType(PersistenceProvider.class).size());
        junit.framework.Assert.assertEquals((int)0, (int)this.registry.getProvidersForType(MetadataProvider.class).size());
        junit.framework.Assert.assertEquals((int)0, (int)this.registry.getProvidersForType(CustomProvider.class).size());
        Assert.assertSame((Object)mockA, (Object)this.registry.getPersistenceProvider(A.class));
        Assert.assertSame((Object)mockB, (Object)this.registry.getPersistenceProvider(B.class));
        this.registry.registerProvider((Provider)mockAB);
        junit.framework.Assert.assertEquals((int)3, (int)this.registry.getProviders().size());
        junit.framework.Assert.assertEquals((int)0, (int)this.registry.getMetadataProviders().size());
        junit.framework.Assert.assertEquals((int)3, (int)this.registry.getProvidersForType(PersistenceProvider.class).size());
        junit.framework.Assert.assertEquals((int)0, (int)this.registry.getProvidersForType(MetadataProvider.class).size());
        junit.framework.Assert.assertEquals((int)0, (int)this.registry.getProvidersForType(CustomProvider.class).size());
        Assert.assertSame((Object)mockA, (Object)this.registry.getPersistenceProvider(A.class));
        Assert.assertSame((Object)mockB, (Object)this.registry.getPersistenceProvider(B.class));
    }

    private static class B {
        private B() {
        }
    }

    private static class A {
        private A() {
        }
    }

    private static interface MultiProvider
    extends PersistenceProvider,
    MetadataProvider,
    CustomProvider {
    }

    private static interface CustomProvider
    extends Provider {
    }
}

