/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.rice.krad.data.platform;

import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.SQLException;
import javax.sql.DataSource;
import org.apache.commons.lang.StringUtils;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.kuali.rice.core.api.config.property.Config;
import org.kuali.rice.core.api.config.property.ConfigContext;
import org.kuali.rice.core.framework.config.property.SimpleConfig;
import org.kuali.rice.krad.data.platform.MaxValueIncrementerFactory;
import org.kuali.rice.krad.data.platform.UnsupportedDatabasePlatformException;
import org.mockito.Mock;
import org.mockito.Mockito;
import org.mockito.runners.MockitoJUnitRunner;
import org.springframework.jdbc.support.incrementer.DataFieldMaxValueIncrementer;
import org.springframework.jdbc.support.incrementer.OracleSequenceMaxValueIncrementer;

@RunWith(value=MockitoJUnitRunner.class)
public class MaxValueIncrementerFactoryTest {
    @Mock
    private DataSource mysql;
    @Mock
    private DataSource oracle;
    @Mock
    private DataSource bad;

    @Before
    public void setUp() throws Exception {
        this.setUpMetaData(this.mysql, "MySQL", 5);
        this.setUpMetaData(this.oracle, "Oracle", 11);
        this.setUpMetaData(this.bad, "BAD!!!!!", 1);
    }

    private void setUpMetaData(DataSource dataSource, String platformName, int version) throws SQLException {
        DatabaseMetaData metaData = (DatabaseMetaData)Mockito.mock(DatabaseMetaData.class);
        Mockito.when((Object)metaData.getDatabaseProductName()).thenReturn((Object)platformName);
        Mockito.when((Object)metaData.getDatabaseMajorVersion()).thenReturn((Object)version);
        Connection connection = (Connection)Mockito.mock(Connection.class);
        Mockito.when((Object)connection.getMetaData()).thenReturn((Object)metaData);
        Mockito.when((Object)dataSource.getConnection()).thenReturn((Object)connection);
    }

    @Test
    public void testGetIncrementer_Oracle() throws Exception {
        DataFieldMaxValueIncrementer incrementer = MaxValueIncrementerFactory.getIncrementer((DataSource)this.oracle, (String)"MY_SEQUENCE");
        Assert.assertTrue((boolean)(incrementer instanceof OracleSequenceMaxValueIncrementer));
        OracleSequenceMaxValueIncrementer oracleIncrementer = (OracleSequenceMaxValueIncrementer)incrementer;
        Assert.assertEquals((Object)"MY_SEQUENCE", (Object)oracleIncrementer.getIncrementerName());
        Assert.assertSame((Object)incrementer, (Object)MaxValueIncrementerFactory.getIncrementer((DataSource)this.oracle, (String)"MY_SEQUENCE"));
        Assert.assertNotSame((Object)incrementer, (Object)MaxValueIncrementerFactory.getIncrementer((DataSource)this.oracle, (String)"MY_SEQUENCE_2"));
    }

    @Test
    public void testGetIncrementer_MySQL() throws Exception {
        DataFieldMaxValueIncrementer incrementer = MaxValueIncrementerFactory.getIncrementer((DataSource)this.mysql, (String)"MY_SEQUENCE");
        Assert.assertTrue((boolean)(incrementer instanceof MaxValueIncrementerFactory.EnhancedMySQLMaxValueIncrementer));
        MaxValueIncrementerFactory.EnhancedMySQLMaxValueIncrementer mysqlIncrementer = (MaxValueIncrementerFactory.EnhancedMySQLMaxValueIncrementer)incrementer;
        Assert.assertEquals((Object)"MY_SEQUENCE", (Object)mysqlIncrementer.getIncrementerName());
        Assert.assertEquals((Object)"ID", (Object)mysqlIncrementer.getColumnName());
        Assert.assertSame((Object)incrementer, (Object)MaxValueIncrementerFactory.getIncrementer((DataSource)this.mysql, (String)"MY_SEQUENCE"));
        Assert.assertNotSame((Object)incrementer, (Object)MaxValueIncrementerFactory.getIncrementer((DataSource)this.mysql, (String)"MY_SEQUENCE_2"));
    }

    @Test(expected=UnsupportedDatabasePlatformException.class)
    public void testGetIncrementer_Bad() throws Exception {
        MaxValueIncrementerFactory.getIncrementer((DataSource)this.bad, (String)"MY_SEQUENCE");
    }

    @Test
    public void testGetIncrementer_CaseInsensitive() throws Exception {
        DataFieldMaxValueIncrementer incrementer1 = MaxValueIncrementerFactory.getIncrementer((DataSource)this.mysql, (String)"MY_SEQUENCE");
        DataFieldMaxValueIncrementer incrementer2 = MaxValueIncrementerFactory.getIncrementer((DataSource)this.mysql, (String)"MY_sequence");
        DataFieldMaxValueIncrementer incrementer3 = MaxValueIncrementerFactory.getIncrementer((DataSource)this.mysql, (String)"my_sequence");
        Assert.assertSame((Object)incrementer1, (Object)incrementer2);
        Assert.assertSame((Object)incrementer2, (Object)incrementer3);
    }

    @Test
    public void testGetIncrementer_CacheByDataSource() throws Exception {
        DataFieldMaxValueIncrementer incrementer1 = MaxValueIncrementerFactory.getIncrementer((DataSource)this.mysql, (String)"MY_SEQUENCE");
        DataFieldMaxValueIncrementer incrementer2 = MaxValueIncrementerFactory.getIncrementer((DataSource)this.oracle, (String)"MY_SEQUENCE");
        Assert.assertNotSame((Object)incrementer1, (Object)incrementer2);
    }

    @Test(expected=IllegalArgumentException.class)
    public void testGetIncrementer_NullDataSource() throws Exception {
        MaxValueIncrementerFactory.getIncrementer(null, (String)"MY_SEQUENCE");
    }

    @Test(expected=IllegalArgumentException.class)
    public void testGetIncrementer_NullIncrementerName() throws Exception {
        MaxValueIncrementerFactory.getIncrementer((DataSource)this.mysql, null);
    }

    @Test(expected=IllegalArgumentException.class)
    public void testGetIncrementer_BlankIncrementerName() throws Exception {
        MaxValueIncrementerFactory.getIncrementer((DataSource)this.mysql, (String)"");
    }

    @Test
    public void testCustomIncrementerDatasourceVersion() throws Exception {
        SimpleConfig config = new SimpleConfig();
        config.putProperty("rice.krad.data.platform.incrementer.mysql.5", "org.kuali.rice.krad.data.platform.testincrementers.CustomIncrementerMySQLVersion5");
        config.putProperty("rice.krad.data.platform.incrementer.oracle.11", "org.kuali.rice.krad.data.platform.testincrementers.CustomIncrementerOracleVersion11");
        ConfigContext.init((Config)config);
        DataFieldMaxValueIncrementer mySQLMaxVal = MaxValueIncrementerFactory.getIncrementer((DataSource)this.mysql, (String)"test_mySQL");
        Assert.assertTrue((String)"Found MySQL custom incrementer", (mySQLMaxVal != null ? 1 : 0) != 0);
        Assert.assertTrue((String)"Custom incrementer for MySQL should be mySQL5 for String val", (boolean)StringUtils.equals((String)mySQLMaxVal.nextStringValue(), (String)"mySQL5"));
        DataFieldMaxValueIncrementer oracleMaxVal = MaxValueIncrementerFactory.getIncrementer((DataSource)this.oracle, (String)"test_oracle");
        Assert.assertTrue((String)"Found Oracle custom incrementer", (oracleMaxVal != null ? 1 : 0) != 0);
    }

    @Test
    public void testCustomIncrementerDatasourceNoVersion() throws Exception {
        SimpleConfig config = new SimpleConfig();
        config.putProperty("rice.krad.data.platform.incrementer.mysql", "org.kuali.rice.krad.data.platform.testincrementers.CustomIncrementerMySQLVersion5");
        config.putProperty("rice.krad.data.platform.incrementer.oracle", "org.kuali.rice.krad.data.platform.testincrementers.CustomIncrementerOracleVersion11");
        ConfigContext.init((Config)config);
        DataFieldMaxValueIncrementer mySQLMaxVal = MaxValueIncrementerFactory.getIncrementer((DataSource)this.mysql, (String)"test_mySQL");
        Assert.assertTrue((String)"Found MySQL custom incrementer", (mySQLMaxVal != null ? 1 : 0) != 0);
        Assert.assertTrue((String)"Custom incrementer for MySQL should be mySQL5 for String val", (boolean)StringUtils.equals((String)mySQLMaxVal.nextStringValue(), (String)"mySQL5"));
        DataFieldMaxValueIncrementer oracleMaxVal = MaxValueIncrementerFactory.getIncrementer((DataSource)this.oracle, (String)"test_oracle");
        Assert.assertTrue((String)"Found Oracle custom incrementer", (oracleMaxVal != null ? 1 : 0) != 0);
    }

    @Test(expected=InstantiationError.class)
    public void testCustomIncrementerDatasourceInvalidClass() throws Exception {
        SimpleConfig config = new SimpleConfig();
        config.putProperty("rice.krad.data.platform.incrementer.mysql", "org.kuali.rice.krad.data.platform.testincrementers.NonExistent");
        ConfigContext.init((Config)config);
        DataFieldMaxValueIncrementer mySQLMaxVal = MaxValueIncrementerFactory.getIncrementer((DataSource)this.mysql, (String)"test_mySQL");
        Assert.assertTrue((String)"Cannot create incrementer", (mySQLMaxVal == null ? 1 : 0) != 0);
    }

    @After
    public void clearContext() {
        ConfigContext.destroy();
    }
}

