/*-
 * #%L
 * %%
 * Copyright (C) 2005 - 2024 Kuali, Inc. - All Rights Reserved
 * %%
 * You may use and modify this code under the terms of the Kuali, Inc.
 * Pre-Release License Agreement. You may not distribute it.
 * 
 * You should have received a copy of the Kuali, Inc. Pre-Release License
 * Agreement with this file. If not, please write to license@kuali.co.
 * #L%
 */

package org.kuali.rice.krad.data.provider;

import java.util.List;

/**
 * Registry of KRAD Data Providers.
 *
 * @author Kuali Rice Team (rice.collab@kuali.org)
 */
public interface ProviderRegistry {

    /**
     * Register a Provider.
     *
     * @param provider the provider to register
     */
    void registerProvider(Provider provider);

    /**
     * Unregister a Provider if it exists.
     *
     * @param provider the provider to unregister
     *
     * @return true if provider was unregistered
     */
    boolean unregisterProvider(Provider provider);

    /**
     * Obtain list of all registered providers.
     *
     * @return non-null and immutable list of all registered providers
     */
    List<Provider> getProviders();

    /**
     * Obtain list of all registered providers of a given type.
     *
     * @param providerType the provider type
     *
     * @return non-null and immutable list of all registered providers of a given type
     */
    List<Provider> getProvidersForType(Class<? extends Provider> providerType);

    /**
     * Obtain list of all registered MetadataProviders
     *
     * @return non-null and immutable list of all registered MetadataProviders
     */
    List<MetadataProvider> getMetadataProviders();

    /**
	 * Obtain the first MetadataProvider which handles the gives type.
     *
     * @return the MetadataProvider which handles the given type, or null if none could be found
	 */
	MetadataProvider getMetadataProvider(Class<?> type);

    /**
     * Return the persistence provider for a given type.
     *
     * @param type the data object type
     *
     * @return persistence provider for given type, or null if no matching provider is registered
     */
    PersistenceProvider getPersistenceProvider(Class<?> type);

}
