/*-
 * #%L
 * %%
 * Copyright (C) 2005 - 2024 Kuali, Inc. - All Rights Reserved
 * %%
 * You may use and modify this code under the terms of the Kuali, Inc.
 * Pre-Release License Agreement. You may not distribute it.
 * 
 * You should have received a copy of the Kuali, Inc. Pre-Release License
 * Agreement with this file. If not, please write to license@kuali.co.
 * #L%
 */

package org.kuali.rice.krad.data.provider.annotation;

import org.kuali.rice.krad.data.metadata.DataObjectAttributeRelationship;

/**
 * Defines a relationship between attributes on two data objects.
 *
 * <p>Analog to the {@link DataObjectAttributeRelationship} metadata.</p>
 * 
 * @author Kuali Rice Team (rice.collab@kuali.org)
 */
public @interface AttributeRelationship {

    /**
     * Gets the attribute name on the parent object.
     *
     * @return the attribute name on the parent object.
     */
    String parentAttributeName();

    /**
     * Gets the attribute name on the child object.
     *
     * @return the attribute name on the child object.
     */
	String childAttributeName();
}
