/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.rice.krad.data.provider;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.kuali.rice.krad.data.KradDataServiceLocator;
import org.kuali.rice.krad.data.provider.Provider;
import org.kuali.rice.krad.data.provider.ProviderRegistry;
import org.springframework.beans.factory.InitializingBean;

public class ProviderRegistrar
implements InitializingBean {
    private static final Logger LOG = LogManager.getLogger(ProviderRegistrar.class);
    protected ProviderRegistry providerRegistry;
    protected List<Provider> providers = Collections.unmodifiableList(Collections.emptyList());

    public void afterPropertiesSet() throws Exception {
        if (this.getProviders() != null) {
            if (this.getProviderRegistry() != null) {
                for (Provider provider : this.getProviders()) {
                    LOG.info("Registering data module provider for " + String.valueOf(provider));
                    this.getProviderRegistry().registerProvider(provider);
                }
            } else {
                LOG.error("Provider registry not initialized.");
            }
        }
    }

    public void setProviders(List<Provider> providers) {
        this.providers = Collections.unmodifiableList(new ArrayList<Provider>(providers));
    }

    public List<Provider> getProviders() {
        return this.providers;
    }

    public ProviderRegistry getProviderRegistry() {
        if (this.providerRegistry == null) {
            return KradDataServiceLocator.getProviderRegistry();
        }
        return this.providerRegistry;
    }

    public void setProviderRegistry(ProviderRegistry providerRegistry) {
        this.providerRegistry = providerRegistry;
    }
}

