/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.rice.krad.devtools.maintainablexml;

import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.List;
import org.apache.commons.lang.StringUtils;
import org.kuali.rice.kns.bo.GlobalBusinessObject;
import org.kuali.rice.kns.bo.GlobalBusinessObjectDetail;
import org.kuali.rice.kns.bo.GlobalBusinessObjectDetailBase;
import org.kuali.rice.krad.bo.PersistableBusinessObject;
import org.kuali.rice.krad.bo.PersistableBusinessObjectBase;
import org.kuali.rice.krad.devtools.maintainablexml.TestDelegateGlobalDetail;
import org.kuali.rice.krad.devtools.maintainablexml.TestDelegateModel;
import org.kuali.rice.krad.devtools.maintainablexml.TestGlobalDetail;

public class TestDelegateGlobal
extends PersistableBusinessObjectBase
implements GlobalBusinessObject {
    protected String documentNumber;
    protected String modelName;
    protected String modelChartOfAccountsCode;
    protected String modelOrganizationCode;
    protected TestDelegateModel model;
    protected List<TestGlobalDetail> accountGlobalDetails = new ArrayList<TestGlobalDetail>();
    protected List<TestDelegateGlobalDetail> delegateGlobals = new ArrayList<TestDelegateGlobalDetail>();

    public void addAccount(TestGlobalDetail accountGlobalDetail) {
        if (accountGlobalDetail == null) {
            throw new IllegalArgumentException("The accountGlobalDetail instanced passed in was null.");
        }
        if (StringUtils.isBlank((String)accountGlobalDetail.getChartOfAccountsCode())) {
            throw new IllegalArgumentException("The chartOfAccountsCode member of the accountGlobalDetail object was not populated.");
        }
        if (StringUtils.isBlank((String)accountGlobalDetail.getAccountNumber())) {
            throw new IllegalArgumentException("The accountNumber member of the accountGlobalDetail object was not populated.");
        }
        TestGlobalDetail testObject = this.getAccount(accountGlobalDetail.getChartOfAccountsCode(), accountGlobalDetail.getAccountNumber());
        if (testObject == null) {
            this.accountGlobalDetails.add(accountGlobalDetail);
        }
    }

    public TestGlobalDetail getAccount(String chartCode, String accountNumber) {
        if (StringUtils.isBlank((String)chartCode)) {
            throw new IllegalArgumentException("The chartCode argument was null or empty.");
        }
        if (StringUtils.isBlank((String)accountNumber)) {
            throw new IllegalArgumentException("The accountNumber argument was null or empty.");
        }
        for (TestGlobalDetail accountGlobalDetail : this.accountGlobalDetails) {
            if (!chartCode.equalsIgnoreCase(accountGlobalDetail.getChartOfAccountsCode()) || !accountNumber.equalsIgnoreCase(accountGlobalDetail.getAccountNumber())) continue;
            return accountGlobalDetail;
        }
        return null;
    }

    public List<PersistableBusinessObject> generateDeactivationsToPersist() {
        return new ArrayList<PersistableBusinessObject>();
    }

    public List<PersistableBusinessObject> generateGlobalChangesToPersist() {
        List<TestDelegateGlobalDetail> changeDocuments = this.getDelegateGlobals();
        List<TestGlobalDetail> accountDetails = this.getAccountGlobalDetails();
        return new ArrayList<PersistableBusinessObject>();
    }

    protected LinkedHashMap toStringMapper_RICE20_REFACTORME() {
        LinkedHashMap m = new LinkedHashMap();
        return m;
    }

    public String getDocumentNumber() {
        return this.documentNumber;
    }

    public void setDocumentNumber(String documentNumber) {
        this.documentNumber = documentNumber;
    }

    public final List<TestGlobalDetail> getAccountGlobalDetails() {
        return this.accountGlobalDetails;
    }

    public final void setAccountGlobalDetails(List<TestGlobalDetail> accountGlobalDetails) {
        this.accountGlobalDetails = accountGlobalDetails;
    }

    public final List<TestDelegateGlobalDetail> getDelegateGlobals() {
        return this.delegateGlobals;
    }

    public final void setDelegateGlobals(List<TestDelegateGlobalDetail> delegateGlobals) {
        this.delegateGlobals = delegateGlobals;
    }

    public boolean isPersistable() {
        return true;
    }

    public String getModelName() {
        return this.modelName;
    }

    public void setModelName(String loadModelName) {
        this.modelName = loadModelName;
    }

    public String getModelChartOfAccountsCode() {
        return this.modelChartOfAccountsCode;
    }

    public void setModelChartOfAccountsCode(String loadModelChartOfAccountsCode) {
        this.modelChartOfAccountsCode = loadModelChartOfAccountsCode;
    }

    public String getModelOrganizationCode() {
        return this.modelOrganizationCode;
    }

    public void setModelOrganizationCode(String loadModelOrganizationCode) {
        this.modelOrganizationCode = loadModelOrganizationCode;
    }

    public TestDelegateModel getModel() {
        return this.model;
    }

    public void setModel(TestDelegateModel loadModel) {
        this.model = loadModel;
    }

    public List<? extends GlobalBusinessObjectDetail> getAllDetailObjects() {
        ArrayList<GlobalBusinessObjectDetailBase> details = new ArrayList<GlobalBusinessObjectDetailBase>(this.accountGlobalDetails.size() + this.delegateGlobals.size());
        details.addAll(this.accountGlobalDetails);
        details.addAll(this.delegateGlobals);
        return details;
    }

    public void linkEditableUserFields() {
        super.linkEditableUserFields();
        if (this == null) {
            throw new IllegalArgumentException("globalDelegate parameter passed in was null");
        }
        ArrayList<TestDelegateGlobalDetail> bos = new ArrayList<TestDelegateGlobalDetail>();
        bos.addAll(this.getDelegateGlobals());
    }

    public List<Collection<PersistableBusinessObject>> buildListOfDeletionAwareLists() {
        List managedLists = super.buildListOfDeletionAwareLists();
        managedLists.add(new ArrayList<TestGlobalDetail>(this.getAccountGlobalDetails()));
        managedLists.add(new ArrayList<TestDelegateGlobalDetail>(this.getDelegateGlobals()));
        return managedLists;
    }
}

