/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.rice.krad.devtools.pdle;

import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang.StringUtils;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.kuali.rice.core.framework.persistence.jdbc.dao.PlatformAwareDaoBaseJdbc;
import org.kuali.rice.krad.devtools.pdle.PostDataLoadEncryptionDao;
import org.springframework.dao.DataAccessException;
import org.springframework.jdbc.core.ConnectionCallback;
import org.springframework.jdbc.core.RowMapper;

public class PostDataLoadEncryptionDaoJdbc
extends PlatformAwareDaoBaseJdbc
implements PostDataLoadEncryptionDao {
    private static final Logger LOG = LogManager.getLogger(PostDataLoadEncryptionDaoJdbc.class);
    protected static final String AND_SEPARATOR = " AND ";
    protected static final String COMMA_SEPARATOR = ", ";
    protected static final String BACKUP_TABLE_EXTENSION = "_bak";
    protected static final String BACKUP_TABLE_ENCRYPT_IND = "ENCRYPT_IND";

    void executeSql(String sql) {
        LOG.info("Executing sql: " + sql);
        this.getJdbcTemplate().execute(sql);
    }

    @Override
    public void createBackupTable(String tableName) {
        this.executeSql(this.getDbPlatform().getCreateTableFromTableSql(tableName + BACKUP_TABLE_EXTENSION, tableName));
    }

    @Override
    public void truncateTable(String tableName) {
        this.executeSql(this.getDbPlatform().getTruncateTableSql(tableName));
    }

    @Override
    public void restoreTableFromBackup(String tableName) {
        this.truncateTable(tableName);
        this.executeSql(this.getDbPlatform().getInsertDataFromTableSql(tableName, tableName + BACKUP_TABLE_EXTENSION));
    }

    @Override
    public void dropBackupTable(String tableName) {
        this.executeSql(this.getDbPlatform().getDropTableSql(tableName + BACKUP_TABLE_EXTENSION));
    }

    @Override
    public boolean doesBackupTableExist(String tableName) {
        try {
            Object tableNameObj = this.getJdbcTemplate().queryForObject("SELECT count(*) FROM " + tableName + BACKUP_TABLE_EXTENSION + " WHERE 0=1", Integer.class);
            return true;
        }
        catch (Exception ex) {
            return false;
        }
    }

    @Override
    public void addEncryptionIndicatorToBackupTable(String tableName) {
        this.executeSql(new StringBuffer().append("ALTER TABLE ").append(tableName + BACKUP_TABLE_EXTENSION).append(" ADD ").append(BACKUP_TABLE_ENCRYPT_IND).append(" VARCHAR2(1)").toString());
    }

    @Override
    public void dropEncryptionIndicatorFromBackupTable(String tableName) {
        this.executeSql(new StringBuffer().append("ALTER TABLE ").append(tableName + BACKUP_TABLE_EXTENSION).append(" DROP COLUMN ").append(BACKUP_TABLE_ENCRYPT_IND).toString());
    }

    @Override
    public List<Map<String, String>> retrieveUnencryptedColumnValuesFromBackupTable(String tableName, final List<String> columnNames, int numberOfRowsToCommitAfter) {
        return this.getJdbcTemplate().query(this.getSelectBackupTableColumnsSql(tableName, columnNames, numberOfRowsToCommitAfter), new RowMapper(){

            public Object mapRow(ResultSet rs, int rowNum) throws SQLException {
                HashMap<String, String> columnValuesMap = new HashMap<String, String>();
                for (String columnName : columnNames) {
                    columnValuesMap.put(columnName, rs.getString(columnName));
                }
                return columnValuesMap;
            }
        });
    }

    @Override
    public void updateColumnValuesInBackupTable(String tableName, Map<String, List<String>> columnNameOldNewValuesMap) {
        if (columnNameOldNewValuesMap == null || columnNameOldNewValuesMap.size() < 1) {
            return;
        }
        this.executeSql(this.getUpdateBackupTableColumnsSql(tableName, columnNameOldNewValuesMap));
    }

    @Override
    public String getUpdateBackupTableColumnsSql(String tableName, Map<String, List<String>> columnNameOldNewValuesMap) {
        List<String> columnOldNewValueList;
        tableName = tableName + BACKUP_TABLE_EXTENSION;
        StringBuffer columnsNamesNewValuesBuf = new StringBuffer();
        for (String columnName : columnNameOldNewValuesMap.keySet()) {
            columnOldNewValueList = columnNameOldNewValuesMap.get(columnName);
            String columnNewValue = columnOldNewValueList != null && columnOldNewValueList.size() > 1 ? columnOldNewValueList.get(1) : "";
            columnsNamesNewValuesBuf.append(columnName).append("='").append(columnNewValue).append("'").append(COMMA_SEPARATOR);
        }
        columnsNamesNewValuesBuf.append(BACKUP_TABLE_ENCRYPT_IND).append("='Y'");
        StringBuffer columnsNamesOldValuesBuf = new StringBuffer();
        for (String columnName : columnNameOldNewValuesMap.keySet()) {
            String columnOldValue;
            columnOldNewValueList = columnNameOldNewValuesMap.get(columnName);
            String string = columnOldValue = columnOldNewValueList != null && columnOldNewValueList.size() > 0 ? columnOldNewValueList.get(0) : "";
            if (StringUtils.isEmpty((String)columnOldValue) || columnOldValue.equalsIgnoreCase("null")) {
                columnsNamesOldValuesBuf.append(columnName).append(" IS NULL ").append(AND_SEPARATOR);
                continue;
            }
            columnsNamesOldValuesBuf.append(columnName).append("='").append(columnOldValue).append("'").append(AND_SEPARATOR);
        }
        columnsNamesOldValuesBuf.append(BACKUP_TABLE_ENCRYPT_IND).append(" IS NULL ");
        return new StringBuffer("UPDATE ").append(tableName).append(" SET ").append(columnsNamesNewValuesBuf).append(" WHERE ").append(columnsNamesOldValuesBuf).toString();
    }

    protected String getSelectBackupTableColumnsSql(String tableName, List<String> columnNames, int numberOfRowsToCommitAfter) {
        tableName = tableName + BACKUP_TABLE_EXTENSION;
        StringBuffer columnsNamesBuf = new StringBuffer();
        for (String columnName : columnNames) {
            columnsNamesBuf.append(columnName).append(COMMA_SEPARATOR);
        }
        String selectColumns = StringUtils.stripEnd((String)columnsNamesBuf.toString(), (String)COMMA_SEPARATOR);
        return new StringBuffer("SELECT ").append(selectColumns).append(" FROM ").append(tableName).append(" WHERE ").append(BACKUP_TABLE_ENCRYPT_IND).append(" IS NULL AND ROWNUM<=").append(numberOfRowsToCommitAfter).toString();
    }

    @Override
    public boolean performEncryption(final String tableName, final List<Map<String, List<String>>> rowsToEncryptColumnNameOldNewValuesMap) throws Exception {
        Boolean success = (Boolean)this.getJdbcTemplate().execute(new ConnectionCallback(){

            public Object doInConnection(Connection conn) throws SQLException, DataAccessException {
                try {
                    conn.setAutoCommit(false);
                    Statement statement = conn.createStatement();
                    int counter = 0;
                    for (Map columnNameOldNewValuesMap : rowsToEncryptColumnNameOldNewValuesMap) {
                        statement.addBatch(PostDataLoadEncryptionDaoJdbc.this.getUpdateBackupTableColumnsSql(tableName, columnNameOldNewValuesMap));
                        ++counter;
                    }
                    statement.executeBatch();
                    conn.commit();
                    LOG.info((CharSequence)new StringBuffer("Encrypted ").append(" attributes of table ").append(tableName));
                }
                catch (Exception e) {
                    LOG.error((CharSequence)new StringBuffer("Caught exception, while encrypting ").append(" attributes of table ").append(tableName), (Throwable)e);
                    conn.rollback();
                    return false;
                }
                return true;
            }
        });
        return success;
    }
}

