/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.rice.krad.devtools.maintainablexml;

import java.io.StringReader;
import java.io.StringWriter;
import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import javax.xml.xpath.XPath;
import javax.xml.xpath.XPathConstants;
import javax.xml.xpath.XPathExpression;
import javax.xml.xpath.XPathExpressionException;
import javax.xml.xpath.XPathFactory;
import org.apache.commons.beanutils.PropertyUtils;
import org.apache.commons.lang.StringUtils;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.InputSource;

public class MaintainableXMLConversionServiceImpl {
    private static final String SERIALIZATION_ATTRIBUTE = "serialization";
    private static final String CLASS_ATTRIBUTE = "class";
    private static final String MAINTENANCE_ACTION_ELEMENT_NAME = "maintenanceAction";
    private static final String OLD_MAINTAINABLE_OBJECT_ELEMENT_NAME = "oldMaintainableObject";
    private static final String NEW_MAINTAINABLE_OBJECT_ELEMENT_NAME = "newMaintainableObject";
    private Map<String, String> classNameRuleMap;
    private Map<String, Map<String, String>> classPropertyRuleMap;
    private Map<String, String> dateRuleMap;

    public String transformMaintainableXML(String xml) {
        String beginning = StringUtils.substringBefore((String)xml, (String)"<oldMaintainableObject>");
        String oldMaintainableObjectXML = StringUtils.substringBetween((String)xml, (String)"<oldMaintainableObject>", (String)"</oldMaintainableObject>");
        String newMaintainableObjectXML = StringUtils.substringBetween((String)xml, (String)"<newMaintainableObject>", (String)"</newMaintainableObject>");
        String ending = StringUtils.substringAfter((String)xml, (String)"</newMaintainableObject>");
        String convertedOldMaintainableObjectXML = this.transformSection(oldMaintainableObjectXML);
        String convertedNewMaintainableObjectXML = this.transformSection(newMaintainableObjectXML);
        String convertedXML = beginning + "<" + OLD_MAINTAINABLE_OBJECT_ELEMENT_NAME + ">" + convertedOldMaintainableObjectXML + "</" + OLD_MAINTAINABLE_OBJECT_ELEMENT_NAME + ">" + "<" + NEW_MAINTAINABLE_OBJECT_ELEMENT_NAME + ">" + convertedNewMaintainableObjectXML + "</" + NEW_MAINTAINABLE_OBJECT_ELEMENT_NAME + ">" + ending;
        return convertedXML;
    }

    private String transformSection(String xml) {
        String maintenanceAction = StringUtils.substringBetween((String)xml, (String)"<maintenanceAction>", (String)"</maintenanceAction>");
        xml = StringUtils.substringBefore((String)xml, (String)"<maintenanceAction>");
        try {
            xml = this.upgradeBONotes(xml);
            if (this.classNameRuleMap == null) {
                this.setRuleMaps();
            }
            DocumentBuilderFactory dbf = DocumentBuilderFactory.newInstance();
            DocumentBuilder db = dbf.newDocumentBuilder();
            Document document = db.parse(new InputSource(new StringReader(xml)));
            this.removePersonObjects(document);
            Node childNode = document.getFirstChild();
            while (childNode != null) {
                Node nextChild = childNode.getNextSibling();
                this.transformClassNode(document, childNode);
                childNode = nextChild;
            }
            TransformerFactory transFactory = TransformerFactory.newInstance();
            Transformer trans = transFactory.newTransformer();
            trans.setOutputProperty("omit-xml-declaration", "yes");
            trans.setOutputProperty("indent", "yes");
            StringWriter writer = new StringWriter();
            StreamResult result = new StreamResult(writer);
            DOMSource source = new DOMSource(document);
            trans.transform(source, result);
            xml = writer.toString().replaceAll("(?m)^\\s+\\n", "");
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return xml + "<" + MAINTENANCE_ACTION_ELEMENT_NAME + ">" + maintenanceAction + "</" + MAINTENANCE_ACTION_ELEMENT_NAME + ">";
    }

    private String upgradeBONotes(String oldXML) throws Exception {
        String notesXml = StringUtils.substringBetween((String)oldXML, (String)"<boNotes>", (String)"</boNotes>");
        if (notesXml != null) {
            notesXml = notesXml.replace("org.kuali.rice.kns.bo.Note", "org.kuali.rice.krad.bo.Note");
            notesXml = "<org.apache.ojb.broker.core.proxy.ListProxyDefaultImpl>\n" + notesXml + "\n</org.apache.ojb.broker.core.proxy.ListProxyDefaultImpl>";
            oldXML = oldXML.replaceFirst(">", ">\n<notes>\n" + notesXml + "\n</notes>");
        }
        return oldXML;
    }

    public void removePersonObjects(Document doc) {
        XPath xpath = XPathFactory.newInstance().newXPath();
        XPathExpression personProperties = null;
        try {
            personProperties = xpath.compile("//*[@class='org.kuali.rice.kim.impl.identity.PersonImpl']");
            NodeList matchingNodes = (NodeList)personProperties.evaluate(doc, XPathConstants.NODESET);
            for (int i = 0; i < matchingNodes.getLength(); ++i) {
                Node tempNode = matchingNodes.item(i);
                tempNode.getParentNode().removeChild(tempNode);
            }
        }
        catch (XPathExpressionException e) {
            e.printStackTrace();
        }
    }

    private void transformClassNode(Document document, Node node) throws ClassNotFoundException, XPathExpressionException, IllegalAccessException, InvocationTargetException, NoSuchMethodException, InstantiationException {
        String className = node.getNodeName();
        if (this.classNameRuleMap.containsKey(className)) {
            String newClassName = this.classNameRuleMap.get(className);
            document.renameNode(node, null, newClassName);
            className = newClassName;
        }
        Class<?> dataObjectClass = Class.forName(className);
        if (this.classPropertyRuleMap.containsKey(className)) {
            this.transformNode(document, node, dataObjectClass, this.classPropertyRuleMap.get(className));
        }
        this.transformNode(document, node, dataObjectClass, this.classPropertyRuleMap.get("*"));
    }

    private void transformNode(Document document, Node node, Class<?> currentClass, Map<String, String> propertyMappings) throws ClassNotFoundException, XPathExpressionException, IllegalAccessException, InvocationTargetException, NoSuchMethodException, InstantiationException {
        Node childNode = node.getFirstChild();
        while (childNode != null) {
            String newDateValue;
            Node nextChild = childNode.getNextSibling();
            String propertyName = childNode.getNodeName();
            if (childNode.hasAttributes()) {
                XPath xpath = XPathFactory.newInstance().newXPath();
                Node serializationAttribute = childNode.getAttributes().getNamedItem(SERIALIZATION_ATTRIBUTE);
                if (serializationAttribute != null && StringUtils.equals((String)serializationAttribute.getNodeValue(), (String)"custom")) {
                    Node nextRemoveNode;
                    Object removeNode;
                    ArrayList<Node> nodesToAdd;
                    Node classAttribute = childNode.getAttributes().getNamedItem(CLASS_ATTRIBUTE);
                    if (classAttribute != null && StringUtils.equals((String)classAttribute.getNodeValue(), (String)"org.kuali.rice.kns.util.TypedArrayList")) {
                        ((Element)childNode).removeAttribute(SERIALIZATION_ATTRIBUTE);
                        ((Element)childNode).removeAttribute(CLASS_ATTRIBUTE);
                        XPathExpression listSizeExpression = xpath.compile("//" + propertyName + "/org.apache.ojb.broker.core.proxy.ListProxyDefaultImpl/default/size/text()");
                        String size = (String)listSizeExpression.evaluate(childNode, XPathConstants.STRING);
                        nodesToAdd = new ArrayList();
                        if (StringUtils.isNotBlank((String)size) && Integer.valueOf(size) > 0) {
                            XPathExpression listTypeExpression = xpath.compile("//" + propertyName + "/org.kuali.rice.kns.util.TypedArrayList/default/listObjectType/text()");
                            String listType = (String)listTypeExpression.evaluate(childNode, XPathConstants.STRING);
                            XPathExpression listContentsExpression = xpath.compile("//" + propertyName + "/org.apache.ojb.broker.core.proxy.ListProxyDefaultImpl/" + listType);
                            NodeList listContents = (NodeList)listContentsExpression.evaluate(childNode, XPathConstants.NODESET);
                            for (int i = 0; i < listContents.getLength(); ++i) {
                                Node tempNode = listContents.item(i);
                                this.transformClassNode(document, tempNode);
                                nodesToAdd.add(tempNode);
                            }
                        }
                        removeNode = childNode.getFirstChild();
                        while (removeNode != null) {
                            nextRemoveNode = removeNode.getNextSibling();
                            childNode.removeChild((Node)removeNode);
                            removeNode = nextRemoveNode;
                        }
                        for (Node nodeToAdd : nodesToAdd) {
                            childNode.appendChild(nodeToAdd);
                        }
                    } else {
                        ((Element)childNode).removeAttribute(SERIALIZATION_ATTRIBUTE);
                        XPathExpression mapContentsExpression = xpath.compile("//" + propertyName + "/map/string");
                        NodeList mapContents = (NodeList)mapContentsExpression.evaluate(childNode, XPathConstants.NODESET);
                        nodesToAdd = new ArrayList<Node>();
                        if (mapContents.getLength() > 0 && mapContents.getLength() % 2 == 0) {
                            for (int i = 0; i < mapContents.getLength(); ++i) {
                                Node keyNode = mapContents.item(i);
                                Node valueNode = mapContents.item(++i);
                                Element entryNode = document.createElement("entry");
                                entryNode.appendChild(keyNode);
                                entryNode.appendChild(valueNode);
                                nodesToAdd.add(entryNode);
                            }
                        }
                        removeNode = childNode.getFirstChild();
                        while (removeNode != null) {
                            nextRemoveNode = removeNode.getNextSibling();
                            childNode.removeChild((Node)removeNode);
                            removeNode = nextRemoveNode;
                        }
                        for (Node nodeToAdd : nodesToAdd) {
                            childNode.appendChild(nodeToAdd);
                        }
                    }
                }
            }
            if (propertyMappings != null && propertyMappings.containsKey(propertyName)) {
                String newPropertyName = propertyMappings.get(propertyName);
                if (StringUtils.isNotBlank((String)newPropertyName)) {
                    document.renameNode(childNode, null, newPropertyName);
                    propertyName = newPropertyName;
                } else {
                    node.removeChild(childNode);
                    childNode = nextChild;
                    continue;
                }
            }
            if (this.dateRuleMap != null && this.dateRuleMap.containsKey(propertyName) && StringUtils.isNotBlank((String)(newDateValue = this.dateRuleMap.get(propertyName))) && childNode.getTextContent().length() == 10) {
                childNode.setTextContent(childNode.getTextContent() + " " + newDateValue);
            }
            if (currentClass != null && childNode.hasChildNodes() && !Collection.class.isAssignableFrom(currentClass) && !Map.class.isAssignableFrom(currentClass)) {
                Class propertyClass = PropertyUtils.getPropertyType(currentClass.newInstance(), (String)propertyName);
                if (propertyClass != null && this.classPropertyRuleMap.containsKey(propertyClass.getName())) {
                    this.transformNode(document, childNode, propertyClass, this.classPropertyRuleMap.get(propertyClass.getName()));
                }
                this.transformNode(document, childNode, propertyClass, this.classPropertyRuleMap.get("*"));
            }
            childNode = nextChild;
        }
    }

    private void setRuleMaps() {
        this.setupConfigurationMaps();
        try {
            DocumentBuilderFactory dbf = DocumentBuilderFactory.newInstance();
            DocumentBuilder db = dbf.newDocumentBuilder();
            Object resource = null;
            Document doc = db.parse(this.getClass().getResourceAsStream("/org/kuali/rice/devtools/krad/maintainablexml/MaintainableXMLUpgradeRules.xml"));
            doc.getDocumentElement().normalize();
            XPath xpath = XPathFactory.newInstance().newXPath();
            XPathExpression exprClassNames = xpath.compile("//*[@name='maint_doc_classname_changes']/pattern");
            NodeList classNamesList = (NodeList)exprClassNames.evaluate(doc, XPathConstants.NODESET);
            for (int s = 0; s < classNamesList.getLength(); ++s) {
                String matchText = xpath.evaluate("match/text()", classNamesList.item(s));
                String replaceText = xpath.evaluate("replacement/text()", classNamesList.item(s));
                this.classNameRuleMap.put(matchText, replaceText);
            }
            XPathExpression exprClassProperties = xpath.compile("//*[@name='maint_doc_changed_class_properties']/pattern");
            XPathExpression exprClassPropertiesPatterns = xpath.compile("pattern");
            NodeList propertyClassList = (NodeList)exprClassProperties.evaluate(doc, XPathConstants.NODESET);
            for (int s = 0; s < propertyClassList.getLength(); ++s) {
                String classText = xpath.evaluate("class/text()", propertyClassList.item(s));
                HashMap<String, String> propertyRuleMap = new HashMap<String, String>();
                NodeList classPropertiesPatterns = (NodeList)exprClassPropertiesPatterns.evaluate(propertyClassList.item(s), XPathConstants.NODESET);
                for (int c = 0; c < classPropertiesPatterns.getLength(); ++c) {
                    String matchText = xpath.evaluate("match/text()", classPropertiesPatterns.item(c));
                    String replaceText = xpath.evaluate("replacement/text()", classPropertiesPatterns.item(c));
                    propertyRuleMap.put(matchText, replaceText);
                }
                this.classPropertyRuleMap.put(classText, propertyRuleMap);
            }
            XPathExpression dateFieldNames = xpath.compile("//*[@name='maint_doc_date_changes']/pattern");
            NodeList DateNamesList = (NodeList)dateFieldNames.evaluate(doc, XPathConstants.NODESET);
            for (int s = 0; s < DateNamesList.getLength(); ++s) {
                String matchText = xpath.evaluate("match/text()", DateNamesList.item(s));
                String replaceText = xpath.evaluate("replacement/text()", DateNamesList.item(s));
                this.dateRuleMap.put(matchText, replaceText);
            }
        }
        catch (Exception e) {
            System.out.println("Error parsing rule xml file. Please check file. : " + e.getMessage());
            e.printStackTrace();
        }
    }

    private void setupConfigurationMaps() {
        this.classNameRuleMap = new HashMap<String, String>();
        this.classPropertyRuleMap = new HashMap<String, Map<String, String>>();
        this.dateRuleMap = new HashMap<String, String>();
        HashMap<String, String> defaultPropertyRules = new HashMap<String, String>();
        defaultPropertyRules.put("boNotes", "");
        defaultPropertyRules.put("autoIncrementSet", "");
        this.classPropertyRuleMap.put("*", defaultPropertyRules);
    }
}

