/*
 * Decompiled with CFR 0.152.
 */
package edu.sampleu.travel.dataobject;

import edu.sampleu.travel.dataobject.TravelAuthorizationDocument;
import edu.sampleu.travel.dataobject.TravelDestination;
import edu.sampleu.travel.dataobject.TravelMileageRate;
import edu.sampleu.travel.options.MileageRateKeyValues;
import edu.sampleu.travel.options.TravelDestinationKeyValues;
import java.io.Serializable;
import java.math.BigDecimal;
import java.util.Date;
import javax.persistence.CascadeType;
import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.FetchType;
import javax.persistence.GeneratedValue;
import javax.persistence.Id;
import javax.persistence.JoinColumn;
import javax.persistence.ManyToOne;
import javax.persistence.Table;
import javax.persistence.Temporal;
import javax.persistence.TemporalType;
import org.apache.commons.lang.StringUtils;
import org.kuali.rice.krad.bo.DataObjectBase;
import org.kuali.rice.krad.data.jpa.PortableSequenceGenerator;
import org.kuali.rice.krad.data.provider.annotation.Description;
import org.kuali.rice.krad.data.provider.annotation.InheritProperties;
import org.kuali.rice.krad.data.provider.annotation.InheritProperty;
import org.kuali.rice.krad.data.provider.annotation.KeyValuesFinderClass;
import org.kuali.rice.krad.data.provider.annotation.Label;
import org.kuali.rice.krad.data.provider.annotation.Relationship;
import org.kuali.rice.krad.data.provider.annotation.UifAutoCreateViewType;
import org.kuali.rice.krad.data.provider.annotation.UifAutoCreateViews;
import org.kuali.rice.krad.data.provider.annotation.UifDisplayHint;
import org.kuali.rice.krad.data.provider.annotation.UifDisplayHintType;
import org.kuali.rice.krad.data.provider.annotation.UifDisplayHints;
import org.kuali.rice.krad.data.provider.annotation.UifValidCharactersConstraintBeanName;

@Entity
@Table(name="TRVL_PD_EXP_T")
@UifAutoCreateViews(value={UifAutoCreateViewType.INQUIRY, UifAutoCreateViewType.LOOKUP})
public class TravelPerDiemExpense
extends DataObjectBase
implements Serializable {
    private static final long serialVersionUID = 6269893036439679855L;
    @Id
    @Column(name="PD_EXP_ID", length=10)
    @GeneratedValue(generator="TRVL_PD_EXP_ID_S")
    @PortableSequenceGenerator(name="TRVL_PD_EXP_ID_S")
    @Label(value="Id")
    @Description(value="Unique identifier for per diem expense item")
    @UifValidCharactersConstraintBeanName(value="AlphaNumericPatternConstraint")
    private String travelPerDiemExpenseId;
    @Column(name="TRVL_AUTH_DOC_ID", length=40)
    @Label(value="Travel Authorization Document Id")
    @UifDisplayHints(value={@UifDisplayHint(value=UifDisplayHintType.NO_LOOKUP_RESULT), @UifDisplayHint(value=UifDisplayHintType.NO_INQUIRY)})
    private String travelAuthorizationDocumentId;
    @Relationship(foreignKeyFields={"travelAuthorizationDocumentId"})
    @ManyToOne(fetch=FetchType.LAZY, cascade={CascadeType.REFRESH})
    @JoinColumn(name="TRVL_AUTH_DOC_ID", referencedColumnName="TRVL_AUTH_DOC_ID", insertable=false, updatable=false)
    @InheritProperties(value={@InheritProperty(name="documentNumber", label=@Label(value="Travel Authorization Document"), displayHints=@UifDisplayHints(value={@UifDisplayHint(value=UifDisplayHintType.NO_LOOKUP_CRITERIA)}))})
    private TravelAuthorizationDocument travelAuthorizationDocument;
    @Column(name="TRVL_DEST_ID", length=40)
    @Label(value="Primary Destination")
    @Description(value="Primary Destination related to per diem expense")
    @KeyValuesFinderClass(value=TravelDestinationKeyValues.class)
    @UifDisplayHints(value={@UifDisplayHint(value=UifDisplayHintType.NONE), @UifDisplayHint(value=UifDisplayHintType.NO_LOOKUP_RESULT), @UifDisplayHint(value=UifDisplayHintType.NO_INQUIRY)})
    private String travelDestinationId;
    @Relationship(foreignKeyFields={"travelDestinationId"})
    @ManyToOne(fetch=FetchType.LAZY, cascade={CascadeType.REFRESH})
    @JoinColumn(name="TRVL_DEST_ID", insertable=false, updatable=false)
    @InheritProperties(value={@InheritProperty(name="travelDestinationId", label=@Label(value="Primary Destination"), displayHints=@UifDisplayHints(value={@UifDisplayHint(value=UifDisplayHintType.NO_LOOKUP_CRITERIA)}))})
    @UifDisplayHint(value=UifDisplayHintType.NO_LOOKUP_CRITERIA)
    private TravelDestination travelDestination;
    @Temporal(value=TemporalType.TIMESTAMP)
    @Column(name="PD_DT")
    @Label(value="Date of Use")
    private Date perDiemDate;
    @Column(name="BKFST_VAL")
    @Label(value="Breakfast Value")
    private BigDecimal breakfastValue;
    @Column(name="LNCH_VAL")
    @Label(value="Lunch Value")
    private BigDecimal lunchValue;
    @Column(name="DNNR_VAL")
    @Label(value="Dinner Value")
    private BigDecimal dinnerValue;
    @Column(name="INCD_VAL")
    @Label(value="Amount estimated for incidentals")
    private BigDecimal incidentalsValue;
    @Column(name="MLG_RT_ID", length=40)
    @Label(value="Mileage Rate")
    @Description(value="Mileage Rate Code Used")
    @KeyValuesFinderClass(value=MileageRateKeyValues.class)
    @UifDisplayHints(value={@UifDisplayHint(value=UifDisplayHintType.NONE), @UifDisplayHint(value=UifDisplayHintType.NO_LOOKUP_RESULT), @UifDisplayHint(value=UifDisplayHintType.NO_INQUIRY)})
    private String mileageRateId;
    @Relationship(foreignKeyFields={"mileageRateId"})
    @ManyToOne(fetch=FetchType.LAZY, cascade={CascadeType.REFRESH})
    @JoinColumn(name="MLG_RT_ID", insertable=false, updatable=false)
    @InheritProperties(value={@InheritProperty(name="mileageRateCd", label=@Label(value="Mileage rate"), displayHints=@UifDisplayHints(value={@UifDisplayHint(value=UifDisplayHintType.NO_LOOKUP_CRITERIA)}))})
    private TravelMileageRate mileageRate;
    @Column(name="MLG_EST")
    @Label(value="Number of estimated miles")
    private BigDecimal estimatedMileage;

    public String getTravelPerDiemExpenseId() {
        return this.travelPerDiemExpenseId;
    }

    public void setTravelPerDiemExpenseId(String travelPerDiemExpenseId) {
        this.travelPerDiemExpenseId = travelPerDiemExpenseId;
    }

    public String getTravelAuthorizationDocumentId() {
        if (StringUtils.isBlank((String)this.travelAuthorizationDocumentId) && this.travelAuthorizationDocument != null) {
            return this.travelAuthorizationDocument.getDocumentNumber();
        }
        return this.travelAuthorizationDocumentId;
    }

    public void setTravelAuthorizationDocumentId(String travelAuthorizationDocumentId) {
        this.travelAuthorizationDocumentId = travelAuthorizationDocumentId;
    }

    public TravelAuthorizationDocument getTravelAuthorizationDocument() {
        return this.travelAuthorizationDocument;
    }

    public void setTravelAuthorizationDocument(TravelAuthorizationDocument travelAuthorizationDocument) {
        this.travelAuthorizationDocument = travelAuthorizationDocument;
    }

    public Date getPerDiemDate() {
        return this.perDiemDate;
    }

    public void setPerDiemDate(Date perDiemDate) {
        this.perDiemDate = perDiemDate;
    }

    public BigDecimal getBreakfastValue() {
        return this.breakfastValue;
    }

    public void setBreakfastValue(BigDecimal breakfastValue) {
        this.breakfastValue = breakfastValue;
    }

    public BigDecimal getLunchValue() {
        return this.lunchValue;
    }

    public void setLunchValue(BigDecimal lunchValue) {
        this.lunchValue = lunchValue;
    }

    public BigDecimal getDinnerValue() {
        return this.dinnerValue;
    }

    public void setDinnerValue(BigDecimal dinnerValue) {
        this.dinnerValue = dinnerValue;
    }

    public BigDecimal getIncidentalsValue() {
        return this.incidentalsValue;
    }

    public void setIncidentalsValue(BigDecimal incidentalsValue) {
        this.incidentalsValue = incidentalsValue;
    }

    public String getTravelDestinationId() {
        return this.travelDestinationId;
    }

    public void setTravelDestinationId(String travelDestinationId) {
        this.travelDestinationId = travelDestinationId;
    }

    public TravelDestination getTravelDestination() {
        return this.travelDestination;
    }

    public void setTravelDestination(TravelDestination travelDestination) {
        this.travelDestination = travelDestination;
    }

    public String getMileageRateId() {
        return this.mileageRateId;
    }

    public void setMileageRateId(String mileageRateId) {
        this.mileageRateId = mileageRateId;
    }

    public TravelMileageRate getMileageRate() {
        return this.mileageRate;
    }

    public void setMileageRate(TravelMileageRate mileageRate) {
        this.mileageRate = mileageRate;
    }

    public BigDecimal getEstimatedMileage() {
        return this.estimatedMileage;
    }

    public void setEstimatedMileage(BigDecimal estimatedMileage) {
        this.estimatedMileage = estimatedMileage;
    }
}

