/*
 * Decompiled with CFR 0.152.
 */
package edu.sampleu.travel.dataobject;

import edu.sampleu.travel.dataobject.TravelAuthorizationDocument;
import java.io.Serializable;
import java.math.BigDecimal;
import java.util.Date;
import javax.persistence.CascadeType;
import javax.persistence.Column;
import javax.persistence.Convert;
import javax.persistence.Entity;
import javax.persistence.FetchType;
import javax.persistence.GeneratedValue;
import javax.persistence.Id;
import javax.persistence.JoinColumn;
import javax.persistence.ManyToOne;
import javax.persistence.Table;
import javax.persistence.Temporal;
import javax.persistence.TemporalType;
import javax.persistence.Transient;
import javax.xml.bind.annotation.XmlTransient;
import org.apache.commons.lang.StringUtils;
import org.eclipse.persistence.indirection.ValueHolder;
import org.eclipse.persistence.indirection.WeavedAttributeValueHolderInterface;
import org.eclipse.persistence.internal.descriptors.PersistenceObject;
import org.eclipse.persistence.internal.weaving.PersistenceWeaved;
import org.eclipse.persistence.internal.weaving.PersistenceWeavedChangeTracking;
import org.eclipse.persistence.internal.weaving.PersistenceWeavedFetchGroups;
import org.eclipse.persistence.internal.weaving.PersistenceWeavedLazy;
import org.kuali.rice.krad.bo.DataObjectBase;
import org.kuali.rice.krad.data.jpa.PortableSequenceGenerator;
import org.kuali.rice.krad.data.jpa.converters.BooleanYNConverter;
import org.kuali.rice.krad.data.provider.annotation.Description;
import org.kuali.rice.krad.data.provider.annotation.InheritProperties;
import org.kuali.rice.krad.data.provider.annotation.InheritProperty;
import org.kuali.rice.krad.data.provider.annotation.Label;
import org.kuali.rice.krad.data.provider.annotation.Relationship;
import org.kuali.rice.krad.data.provider.annotation.UifAutoCreateViewType;
import org.kuali.rice.krad.data.provider.annotation.UifAutoCreateViews;
import org.kuali.rice.krad.data.provider.annotation.UifDisplayHint;
import org.kuali.rice.krad.data.provider.annotation.UifDisplayHintType;
import org.kuali.rice.krad.data.provider.annotation.UifDisplayHints;
import org.kuali.rice.krad.data.provider.annotation.UifValidCharactersConstraintBeanName;

@Entity
@Table(name="TRVL_EXP_ITM_T")
@UifAutoCreateViews(value={UifAutoCreateViewType.INQUIRY, UifAutoCreateViewType.LOOKUP})
public class TravelExpenseItem
extends DataObjectBase
implements Serializable,
PersistenceWeaved,
PersistenceObject,
PersistenceWeavedFetchGroups,
PersistenceWeavedLazy,
PersistenceWeavedChangeTracking {
    private static final long serialVersionUID = -4092206384418712220L;
    @Id
    @Column(name="EXP_ITM_ID", length=10)
    @GeneratedValue(generator="TRVL_EXP_ITM_ID_S")
    @PortableSequenceGenerator(name="TRVL_EXP_ITM_ID_S")
    @Label(value="Id")
    @Description(value="Unique identifier for item")
    @UifValidCharactersConstraintBeanName(value="AlphaNumericPatternConstraint")
    private String travelExpenseItemId;
    @Column(name="TRVL_AUTH_DOC_ID", length=40)
    @Label(value="Travel Authorization Document Id")
    @UifDisplayHints(value={@UifDisplayHint(value=UifDisplayHintType.NO_LOOKUP_RESULT), @UifDisplayHint(value=UifDisplayHintType.NO_INQUIRY)})
    private String travelAuthorizationDocumentId;
    @Relationship(foreignKeyFields={"travelAuthorizationDocumentId"})
    @ManyToOne(fetch=FetchType.LAZY, cascade={CascadeType.REFRESH})
    @JoinColumn(name="TRVL_AUTH_DOC_ID", referencedColumnName="TRVL_AUTH_DOC_ID", insertable=false, updatable=false)
    @InheritProperties(value={@InheritProperty(name="documentNumber", label=@Label(value="Travel Authorization Document"), displayHints=@UifDisplayHints(value={@UifDisplayHint(value=UifDisplayHintType.NO_LOOKUP_CRITERIA)}))})
    private TravelAuthorizationDocument travelAuthorizationDocument;
    @Column(name="TRVL_CO_NM")
    private String travelCompanyName;
    @Column(name="EXP_TYP_CD", length=10)
    @Label(value="Expense Type")
    @Description(value="Type of expense")
    private String travelExpenseTypeCd;
    @Column(name="EXP_DESC", length=10)
    @Label(value="Expense Description")
    @Description(value="Description of expense")
    private String expenseDesc;
    @Temporal(value=TemporalType.TIMESTAMP)
    @Column(name="EXP_DT")
    @Label(value="Expense Date")
    @Description(value="Date of expense")
    private Date expenseDate;
    @Column(name="EXP_AMT", length=10)
    @Label(value="Expense Amount")
    @Description(value="Amount of expense")
    private BigDecimal expenseAmount;
    @Column(name="EXP_REIMB", nullable=false, length=1)
    @Convert(converter=BooleanYNConverter.class)
    @Label(value="Reimbursable")
    @Description(value="Whether expense is reimbursed to traveler")
    private boolean reimbursable;
    @Column(name="EXP_TXBL", nullable=false, length=1)
    @Convert(converter=BooleanYNConverter.class)
    @Label(value="Taxable")
    @Description(value="Whether expense is taxed")
    private boolean taxable;
    @Transient
    @XmlTransient
    protected WeavedAttributeValueHolderInterface _persistence_travelAuthorizationDocument_vh;

    public String getTravelExpenseItemId() {
        return this._persistence_get_travelExpenseItemId();
    }

    public void setTravelExpenseItemId(String travelExpenseItemId) {
        this._persistence_set_travelExpenseItemId(travelExpenseItemId);
    }

    public String getTravelAuthorizationDocumentId() {
        if (StringUtils.isBlank((String)this._persistence_get_travelAuthorizationDocumentId()) && this._persistence_get_travelAuthorizationDocument() != null) {
            return this._persistence_get_travelAuthorizationDocument().getDocumentNumber();
        }
        return this._persistence_get_travelAuthorizationDocumentId();
    }

    public void setTravelAuthorizationDocumentId(String travelAuthorizationDocumentId) {
        this._persistence_set_travelAuthorizationDocumentId(travelAuthorizationDocumentId);
    }

    public TravelAuthorizationDocument getTravelAuthorizationDocument() {
        return this._persistence_get_travelAuthorizationDocument();
    }

    public void setTravelAuthorizationDocument(TravelAuthorizationDocument travelAuthorizationDocument) {
        this._persistence_set_travelAuthorizationDocument(travelAuthorizationDocument);
    }

    public String getTravelCompanyName() {
        return this._persistence_get_travelCompanyName();
    }

    public void setTravelCompanyName(String travelCompanyName) {
        this._persistence_set_travelCompanyName(travelCompanyName);
    }

    public String getTravelExpenseTypeCd() {
        return this._persistence_get_travelExpenseTypeCd();
    }

    public void setTravelExpenseTypeCd(String travelExpenseTypeCd) {
        this._persistence_set_travelExpenseTypeCd(travelExpenseTypeCd);
    }

    public String getExpenseDesc() {
        return this._persistence_get_expenseDesc();
    }

    public void setExpenseDesc(String expenseDesc) {
        this._persistence_set_expenseDesc(expenseDesc);
    }

    public Date getExpenseDate() {
        return this._persistence_get_expenseDate();
    }

    public void setExpenseDate(Date expenseDate) {
        this._persistence_set_expenseDate(expenseDate);
    }

    public BigDecimal getExpenseAmount() {
        return this._persistence_get_expenseAmount();
    }

    public void setExpenseAmount(BigDecimal expenseAmount) {
        this._persistence_set_expenseAmount(expenseAmount);
    }

    public boolean isReimbursable() {
        return this._persistence_get_reimbursable();
    }

    public void setReimbursable(boolean reimbursable) {
        this._persistence_set_reimbursable(reimbursable);
    }

    public boolean isTaxable() {
        return this._persistence_get_taxable();
    }

    public void setTaxable(boolean taxable) {
        this._persistence_set_taxable(taxable);
    }

    public Object _persistence_post_clone() {
        Object object = super._persistence_post_clone();
        if (this._persistence_travelAuthorizationDocument_vh != null) {
            this._persistence_travelAuthorizationDocument_vh = (WeavedAttributeValueHolderInterface)this._persistence_travelAuthorizationDocument_vh.clone();
        }
        this._persistence_listener = null;
        this._persistence_fetchGroup = null;
        this._persistence_session = null;
        this._persistence_primaryKey = null;
        return this;
    }

    public Object _persistence_new(PersistenceObject persistenceObject) {
        return new TravelExpenseItem();
    }

    public Object _persistence_get(String string) {
        if (string == "travelExpenseItemId") {
            return this.travelExpenseItemId;
        }
        if (string == "expenseDesc") {
            return this.expenseDesc;
        }
        if (string == "expenseAmount") {
            return this.expenseAmount;
        }
        if (string == "travelExpenseTypeCd") {
            return this.travelExpenseTypeCd;
        }
        if (string == "taxable") {
            return this.taxable;
        }
        if (string == "travelAuthorizationDocument") {
            return this.travelAuthorizationDocument;
        }
        if (string == "travelCompanyName") {
            return this.travelCompanyName;
        }
        if (string == "reimbursable") {
            return this.reimbursable;
        }
        if (string == "travelAuthorizationDocumentId") {
            return this.travelAuthorizationDocumentId;
        }
        if (string == "expenseDate") {
            return this.expenseDate;
        }
        return super._persistence_get(string);
    }

    public void _persistence_set(String string, Object object) {
        if (string == "travelExpenseItemId") {
            this.travelExpenseItemId = (String)object;
            return;
        }
        if (string == "expenseDesc") {
            this.expenseDesc = (String)object;
            return;
        }
        if (string == "expenseAmount") {
            this.expenseAmount = (BigDecimal)object;
            return;
        }
        if (string == "travelExpenseTypeCd") {
            this.travelExpenseTypeCd = (String)object;
            return;
        }
        if (string == "taxable") {
            this.taxable = (Boolean)object;
            return;
        }
        if (string == "travelAuthorizationDocument") {
            this.travelAuthorizationDocument = (TravelAuthorizationDocument)((Object)object);
            return;
        }
        if (string == "travelCompanyName") {
            this.travelCompanyName = (String)object;
            return;
        }
        if (string == "reimbursable") {
            this.reimbursable = (Boolean)object;
            return;
        }
        if (string == "travelAuthorizationDocumentId") {
            this.travelAuthorizationDocumentId = (String)object;
            return;
        }
        if (string == "expenseDate") {
            this.expenseDate = (Date)object;
            return;
        }
        super._persistence_set(string, object);
    }

    public String _persistence_get_travelExpenseItemId() {
        this._persistence_checkFetched("travelExpenseItemId");
        return this.travelExpenseItemId;
    }

    public void _persistence_set_travelExpenseItemId(String string) {
        this._persistence_checkFetchedForSet("travelExpenseItemId");
        this._persistence_propertyChange("travelExpenseItemId", this.travelExpenseItemId, string);
        this.travelExpenseItemId = string;
    }

    public String _persistence_get_expenseDesc() {
        this._persistence_checkFetched("expenseDesc");
        return this.expenseDesc;
    }

    public void _persistence_set_expenseDesc(String string) {
        this._persistence_checkFetchedForSet("expenseDesc");
        this._persistence_propertyChange("expenseDesc", this.expenseDesc, string);
        this.expenseDesc = string;
    }

    public BigDecimal _persistence_get_expenseAmount() {
        this._persistence_checkFetched("expenseAmount");
        return this.expenseAmount;
    }

    public void _persistence_set_expenseAmount(BigDecimal bigDecimal) {
        this._persistence_checkFetchedForSet("expenseAmount");
        this._persistence_propertyChange("expenseAmount", this.expenseAmount, bigDecimal);
        this.expenseAmount = bigDecimal;
    }

    public String _persistence_get_travelExpenseTypeCd() {
        this._persistence_checkFetched("travelExpenseTypeCd");
        return this.travelExpenseTypeCd;
    }

    public void _persistence_set_travelExpenseTypeCd(String string) {
        this._persistence_checkFetchedForSet("travelExpenseTypeCd");
        this._persistence_propertyChange("travelExpenseTypeCd", this.travelExpenseTypeCd, string);
        this.travelExpenseTypeCd = string;
    }

    public boolean _persistence_get_taxable() {
        this._persistence_checkFetched("taxable");
        return this.taxable;
    }

    public void _persistence_set_taxable(boolean bl) {
        this._persistence_checkFetchedForSet("taxable");
        this._persistence_propertyChange("taxable", new Boolean(this.taxable), new Boolean(bl));
        this.taxable = bl;
    }

    protected void _persistence_initialize_travelAuthorizationDocument_vh() {
        if (this._persistence_travelAuthorizationDocument_vh == null) {
            this._persistence_travelAuthorizationDocument_vh = new ValueHolder((Object)this.travelAuthorizationDocument);
            this._persistence_travelAuthorizationDocument_vh.setIsNewlyWeavedValueHolder(true);
        }
    }

    public WeavedAttributeValueHolderInterface _persistence_get_travelAuthorizationDocument_vh() {
        TravelAuthorizationDocument travelAuthorizationDocument;
        this._persistence_initialize_travelAuthorizationDocument_vh();
        if ((this._persistence_travelAuthorizationDocument_vh.isCoordinatedWithProperty() || this._persistence_travelAuthorizationDocument_vh.isNewlyWeavedValueHolder()) && (travelAuthorizationDocument = this._persistence_get_travelAuthorizationDocument()) != this._persistence_travelAuthorizationDocument_vh.getValue()) {
            this._persistence_set_travelAuthorizationDocument(travelAuthorizationDocument);
        }
        return this._persistence_travelAuthorizationDocument_vh;
    }

    public void _persistence_set_travelAuthorizationDocument_vh(WeavedAttributeValueHolderInterface weavedAttributeValueHolderInterface) {
        this._persistence_travelAuthorizationDocument_vh = weavedAttributeValueHolderInterface;
        if (weavedAttributeValueHolderInterface.isInstantiated()) {
            Object object;
            TravelAuthorizationDocument travelAuthorizationDocument = this._persistence_get_travelAuthorizationDocument();
            if (travelAuthorizationDocument != (object = weavedAttributeValueHolderInterface.getValue())) {
                this._persistence_set_travelAuthorizationDocument((TravelAuthorizationDocument)((Object)object));
            }
        } else {
            this.travelAuthorizationDocument = null;
        }
    }

    public TravelAuthorizationDocument _persistence_get_travelAuthorizationDocument() {
        this._persistence_checkFetched("travelAuthorizationDocument");
        this._persistence_initialize_travelAuthorizationDocument_vh();
        this.travelAuthorizationDocument = (TravelAuthorizationDocument)((Object)this._persistence_travelAuthorizationDocument_vh.getValue());
        return this.travelAuthorizationDocument;
    }

    public void _persistence_set_travelAuthorizationDocument(TravelAuthorizationDocument travelAuthorizationDocument) {
        this._persistence_checkFetchedForSet("travelAuthorizationDocument");
        this._persistence_initialize_travelAuthorizationDocument_vh();
        this.travelAuthorizationDocument = (TravelAuthorizationDocument)((Object)this._persistence_travelAuthorizationDocument_vh.getValue());
        this._persistence_propertyChange("travelAuthorizationDocument", (Object)this.travelAuthorizationDocument, (Object)travelAuthorizationDocument);
        this.travelAuthorizationDocument = travelAuthorizationDocument;
        this._persistence_travelAuthorizationDocument_vh.setValue((Object)travelAuthorizationDocument);
    }

    public String _persistence_get_travelCompanyName() {
        this._persistence_checkFetched("travelCompanyName");
        return this.travelCompanyName;
    }

    public void _persistence_set_travelCompanyName(String string) {
        this._persistence_checkFetchedForSet("travelCompanyName");
        this._persistence_propertyChange("travelCompanyName", this.travelCompanyName, string);
        this.travelCompanyName = string;
    }

    public boolean _persistence_get_reimbursable() {
        this._persistence_checkFetched("reimbursable");
        return this.reimbursable;
    }

    public void _persistence_set_reimbursable(boolean bl) {
        this._persistence_checkFetchedForSet("reimbursable");
        this._persistence_propertyChange("reimbursable", new Boolean(this.reimbursable), new Boolean(bl));
        this.reimbursable = bl;
    }

    public String _persistence_get_travelAuthorizationDocumentId() {
        this._persistence_checkFetched("travelAuthorizationDocumentId");
        return this.travelAuthorizationDocumentId;
    }

    public void _persistence_set_travelAuthorizationDocumentId(String string) {
        this._persistence_checkFetchedForSet("travelAuthorizationDocumentId");
        this._persistence_propertyChange("travelAuthorizationDocumentId", this.travelAuthorizationDocumentId, string);
        this.travelAuthorizationDocumentId = string;
    }

    public Date _persistence_get_expenseDate() {
        this._persistence_checkFetched("expenseDate");
        return this.expenseDate;
    }

    public void _persistence_set_expenseDate(Date date) {
        this._persistence_checkFetchedForSet("expenseDate");
        this._persistence_propertyChange("expenseDate", this.expenseDate, date);
        this.expenseDate = date;
    }
}

