/*
 * Decompiled with CFR 0.152.
 */
package edu.sampleu.travel.dataobject;

import edu.sampleu.travel.dataobject.TravelAuthorizationDocument;
import edu.sampleu.travel.dataobject.TravelDestination;
import edu.sampleu.travel.dataobject.TravelMileageRate;
import edu.sampleu.travel.options.MileageRateKeyValues;
import edu.sampleu.travel.options.TravelDestinationKeyValues;
import java.io.Serializable;
import java.math.BigDecimal;
import java.util.Date;
import javax.persistence.CascadeType;
import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.FetchType;
import javax.persistence.GeneratedValue;
import javax.persistence.Id;
import javax.persistence.JoinColumn;
import javax.persistence.ManyToOne;
import javax.persistence.Table;
import javax.persistence.Temporal;
import javax.persistence.TemporalType;
import javax.persistence.Transient;
import javax.xml.bind.annotation.XmlTransient;
import org.apache.commons.lang.StringUtils;
import org.eclipse.persistence.indirection.ValueHolder;
import org.eclipse.persistence.indirection.WeavedAttributeValueHolderInterface;
import org.eclipse.persistence.internal.descriptors.PersistenceObject;
import org.eclipse.persistence.internal.weaving.PersistenceWeaved;
import org.eclipse.persistence.internal.weaving.PersistenceWeavedChangeTracking;
import org.eclipse.persistence.internal.weaving.PersistenceWeavedFetchGroups;
import org.eclipse.persistence.internal.weaving.PersistenceWeavedLazy;
import org.kuali.rice.krad.bo.DataObjectBase;
import org.kuali.rice.krad.data.jpa.PortableSequenceGenerator;
import org.kuali.rice.krad.data.provider.annotation.Description;
import org.kuali.rice.krad.data.provider.annotation.InheritProperties;
import org.kuali.rice.krad.data.provider.annotation.InheritProperty;
import org.kuali.rice.krad.data.provider.annotation.KeyValuesFinderClass;
import org.kuali.rice.krad.data.provider.annotation.Label;
import org.kuali.rice.krad.data.provider.annotation.Relationship;
import org.kuali.rice.krad.data.provider.annotation.UifAutoCreateViewType;
import org.kuali.rice.krad.data.provider.annotation.UifAutoCreateViews;
import org.kuali.rice.krad.data.provider.annotation.UifDisplayHint;
import org.kuali.rice.krad.data.provider.annotation.UifDisplayHintType;
import org.kuali.rice.krad.data.provider.annotation.UifDisplayHints;
import org.kuali.rice.krad.data.provider.annotation.UifValidCharactersConstraintBeanName;

@Entity
@Table(name="TRVL_PD_EXP_T")
@UifAutoCreateViews(value={UifAutoCreateViewType.INQUIRY, UifAutoCreateViewType.LOOKUP})
public class TravelPerDiemExpense
extends DataObjectBase
implements Serializable,
PersistenceWeaved,
PersistenceObject,
PersistenceWeavedFetchGroups,
PersistenceWeavedLazy,
PersistenceWeavedChangeTracking {
    private static final long serialVersionUID = 6269893036439679855L;
    @Id
    @Column(name="PD_EXP_ID", length=10)
    @GeneratedValue(generator="TRVL_PD_EXP_ID_S")
    @PortableSequenceGenerator(name="TRVL_PD_EXP_ID_S")
    @Label(value="Id")
    @Description(value="Unique identifier for per diem expense item")
    @UifValidCharactersConstraintBeanName(value="AlphaNumericPatternConstraint")
    private String travelPerDiemExpenseId;
    @Column(name="TRVL_AUTH_DOC_ID", length=40)
    @Label(value="Travel Authorization Document Id")
    @UifDisplayHints(value={@UifDisplayHint(value=UifDisplayHintType.NO_LOOKUP_RESULT), @UifDisplayHint(value=UifDisplayHintType.NO_INQUIRY)})
    private String travelAuthorizationDocumentId;
    @Relationship(foreignKeyFields={"travelAuthorizationDocumentId"})
    @ManyToOne(fetch=FetchType.LAZY, cascade={CascadeType.REFRESH})
    @JoinColumn(name="TRVL_AUTH_DOC_ID", referencedColumnName="TRVL_AUTH_DOC_ID", insertable=false, updatable=false)
    @InheritProperties(value={@InheritProperty(name="documentNumber", label=@Label(value="Travel Authorization Document"), displayHints=@UifDisplayHints(value={@UifDisplayHint(value=UifDisplayHintType.NO_LOOKUP_CRITERIA)}))})
    private TravelAuthorizationDocument travelAuthorizationDocument;
    @Column(name="TRVL_DEST_ID", length=40)
    @Label(value="Primary Destination")
    @Description(value="Primary Destination related to per diem expense")
    @KeyValuesFinderClass(value=TravelDestinationKeyValues.class)
    @UifDisplayHints(value={@UifDisplayHint(value=UifDisplayHintType.NONE), @UifDisplayHint(value=UifDisplayHintType.NO_LOOKUP_RESULT), @UifDisplayHint(value=UifDisplayHintType.NO_INQUIRY)})
    private String travelDestinationId;
    @Relationship(foreignKeyFields={"travelDestinationId"})
    @ManyToOne(fetch=FetchType.LAZY, cascade={CascadeType.REFRESH})
    @JoinColumn(name="TRVL_DEST_ID", insertable=false, updatable=false)
    @InheritProperties(value={@InheritProperty(name="travelDestinationId", label=@Label(value="Primary Destination"), displayHints=@UifDisplayHints(value={@UifDisplayHint(value=UifDisplayHintType.NO_LOOKUP_CRITERIA)}))})
    @UifDisplayHint(value=UifDisplayHintType.NO_LOOKUP_CRITERIA)
    private TravelDestination travelDestination;
    @Temporal(value=TemporalType.TIMESTAMP)
    @Column(name="PD_DT")
    @Label(value="Date of Use")
    private Date perDiemDate;
    @Column(name="BKFST_VAL")
    @Label(value="Breakfast Value")
    private BigDecimal breakfastValue;
    @Column(name="LNCH_VAL")
    @Label(value="Lunch Value")
    private BigDecimal lunchValue;
    @Column(name="DNNR_VAL")
    @Label(value="Dinner Value")
    private BigDecimal dinnerValue;
    @Column(name="INCD_VAL")
    @Label(value="Amount estimated for incidentals")
    private BigDecimal incidentalsValue;
    @Column(name="MLG_RT_ID", length=40)
    @Label(value="Mileage Rate")
    @Description(value="Mileage Rate Code Used")
    @KeyValuesFinderClass(value=MileageRateKeyValues.class)
    @UifDisplayHints(value={@UifDisplayHint(value=UifDisplayHintType.NONE), @UifDisplayHint(value=UifDisplayHintType.NO_LOOKUP_RESULT), @UifDisplayHint(value=UifDisplayHintType.NO_INQUIRY)})
    private String mileageRateId;
    @Relationship(foreignKeyFields={"mileageRateId"})
    @ManyToOne(fetch=FetchType.LAZY, cascade={CascadeType.REFRESH})
    @JoinColumn(name="MLG_RT_ID", insertable=false, updatable=false)
    @InheritProperties(value={@InheritProperty(name="mileageRateCd", label=@Label(value="Mileage rate"), displayHints=@UifDisplayHints(value={@UifDisplayHint(value=UifDisplayHintType.NO_LOOKUP_CRITERIA)}))})
    private TravelMileageRate mileageRate;
    @Column(name="MLG_EST")
    @Label(value="Number of estimated miles")
    private BigDecimal estimatedMileage;
    @Transient
    @XmlTransient
    protected WeavedAttributeValueHolderInterface _persistence_mileageRate_vh;
    @Transient
    @XmlTransient
    protected WeavedAttributeValueHolderInterface _persistence_travelAuthorizationDocument_vh;
    @Transient
    @XmlTransient
    protected WeavedAttributeValueHolderInterface _persistence_travelDestination_vh;

    public String getTravelPerDiemExpenseId() {
        return this._persistence_get_travelPerDiemExpenseId();
    }

    public void setTravelPerDiemExpenseId(String travelPerDiemExpenseId) {
        this._persistence_set_travelPerDiemExpenseId(travelPerDiemExpenseId);
    }

    public String getTravelAuthorizationDocumentId() {
        if (StringUtils.isBlank((String)this._persistence_get_travelAuthorizationDocumentId()) && this._persistence_get_travelAuthorizationDocument() != null) {
            return this._persistence_get_travelAuthorizationDocument().getDocumentNumber();
        }
        return this._persistence_get_travelAuthorizationDocumentId();
    }

    public void setTravelAuthorizationDocumentId(String travelAuthorizationDocumentId) {
        this._persistence_set_travelAuthorizationDocumentId(travelAuthorizationDocumentId);
    }

    public TravelAuthorizationDocument getTravelAuthorizationDocument() {
        return this._persistence_get_travelAuthorizationDocument();
    }

    public void setTravelAuthorizationDocument(TravelAuthorizationDocument travelAuthorizationDocument) {
        this._persistence_set_travelAuthorizationDocument(travelAuthorizationDocument);
    }

    public Date getPerDiemDate() {
        return this._persistence_get_perDiemDate();
    }

    public void setPerDiemDate(Date perDiemDate) {
        this._persistence_set_perDiemDate(perDiemDate);
    }

    public BigDecimal getBreakfastValue() {
        return this._persistence_get_breakfastValue();
    }

    public void setBreakfastValue(BigDecimal breakfastValue) {
        this._persistence_set_breakfastValue(breakfastValue);
    }

    public BigDecimal getLunchValue() {
        return this._persistence_get_lunchValue();
    }

    public void setLunchValue(BigDecimal lunchValue) {
        this._persistence_set_lunchValue(lunchValue);
    }

    public BigDecimal getDinnerValue() {
        return this._persistence_get_dinnerValue();
    }

    public void setDinnerValue(BigDecimal dinnerValue) {
        this._persistence_set_dinnerValue(dinnerValue);
    }

    public BigDecimal getIncidentalsValue() {
        return this._persistence_get_incidentalsValue();
    }

    public void setIncidentalsValue(BigDecimal incidentalsValue) {
        this._persistence_set_incidentalsValue(incidentalsValue);
    }

    public String getTravelDestinationId() {
        return this._persistence_get_travelDestinationId();
    }

    public void setTravelDestinationId(String travelDestinationId) {
        this._persistence_set_travelDestinationId(travelDestinationId);
    }

    public TravelDestination getTravelDestination() {
        return this._persistence_get_travelDestination();
    }

    public void setTravelDestination(TravelDestination travelDestination) {
        this._persistence_set_travelDestination(travelDestination);
    }

    public String getMileageRateId() {
        return this._persistence_get_mileageRateId();
    }

    public void setMileageRateId(String mileageRateId) {
        this._persistence_set_mileageRateId(mileageRateId);
    }

    public TravelMileageRate getMileageRate() {
        return this._persistence_get_mileageRate();
    }

    public void setMileageRate(TravelMileageRate mileageRate) {
        this._persistence_set_mileageRate(mileageRate);
    }

    public BigDecimal getEstimatedMileage() {
        return this._persistence_get_estimatedMileage();
    }

    public void setEstimatedMileage(BigDecimal estimatedMileage) {
        this._persistence_set_estimatedMileage(estimatedMileage);
    }

    public Object _persistence_post_clone() {
        Object object = super._persistence_post_clone();
        if (this._persistence_mileageRate_vh != null) {
            this._persistence_mileageRate_vh = (WeavedAttributeValueHolderInterface)this._persistence_mileageRate_vh.clone();
        }
        if (this._persistence_travelAuthorizationDocument_vh != null) {
            this._persistence_travelAuthorizationDocument_vh = (WeavedAttributeValueHolderInterface)this._persistence_travelAuthorizationDocument_vh.clone();
        }
        if (this._persistence_travelDestination_vh != null) {
            this._persistence_travelDestination_vh = (WeavedAttributeValueHolderInterface)this._persistence_travelDestination_vh.clone();
        }
        this._persistence_listener = null;
        this._persistence_fetchGroup = null;
        this._persistence_session = null;
        this._persistence_primaryKey = null;
        return this;
    }

    public Object _persistence_new(PersistenceObject persistenceObject) {
        return new TravelPerDiemExpense();
    }

    public Object _persistence_get(String string) {
        if (string == "mileageRate") {
            return this.mileageRate;
        }
        if (string == "perDiemDate") {
            return this.perDiemDate;
        }
        if (string == "estimatedMileage") {
            return this.estimatedMileage;
        }
        if (string == "travelDestinationId") {
            return this.travelDestinationId;
        }
        if (string == "travelAuthorizationDocument") {
            return this.travelAuthorizationDocument;
        }
        if (string == "lunchValue") {
            return this.lunchValue;
        }
        if (string == "travelDestination") {
            return this.travelDestination;
        }
        if (string == "travelAuthorizationDocumentId") {
            return this.travelAuthorizationDocumentId;
        }
        if (string == "travelPerDiemExpenseId") {
            return this.travelPerDiemExpenseId;
        }
        if (string == "incidentalsValue") {
            return this.incidentalsValue;
        }
        if (string == "mileageRateId") {
            return this.mileageRateId;
        }
        if (string == "breakfastValue") {
            return this.breakfastValue;
        }
        if (string == "dinnerValue") {
            return this.dinnerValue;
        }
        return super._persistence_get(string);
    }

    public void _persistence_set(String string, Object object) {
        if (string == "mileageRate") {
            this.mileageRate = (TravelMileageRate)object;
            return;
        }
        if (string == "perDiemDate") {
            this.perDiemDate = (Date)object;
            return;
        }
        if (string == "estimatedMileage") {
            this.estimatedMileage = (BigDecimal)object;
            return;
        }
        if (string == "travelDestinationId") {
            this.travelDestinationId = (String)object;
            return;
        }
        if (string == "travelAuthorizationDocument") {
            this.travelAuthorizationDocument = (TravelAuthorizationDocument)((Object)object);
            return;
        }
        if (string == "lunchValue") {
            this.lunchValue = (BigDecimal)object;
            return;
        }
        if (string == "travelDestination") {
            this.travelDestination = (TravelDestination)object;
            return;
        }
        if (string == "travelAuthorizationDocumentId") {
            this.travelAuthorizationDocumentId = (String)object;
            return;
        }
        if (string == "travelPerDiemExpenseId") {
            this.travelPerDiemExpenseId = (String)object;
            return;
        }
        if (string == "incidentalsValue") {
            this.incidentalsValue = (BigDecimal)object;
            return;
        }
        if (string == "mileageRateId") {
            this.mileageRateId = (String)object;
            return;
        }
        if (string == "breakfastValue") {
            this.breakfastValue = (BigDecimal)object;
            return;
        }
        if (string == "dinnerValue") {
            this.dinnerValue = (BigDecimal)object;
            return;
        }
        super._persistence_set(string, object);
    }

    protected void _persistence_initialize_mileageRate_vh() {
        if (this._persistence_mileageRate_vh == null) {
            this._persistence_mileageRate_vh = new ValueHolder((Object)this.mileageRate);
            this._persistence_mileageRate_vh.setIsNewlyWeavedValueHolder(true);
        }
    }

    public WeavedAttributeValueHolderInterface _persistence_get_mileageRate_vh() {
        TravelMileageRate travelMileageRate;
        this._persistence_initialize_mileageRate_vh();
        if ((this._persistence_mileageRate_vh.isCoordinatedWithProperty() || this._persistence_mileageRate_vh.isNewlyWeavedValueHolder()) && (travelMileageRate = this._persistence_get_mileageRate()) != this._persistence_mileageRate_vh.getValue()) {
            this._persistence_set_mileageRate(travelMileageRate);
        }
        return this._persistence_mileageRate_vh;
    }

    public void _persistence_set_mileageRate_vh(WeavedAttributeValueHolderInterface weavedAttributeValueHolderInterface) {
        this._persistence_mileageRate_vh = weavedAttributeValueHolderInterface;
        if (weavedAttributeValueHolderInterface.isInstantiated()) {
            Object object;
            TravelMileageRate travelMileageRate = this._persistence_get_mileageRate();
            if (travelMileageRate != (object = weavedAttributeValueHolderInterface.getValue())) {
                this._persistence_set_mileageRate((TravelMileageRate)object);
            }
        } else {
            this.mileageRate = null;
        }
    }

    public TravelMileageRate _persistence_get_mileageRate() {
        this._persistence_checkFetched("mileageRate");
        this._persistence_initialize_mileageRate_vh();
        this.mileageRate = (TravelMileageRate)this._persistence_mileageRate_vh.getValue();
        return this.mileageRate;
    }

    public void _persistence_set_mileageRate(TravelMileageRate travelMileageRate) {
        this._persistence_checkFetchedForSet("mileageRate");
        this._persistence_initialize_mileageRate_vh();
        this.mileageRate = (TravelMileageRate)this._persistence_mileageRate_vh.getValue();
        this._persistence_propertyChange("mileageRate", this.mileageRate, travelMileageRate);
        this.mileageRate = travelMileageRate;
        this._persistence_mileageRate_vh.setValue((Object)travelMileageRate);
    }

    public Date _persistence_get_perDiemDate() {
        this._persistence_checkFetched("perDiemDate");
        return this.perDiemDate;
    }

    public void _persistence_set_perDiemDate(Date date) {
        this._persistence_checkFetchedForSet("perDiemDate");
        this._persistence_propertyChange("perDiemDate", this.perDiemDate, date);
        this.perDiemDate = date;
    }

    public BigDecimal _persistence_get_estimatedMileage() {
        this._persistence_checkFetched("estimatedMileage");
        return this.estimatedMileage;
    }

    public void _persistence_set_estimatedMileage(BigDecimal bigDecimal) {
        this._persistence_checkFetchedForSet("estimatedMileage");
        this._persistence_propertyChange("estimatedMileage", this.estimatedMileage, bigDecimal);
        this.estimatedMileage = bigDecimal;
    }

    public String _persistence_get_travelDestinationId() {
        this._persistence_checkFetched("travelDestinationId");
        return this.travelDestinationId;
    }

    public void _persistence_set_travelDestinationId(String string) {
        this._persistence_checkFetchedForSet("travelDestinationId");
        this._persistence_propertyChange("travelDestinationId", this.travelDestinationId, string);
        this.travelDestinationId = string;
    }

    protected void _persistence_initialize_travelAuthorizationDocument_vh() {
        if (this._persistence_travelAuthorizationDocument_vh == null) {
            this._persistence_travelAuthorizationDocument_vh = new ValueHolder((Object)this.travelAuthorizationDocument);
            this._persistence_travelAuthorizationDocument_vh.setIsNewlyWeavedValueHolder(true);
        }
    }

    public WeavedAttributeValueHolderInterface _persistence_get_travelAuthorizationDocument_vh() {
        TravelAuthorizationDocument travelAuthorizationDocument;
        this._persistence_initialize_travelAuthorizationDocument_vh();
        if ((this._persistence_travelAuthorizationDocument_vh.isCoordinatedWithProperty() || this._persistence_travelAuthorizationDocument_vh.isNewlyWeavedValueHolder()) && (travelAuthorizationDocument = this._persistence_get_travelAuthorizationDocument()) != this._persistence_travelAuthorizationDocument_vh.getValue()) {
            this._persistence_set_travelAuthorizationDocument(travelAuthorizationDocument);
        }
        return this._persistence_travelAuthorizationDocument_vh;
    }

    public void _persistence_set_travelAuthorizationDocument_vh(WeavedAttributeValueHolderInterface weavedAttributeValueHolderInterface) {
        this._persistence_travelAuthorizationDocument_vh = weavedAttributeValueHolderInterface;
        if (weavedAttributeValueHolderInterface.isInstantiated()) {
            Object object;
            TravelAuthorizationDocument travelAuthorizationDocument = this._persistence_get_travelAuthorizationDocument();
            if (travelAuthorizationDocument != (object = weavedAttributeValueHolderInterface.getValue())) {
                this._persistence_set_travelAuthorizationDocument((TravelAuthorizationDocument)((Object)object));
            }
        } else {
            this.travelAuthorizationDocument = null;
        }
    }

    public TravelAuthorizationDocument _persistence_get_travelAuthorizationDocument() {
        this._persistence_checkFetched("travelAuthorizationDocument");
        this._persistence_initialize_travelAuthorizationDocument_vh();
        this.travelAuthorizationDocument = (TravelAuthorizationDocument)((Object)this._persistence_travelAuthorizationDocument_vh.getValue());
        return this.travelAuthorizationDocument;
    }

    public void _persistence_set_travelAuthorizationDocument(TravelAuthorizationDocument travelAuthorizationDocument) {
        this._persistence_checkFetchedForSet("travelAuthorizationDocument");
        this._persistence_initialize_travelAuthorizationDocument_vh();
        this.travelAuthorizationDocument = (TravelAuthorizationDocument)((Object)this._persistence_travelAuthorizationDocument_vh.getValue());
        this._persistence_propertyChange("travelAuthorizationDocument", (Object)this.travelAuthorizationDocument, (Object)travelAuthorizationDocument);
        this.travelAuthorizationDocument = travelAuthorizationDocument;
        this._persistence_travelAuthorizationDocument_vh.setValue((Object)travelAuthorizationDocument);
    }

    public BigDecimal _persistence_get_lunchValue() {
        this._persistence_checkFetched("lunchValue");
        return this.lunchValue;
    }

    public void _persistence_set_lunchValue(BigDecimal bigDecimal) {
        this._persistence_checkFetchedForSet("lunchValue");
        this._persistence_propertyChange("lunchValue", this.lunchValue, bigDecimal);
        this.lunchValue = bigDecimal;
    }

    protected void _persistence_initialize_travelDestination_vh() {
        if (this._persistence_travelDestination_vh == null) {
            this._persistence_travelDestination_vh = new ValueHolder((Object)this.travelDestination);
            this._persistence_travelDestination_vh.setIsNewlyWeavedValueHolder(true);
        }
    }

    public WeavedAttributeValueHolderInterface _persistence_get_travelDestination_vh() {
        TravelDestination travelDestination;
        this._persistence_initialize_travelDestination_vh();
        if ((this._persistence_travelDestination_vh.isCoordinatedWithProperty() || this._persistence_travelDestination_vh.isNewlyWeavedValueHolder()) && (travelDestination = this._persistence_get_travelDestination()) != this._persistence_travelDestination_vh.getValue()) {
            this._persistence_set_travelDestination(travelDestination);
        }
        return this._persistence_travelDestination_vh;
    }

    public void _persistence_set_travelDestination_vh(WeavedAttributeValueHolderInterface weavedAttributeValueHolderInterface) {
        this._persistence_travelDestination_vh = weavedAttributeValueHolderInterface;
        if (weavedAttributeValueHolderInterface.isInstantiated()) {
            Object object;
            TravelDestination travelDestination = this._persistence_get_travelDestination();
            if (travelDestination != (object = weavedAttributeValueHolderInterface.getValue())) {
                this._persistence_set_travelDestination((TravelDestination)object);
            }
        } else {
            this.travelDestination = null;
        }
    }

    public TravelDestination _persistence_get_travelDestination() {
        this._persistence_checkFetched("travelDestination");
        this._persistence_initialize_travelDestination_vh();
        this.travelDestination = (TravelDestination)this._persistence_travelDestination_vh.getValue();
        return this.travelDestination;
    }

    public void _persistence_set_travelDestination(TravelDestination travelDestination) {
        this._persistence_checkFetchedForSet("travelDestination");
        this._persistence_initialize_travelDestination_vh();
        this.travelDestination = (TravelDestination)this._persistence_travelDestination_vh.getValue();
        this._persistence_propertyChange("travelDestination", this.travelDestination, travelDestination);
        this.travelDestination = travelDestination;
        this._persistence_travelDestination_vh.setValue((Object)travelDestination);
    }

    public String _persistence_get_travelAuthorizationDocumentId() {
        this._persistence_checkFetched("travelAuthorizationDocumentId");
        return this.travelAuthorizationDocumentId;
    }

    public void _persistence_set_travelAuthorizationDocumentId(String string) {
        this._persistence_checkFetchedForSet("travelAuthorizationDocumentId");
        this._persistence_propertyChange("travelAuthorizationDocumentId", this.travelAuthorizationDocumentId, string);
        this.travelAuthorizationDocumentId = string;
    }

    public String _persistence_get_travelPerDiemExpenseId() {
        this._persistence_checkFetched("travelPerDiemExpenseId");
        return this.travelPerDiemExpenseId;
    }

    public void _persistence_set_travelPerDiemExpenseId(String string) {
        this._persistence_checkFetchedForSet("travelPerDiemExpenseId");
        this._persistence_propertyChange("travelPerDiemExpenseId", this.travelPerDiemExpenseId, string);
        this.travelPerDiemExpenseId = string;
    }

    public BigDecimal _persistence_get_incidentalsValue() {
        this._persistence_checkFetched("incidentalsValue");
        return this.incidentalsValue;
    }

    public void _persistence_set_incidentalsValue(BigDecimal bigDecimal) {
        this._persistence_checkFetchedForSet("incidentalsValue");
        this._persistence_propertyChange("incidentalsValue", this.incidentalsValue, bigDecimal);
        this.incidentalsValue = bigDecimal;
    }

    public String _persistence_get_mileageRateId() {
        this._persistence_checkFetched("mileageRateId");
        return this.mileageRateId;
    }

    public void _persistence_set_mileageRateId(String string) {
        this._persistence_checkFetchedForSet("mileageRateId");
        this._persistence_propertyChange("mileageRateId", this.mileageRateId, string);
        this.mileageRateId = string;
    }

    public BigDecimal _persistence_get_breakfastValue() {
        this._persistence_checkFetched("breakfastValue");
        return this.breakfastValue;
    }

    public void _persistence_set_breakfastValue(BigDecimal bigDecimal) {
        this._persistence_checkFetchedForSet("breakfastValue");
        this._persistence_propertyChange("breakfastValue", this.breakfastValue, bigDecimal);
        this.breakfastValue = bigDecimal;
    }

    public BigDecimal _persistence_get_dinnerValue() {
        this._persistence_checkFetched("dinnerValue");
        return this.dinnerValue;
    }

    public void _persistence_set_dinnerValue(BigDecimal bigDecimal) {
        this._persistence_checkFetchedForSet("dinnerValue");
        this._persistence_propertyChange("dinnerValue", this.dinnerValue, bigDecimal);
        this.dinnerValue = bigDecimal;
    }
}

