/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.rice.krad.demo.uif.lookup;

import java.text.NumberFormat;
import java.text.ParseException;
import java.util.Map;
import org.apache.commons.lang.StringUtils;
import org.kuali.rice.krad.lookup.LookupForm;
import org.kuali.rice.krad.lookup.LookupableImpl;
import org.kuali.rice.krad.util.GlobalVariables;

public class TravelLookupableImpl
extends LookupableImpl {
    protected boolean validateSearchParameters(LookupForm form, Map<String, String> searchCriteria) {
        boolean valid = super.validateSearchParameters(form, searchCriteria);
        if (form.getViewPostMetadata() != null && form.getViewPostMetadata().getLookupCriteria() != null) {
            for (Map.Entry lookupCriteria : form.getViewPostMetadata().getLookupCriteria().entrySet()) {
                String propertyName = (String)lookupCriteria.getKey();
                this.validateSearchParameterPositiveValues(form, propertyName, searchCriteria.get(propertyName));
            }
        }
        if (GlobalVariables.getMessageMap().hasErrors()) {
            valid = false;
        }
        return valid;
    }

    protected void validateSearchParameterPositiveValues(LookupForm form, String propertyName, String searchPropertyValue) {
        if (StringUtils.isBlank((String)searchPropertyValue)) {
            return;
        }
        NumberFormat format = NumberFormat.getInstance();
        Number number = null;
        try {
            number = format.parse(searchPropertyValue);
        }
        catch (ParseException e) {
            return;
        }
        if (Math.signum(number.doubleValue()) < 0.0) {
            GlobalVariables.getMessageMap().putError(propertyName, "error.negatives.not.allowed.on.field", new String[]{this.getCriteriaLabel(form, propertyName)});
        }
    }
}

