/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.rice.krad.labs.transaction;

import java.io.Serializable;
import java.math.BigDecimal;
import java.math.MathContext;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import org.apache.commons.lang.RandomStringUtils;
import org.kuali.rice.krad.labs.transaction.Tag;

public class TransactionModel
implements Serializable {
    private static final long serialVersionUID = 5227859879033967666L;
    private String id;
    private String accountId;
    private String statusString = RandomStringUtils.randomAlphanumeric((int)4);
    private String idString = RandomStringUtils.randomAlphanumeric((int)4);
    private TransactionModel parentTransaction;
    private Date creationDate = new Date();
    private Date effectiveDate = new Date();
    private Date originationDate = new Date();
    private Date recognitionDate = new Date();
    private BigDecimal amount = new BigDecimal(Math.random() * 100.0, new MathContext(2));
    private String currencyCode = RandomStringUtils.randomAlphanumeric((int)4);
    private BigDecimal nativeAmount = new BigDecimal(Math.random() * 100.0, new MathContext(2));
    private String glEntryGenerated = RandomStringUtils.randomAlphanumeric((int)4);
    private String internal = RandomStringUtils.randomAlphanumeric((int)4);
    private BigDecimal allocatedAmount = new BigDecimal(Math.random() * 100.0, new MathContext(2));
    private BigDecimal lockedAllocatedAmount = new BigDecimal(Math.random() * 100.0, new MathContext(2));
    private String rollupDescription = RandomStringUtils.randomAlphanumeric((int)4);
    private String generalLedgerTypeDescription = RandomStringUtils.randomAlphanumeric((int)4);
    private String glOverridden = RandomStringUtils.randomAlphanumeric((int)4);
    private Date clearDate = new Date();
    private String paymentRefundable = RandomStringUtils.randomAlphanumeric((int)4);
    private String paymentRefundRule = RandomStringUtils.randomAlphanumeric((int)4);
    private BigDecimal originalAmount = new BigDecimal(Math.random() * 100.0, new MathContext(2));
    private Date defermentExpirationDate = new Date();
    private String chargeCancellationRule = RandomStringUtils.randomAlphanumeric((int)4);
    private BigDecimal chargeAmount = new BigDecimal(Math.random() * 100.0, new MathContext(2));
    private BigDecimal paymentAmount = new BigDecimal(Math.random() * 100.0, new MathContext(2));
    private BigDecimal defermentAmount = new BigDecimal(Math.random() * 100.0, new MathContext(2));
    private BigDecimal allocatedLockedAllocated = new BigDecimal(Math.random() * 100.0, new MathContext(2));
    private BigDecimal unallocatedAmount = new BigDecimal(Math.random() * 100.0, new MathContext(2));
    private BigDecimal chargeTotal = new BigDecimal(Math.random() * 100.0, new MathContext(2));
    private BigDecimal paymentTotal = new BigDecimal(Math.random() * 100.0, new MathContext(2));
    private BigDecimal defermentTotal = new BigDecimal(Math.random() * 100.0, new MathContext(2));
    private BigDecimal allocatedTotal = new BigDecimal(Math.random() * 100.0, new MathContext(2));
    private BigDecimal unallocatedTotal = new BigDecimal(Math.random() * 100.0, new MathContext(2));
    private String transactionDisplayType;
    private String transactionTypeDescription = "Description Description Description";
    private String tagList = "TAG LIST";
    private String newTag = "NEW TAG";
    private List<TransactionModel> subTransactions;
    private List<Tag> tagModels = new ArrayList();

    public TransactionModel() {
        this.id = RandomStringUtils.randomAlphanumeric((int)4);
        this.accountId = RandomStringUtils.randomAlphanumeric((int)4);
        this.transactionDisplayType = "type" + RandomStringUtils.randomNumeric((int)2);
    }

    public TransactionModel(int subTransactionsItemNumber) {
        this();
        int i;
        this.subTransactions = new ArrayList();
        this.parentTransaction = new TransactionModel();
        for (i = 0; i < subTransactionsItemNumber; ++i) {
            this.subTransactions.add(new TransactionModel(0));
        }
        for (i = 0; i < subTransactionsItemNumber; ++i) {
            this.tagModels.add(new Tag());
        }
    }

    public String getAccountId() {
        return this.accountId;
    }

    public void setAccountId(String accountId) {
        this.accountId = accountId;
    }

    public BigDecimal getAllocatedAmount() {
        return this.allocatedAmount;
    }

    public void setAllocatedAmount(BigDecimal allocatedAmount) {
        this.allocatedAmount = allocatedAmount;
    }

    public BigDecimal getAmount() {
        return this.amount;
    }

    public void setAmount(BigDecimal amount) {
        this.amount = amount;
    }

    public String getChargeCancellationRule() {
        return this.chargeCancellationRule;
    }

    public void setChargeCancellationRule(String chargeCancellationRule) {
        this.chargeCancellationRule = chargeCancellationRule;
    }

    public Date getClearDate() {
        return this.clearDate;
    }

    public void setClearDate(Date clearDate) {
        this.clearDate = clearDate;
    }

    public Date getCreationDate() {
        return this.creationDate;
    }

    public void setCreationDate(Date creationDate) {
        this.creationDate = creationDate;
    }

    public String getCurrencyCode() {
        return this.currencyCode;
    }

    public void setCurrencyCode(String currencyCode) {
        this.currencyCode = currencyCode;
    }

    public Date getDefermentExpirationDate() {
        return this.defermentExpirationDate;
    }

    public void setDefermentExpirationDate(Date defermentExpirationDate) {
        this.defermentExpirationDate = defermentExpirationDate;
    }

    public String getGeneralLedgerTypeDescription() {
        return this.generalLedgerTypeDescription;
    }

    public void setGeneralLedgerTypeDescription(String generalLedgerTypeDescription) {
        this.generalLedgerTypeDescription = generalLedgerTypeDescription;
    }

    public String getGlEntryGenerated() {
        return this.glEntryGenerated;
    }

    public void setGlEntryGenerated(String glEntryGenerated) {
        this.glEntryGenerated = glEntryGenerated;
    }

    public String getGlOverridden() {
        return this.glOverridden;
    }

    public void setGlOverridden(String glOverridden) {
        this.glOverridden = glOverridden;
    }

    public String getIdString() {
        return this.idString;
    }

    public void setIdString(String idString) {
        this.idString = idString;
    }

    public String getInternal() {
        return this.internal;
    }

    public void setInternal(String internal) {
        this.internal = internal;
    }

    public BigDecimal getLockedAllocatedAmount() {
        return this.lockedAllocatedAmount;
    }

    public void setLockedAllocatedAmount(BigDecimal lockedAllocatedAmount) {
        this.lockedAllocatedAmount = lockedAllocatedAmount;
    }

    public BigDecimal getNativeAmount() {
        return this.nativeAmount;
    }

    public void setNativeAmount(BigDecimal nativeAmount) {
        this.nativeAmount = nativeAmount;
    }

    public BigDecimal getOriginalAmount() {
        return this.originalAmount;
    }

    public void setOriginalAmount(BigDecimal originalAmount) {
        this.originalAmount = originalAmount;
    }

    public Date getOriginationDate() {
        return this.originationDate;
    }

    public void setOriginationDate(Date originationDate) {
        this.originationDate = originationDate;
    }

    public TransactionModel getParentTransaction() {
        return this.parentTransaction;
    }

    public void setParentTransaction(TransactionModel parentTransaction) {
        this.parentTransaction = parentTransaction;
    }

    public String getPaymentRefundable() {
        return this.paymentRefundable;
    }

    public void setPaymentRefundable(String paymentRefundable) {
        this.paymentRefundable = paymentRefundable;
    }

    public String getPaymentRefundRule() {
        return this.paymentRefundRule;
    }

    public void setPaymentRefundRule(String paymentRefundRule) {
        this.paymentRefundRule = paymentRefundRule;
    }

    public Date getRecognitionDate() {
        return this.recognitionDate;
    }

    public void setRecognitionDate(Date recognitionDate) {
        this.recognitionDate = recognitionDate;
    }

    public String getRollupDescription() {
        return this.rollupDescription;
    }

    public void setRollupDescription(String rollupDescription) {
        this.rollupDescription = rollupDescription;
    }

    public String getStatusString() {
        return this.statusString;
    }

    public void setStatusString(String statusString) {
        this.statusString = statusString;
    }

    public BigDecimal getAllocatedTotal() {
        return this.allocatedTotal;
    }

    public void setAllocatedTotal(BigDecimal allocatedTotal) {
        this.allocatedTotal = allocatedTotal;
    }

    public BigDecimal getChargeAmount() {
        return this.chargeAmount;
    }

    public void setChargeAmount(BigDecimal chargeAmount) {
        this.chargeAmount = chargeAmount;
    }

    public BigDecimal getAllocatedLockedAllocated() {
        return this.allocatedLockedAllocated;
    }

    public void setAllocatedLockedAllocated(BigDecimal allocatedLockedAllocated) {
        this.allocatedLockedAllocated = allocatedLockedAllocated;
    }

    public BigDecimal getDefermentAmount() {
        return this.defermentAmount;
    }

    public void setDefermentAmount(BigDecimal defermentAmount) {
        this.defermentAmount = defermentAmount;
    }

    public BigDecimal getPaymentAmount() {
        return this.paymentAmount;
    }

    public void setPaymentAmount(BigDecimal paymentAmount) {
        this.paymentAmount = paymentAmount;
    }

    public BigDecimal getUnallocatedAmount() {
        return this.unallocatedAmount;
    }

    public void setUnallocatedAmount(BigDecimal unallocatedAmount) {
        this.unallocatedAmount = unallocatedAmount;
    }

    public BigDecimal getChargeTotal() {
        return this.chargeTotal;
    }

    public void setChargeTotal(BigDecimal chargeTotal) {
        this.chargeTotal = chargeTotal;
    }

    public BigDecimal getDefermentTotal() {
        return this.defermentTotal;
    }

    public void setDefermentTotal(BigDecimal defermentTotal) {
        this.defermentTotal = defermentTotal;
    }

    public Date getEffectiveDate() {
        return this.effectiveDate;
    }

    public void setEffectiveDate(Date effectiveDate) {
        this.effectiveDate = effectiveDate;
    }

    public String getId() {
        return this.id;
    }

    public void setId(String id) {
        this.id = id;
    }

    public BigDecimal getPaymentTotal() {
        return this.paymentTotal;
    }

    public void setPaymentTotal(BigDecimal paymentTotal) {
        this.paymentTotal = paymentTotal;
    }

    public List<TransactionModel> getSubTransactions() {
        return this.subTransactions;
    }

    public void setSubTransactions(List<TransactionModel> subTransactions) {
        this.subTransactions = subTransactions;
    }

    public String getTagList() {
        return this.tagList;
    }

    public void setTagList(String tagList) {
        this.tagList = tagList;
    }

    public String getTransactionDisplayType() {
        return this.transactionDisplayType;
    }

    public void setTransactionDisplayType(String transactionDisplayType) {
        this.transactionDisplayType = transactionDisplayType;
    }

    public String getTransactionTypeDescription() {
        return this.transactionTypeDescription;
    }

    public void setTransactionTypeDescription(String transactionTypeDescription) {
        this.transactionTypeDescription = transactionTypeDescription;
    }

    public BigDecimal getUnallocatedTotal() {
        return this.unallocatedTotal;
    }

    public void setUnallocatedTotal(BigDecimal unallocatedTotal) {
        this.unallocatedTotal = unallocatedTotal;
    }

    public String getNewTag() {
        return this.newTag;
    }

    public void setNewTag(String newTag) {
        this.newTag = newTag;
    }

    public List<Tag> getTagModels() {
        return this.tagModels;
    }

    public void setTagModels(List<Tag> tagModels) {
        this.tagModels = tagModels;
    }
}

