/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.rice.krad.dao.impl;

import java.lang.reflect.Field;
import java.math.BigDecimal;
import java.sql.Date;
import java.sql.Timestamp;
import java.text.ParseException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import javax.persistence.EntityManager;
import javax.persistence.PersistenceContext;
import javax.persistence.PersistenceException;
import org.apache.commons.beanutils.PropertyUtils;
import org.apache.commons.lang.StringUtils;
import org.apache.log4j.Logger;
import org.kuali.rice.core.api.datetime.DateTimeService;
import org.kuali.rice.core.api.search.SearchOperator;
import org.kuali.rice.core.api.util.type.TypeUtils;
import org.kuali.rice.core.framework.persistence.jpa.criteria.Criteria;
import org.kuali.rice.core.framework.persistence.jpa.criteria.QueryByCriteria;
import org.kuali.rice.core.framework.persistence.jpa.metadata.EntityDescriptor;
import org.kuali.rice.core.framework.persistence.jpa.metadata.FieldDescriptor;
import org.kuali.rice.core.framework.persistence.jpa.metadata.MetadataManager;
import org.kuali.rice.core.framework.persistence.ojb.conversion.OjbCharBooleanConversion;
import org.kuali.rice.kns.lookup.LookupUtils;
import org.kuali.rice.kns.service.KNSServiceLocator;
import org.kuali.rice.krad.bo.InactivatableFromTo;
import org.kuali.rice.krad.bo.PersistableBusinessObject;
import org.kuali.rice.krad.bo.PersistableBusinessObjectExtension;
import org.kuali.rice.krad.dao.LookupDao;
import org.kuali.rice.krad.lookup.CollectionIncomplete;
import org.kuali.rice.krad.service.DataDictionaryService;
import org.kuali.rice.krad.service.KRADServiceLocator;
import org.kuali.rice.krad.service.KRADServiceLocatorWeb;
import org.kuali.rice.krad.service.PersistenceStructureService;
import org.kuali.rice.krad.util.GlobalVariables;
import org.kuali.rice.krad.util.ObjectUtils;
import org.springframework.dao.DataIntegrityViolationException;

public class LookupDaoJpa
implements LookupDao {
    private static final Logger LOG = Logger.getLogger(LookupDao.class);
    private DateTimeService dateTimeService;
    private PersistenceStructureService persistenceStructureService;
    private DataDictionaryService dataDictionaryService;
    @PersistenceContext
    private EntityManager entityManager;

    public Long findCountByMap(Object example, Map formProps) {
        Criteria criteria = new Criteria(example.getClass().getName());
        for (String propertyName : formProps.keySet()) {
            Class propertyType;
            String searchValue = (String)formProps.get(propertyName);
            if (StringUtils.isBlank((String)searchValue) || !PropertyUtils.isWriteable((Object)example, (String)propertyName) || (propertyType = ObjectUtils.getPropertyType((Object)example, (String)propertyName, (PersistenceStructureService)this.persistenceStructureService)) == null) continue;
            Boolean caseInsensitive = Boolean.TRUE;
            if (KRADServiceLocatorWeb.getDataDictionaryService().isAttributeDefined(example.getClass(), propertyName).booleanValue()) {
                caseInsensitive = KRADServiceLocatorWeb.getDataDictionaryService().getAttributeForceUppercase(example.getClass(), propertyName) == false;
            }
            if (caseInsensitive == null) {
                caseInsensitive = Boolean.TRUE;
            }
            boolean treatWildcardsAndOperatorsAsLiteral = KNSServiceLocator.getBusinessObjectDictionaryService().isLookupFieldTreatWildcardsAndOperatorsAsLiteral(example.getClass(), propertyName);
            if (!caseInsensitive.booleanValue()) {
                searchValue = searchValue.toUpperCase();
            }
            this.addCriteria(propertyName, searchValue, propertyType, caseInsensitive, treatWildcardsAndOperatorsAsLiteral, criteria);
        }
        return (Long)new QueryByCriteria(this.entityManager, criteria).toCountQuery().getSingleResult();
    }

    public Collection findCollectionBySearchHelper(Class businessObjectClass, Map formProps, boolean unbounded, boolean usePrimaryKeyValuesOnly) {
        Integer searchResultsLimit = LookupUtils.getSearchResultsLimit((Class)businessObjectClass);
        return this.findCollectionBySearchHelper(businessObjectClass, formProps, unbounded, usePrimaryKeyValuesOnly, searchResultsLimit);
    }

    public Collection findCollectionBySearchHelper(Class businessObjectClass, Map formProps, boolean unbounded, boolean usePrimaryKeyValuesOnly, Integer searchResultsLimit) {
        PersistableBusinessObject businessObject = this.checkBusinessObjectClass(businessObjectClass);
        if (usePrimaryKeyValuesOnly) {
            return this.executeSearch(businessObjectClass, this.getCollectionCriteriaFromMapUsingPrimaryKeysOnly(businessObjectClass, formProps), unbounded, searchResultsLimit);
        }
        Criteria crit = this.getCollectionCriteriaFromMap(businessObject, formProps);
        return this.executeSearch(businessObjectClass, crit, unbounded, searchResultsLimit);
    }

    public Criteria getCollectionCriteriaFromMap(PersistableBusinessObject example, Map formProps) {
        Criteria criteria = new Criteria(example.getClass().getName());
        for (String propertyName : formProps.keySet()) {
            Boolean caseInsensitive = Boolean.TRUE;
            if (KRADServiceLocatorWeb.getDataDictionaryService().isAttributeDefined(example.getClass(), propertyName).booleanValue()) {
                caseInsensitive = KRADServiceLocatorWeb.getDataDictionaryService().getAttributeForceUppercase(example.getClass(), propertyName) == false;
            }
            if (caseInsensitive == null) {
                caseInsensitive = Boolean.TRUE;
            }
            boolean treatWildcardsAndOperatorsAsLiteral = KNSServiceLocator.getBusinessObjectDictionaryService().isLookupFieldTreatWildcardsAndOperatorsAsLiteral(example.getClass(), propertyName);
            if (formProps.get(propertyName) instanceof Collection) {
                for (String searchValue : (Collection)formProps.get(propertyName)) {
                    if (!caseInsensitive.booleanValue()) {
                        searchValue = searchValue.toUpperCase();
                    }
                    if (this.createCriteria(example, searchValue, propertyName, caseInsensitive, treatWildcardsAndOperatorsAsLiteral, criteria, formProps)) continue;
                    throw new RuntimeException("Invalid value in Collection");
                }
                continue;
            }
            String searchValue = (String)formProps.get(propertyName);
            if (!caseInsensitive.booleanValue()) {
                searchValue = searchValue.toUpperCase();
            }
            if (this.createCriteria(example, searchValue, propertyName, caseInsensitive, treatWildcardsAndOperatorsAsLiteral, criteria, formProps)) continue;
        }
        return criteria;
    }

    public Criteria getCollectionCriteriaFromMapUsingPrimaryKeysOnly(Class businessObjectClass, Map formProps) {
        PersistableBusinessObject businessObject = this.checkBusinessObjectClass(businessObjectClass);
        Criteria criteria = new Criteria(businessObjectClass.getName());
        List pkFields = this.persistenceStructureService.listPrimaryKeyFieldNames(businessObjectClass);
        for (String pkFieldName : pkFields) {
            String pkValue = (String)formProps.get(pkFieldName);
            if (StringUtils.isBlank((String)pkValue)) {
                throw new RuntimeException("Missing pk value for field " + pkFieldName + " when a search based on PK values only is performed.");
            }
            for (SearchOperator op : SearchOperator.QUERY_CHARACTERS) {
                if (!pkValue.contains(op.op())) continue;
                throw new RuntimeException("Value \"" + pkValue + "\" for PK field " + pkFieldName + " contains wildcard/operator characters.");
            }
            boolean treatWildcardsAndOperatorsAsLiteral = KNSServiceLocator.getBusinessObjectDictionaryService().isLookupFieldTreatWildcardsAndOperatorsAsLiteral(businessObjectClass, pkFieldName);
            this.createCriteria(businessObject, pkValue, pkFieldName, false, treatWildcardsAndOperatorsAsLiteral, criteria);
        }
        return criteria;
    }

    private PersistableBusinessObject checkBusinessObjectClass(Class businessObjectClass) {
        if (businessObjectClass == null) {
            throw new IllegalArgumentException("BusinessObject class passed to LookupDao findCollectionBySearchHelper... method was null");
        }
        PersistableBusinessObject businessObject = null;
        try {
            businessObject = (PersistableBusinessObject)businessObjectClass.newInstance();
        }
        catch (IllegalAccessException e) {
            throw new RuntimeException("LookupDao could not get instance of " + businessObjectClass.getName(), e);
        }
        catch (InstantiationException e) {
            throw new RuntimeException("LookupDao could not get instance of " + businessObjectClass.getName(), e);
        }
        return businessObject;
    }

    private Collection executeSearch(Class businessObjectClass, Criteria criteria, boolean unbounded, Integer searchResultsLimit) {
        List searchResults = new ArrayList();
        Long matchingResultsCount = null;
        try {
            if (!unbounded && searchResultsLimit != null) {
                matchingResultsCount = (Long)new QueryByCriteria(this.entityManager, criteria).toCountQuery().getSingleResult();
                searchResults = new QueryByCriteria(this.entityManager, criteria).toQuery().setMaxResults(searchResultsLimit.intValue()).getResultList();
            } else {
                searchResults = new QueryByCriteria(this.entityManager, criteria).toQuery().getResultList();
            }
            if (matchingResultsCount == null || matchingResultsCount.intValue() <= searchResultsLimit) {
                matchingResultsCount = new Long(0L);
            }
            for (PersistableBusinessObject bo : searchResults) {
                if (bo.getExtension() == null) continue;
                PersistableBusinessObjectExtension boe = bo.getExtension();
                EntityDescriptor entity = MetadataManager.getEntityDescriptor(bo.getExtension().getClass());
                Criteria extensionCriteria = new Criteria(boe.getClass().getName());
                for (FieldDescriptor fieldDescriptor : entity.getPrimaryKeys()) {
                    try {
                        Field field = bo.getClass().getDeclaredField(fieldDescriptor.getName());
                        field.setAccessible(true);
                        extensionCriteria.eq(fieldDescriptor.getName(), field.get(bo));
                    }
                    catch (Exception e) {
                        LOG.error((Object)e.getMessage(), (Throwable)e);
                    }
                }
                try {
                    boe = (PersistableBusinessObjectExtension)new QueryByCriteria(this.entityManager, extensionCriteria).toQuery().getSingleResult();
                }
                catch (PersistenceException persistenceException) {
                    // empty catch block
                }
                bo.setExtension(boe);
            }
            ArrayList bos = new ArrayList();
            bos.addAll(searchResults);
            searchResults = bos;
        }
        catch (DataIntegrityViolationException e) {
            throw new RuntimeException("LookupDao encountered exception during executeSearch", e);
        }
        return new CollectionIncomplete(searchResults, matchingResultsCount);
    }

    private boolean isWriteable(Object o, String p) throws IllegalArgumentException {
        if (null == o || null == p) {
            throw new IllegalArgumentException("Cannot check writeable status with null arguments.");
        }
        boolean b = false;
        if (!PropertyUtils.isWriteable((Object)o, (String)p)) {
            if (-1 != p.indexOf(46)) {
                String[] parts = p.split("\\.");
                Class c = ObjectUtils.getPropertyType((Object)o, (String)parts[0], (PersistenceStructureService)this.persistenceStructureService);
                Object i = null;
                if (Collection.class.isAssignableFrom(c)) {
                    Map m = this.persistenceStructureService.listCollectionObjectTypes(o.getClass());
                    c = (Class)m.get(parts[0]);
                }
                try {
                    i = c.newInstance();
                    StringBuffer sb = new StringBuffer();
                    for (int x = 1; x < parts.length; ++x) {
                        sb.append(1 == x ? "" : ".").append(parts[x]);
                    }
                    b = this.isWriteable(i, sb.toString());
                }
                catch (InstantiationException ie) {
                    LOG.info((Object)ie);
                }
                catch (IllegalAccessException iae) {
                    LOG.info((Object)iae);
                }
            }
        } else {
            b = true;
        }
        return b;
    }

    @Override
    public boolean createCriteria(Object example, String searchValue, String propertyName, Object criteria) {
        return this.createCriteria(example, searchValue, propertyName, false, false, criteria);
    }

    @Override
    public boolean createCriteria(Object example, String searchValue, String propertyName, boolean caseInsensitive, boolean treatWildcardsAndOperatorsAsLiteral, Object criteria) {
        return this.createCriteria(example, searchValue, propertyName, caseInsensitive, treatWildcardsAndOperatorsAsLiteral, criteria, null);
    }

    public boolean createCriteria(Object example, String searchValue, String propertyName, boolean caseInsensitive, boolean treatWildcardsAndOperatorsAsLiteral, Object criteria, Map searchValues) {
        if (!(criteria instanceof Criteria) || StringUtils.isBlank((String)searchValue) || !this.isWriteable(example, propertyName)) {
            return false;
        }
        Class propertyType = ObjectUtils.getPropertyType((Object)example, (String)propertyName, (PersistenceStructureService)this.persistenceStructureService);
        if (propertyType == null) {
            return false;
        }
        if (example instanceof InactivatableFromTo) {
            if ("active".equals(propertyName)) {
                this.addInactivateableFromToActiveCriteria(example, searchValue, (Criteria)criteria, searchValues);
            } else if ("current".equals(propertyName)) {
                this.addInactivateableFromToCurrentCriteria(example, searchValue, (Criteria)criteria, searchValues);
            } else if (!"activeAsOfDate".equals(propertyName)) {
                this.addCriteria(propertyName, searchValue, propertyType, caseInsensitive, treatWildcardsAndOperatorsAsLiteral, (Criteria)criteria);
            }
        } else {
            this.addCriteria(propertyName, searchValue, propertyType, caseInsensitive, treatWildcardsAndOperatorsAsLiteral, (Criteria)criteria);
        }
        return true;
    }

    public Object findObjectByMap(Object example, Map formProps) {
        Criteria jpaCriteria = new Criteria(example.getClass().getName());
        for (String propertyName : formProps.keySet()) {
            String searchValue = "";
            if (formProps.get(propertyName) != null) {
                searchValue = formProps.get(propertyName).toString();
            }
            if (!(StringUtils.isNotBlank((String)searchValue) & PropertyUtils.isWriteable((Object)example, (String)propertyName))) continue;
            Class propertyType = ObjectUtils.getPropertyType((Object)example, (String)propertyName, (PersistenceStructureService)this.persistenceStructureService);
            if (TypeUtils.isIntegralClass((Class)propertyType) || TypeUtils.isDecimalClass((Class)propertyType)) {
                if (propertyType.equals(Long.class)) {
                    jpaCriteria.eq(propertyName, (Object)new Long(searchValue));
                    continue;
                }
                jpaCriteria.eq(propertyName, (Object)new Integer(searchValue));
                continue;
            }
            if (TypeUtils.isTemporalClass((Class)propertyType)) {
                jpaCriteria.eq(propertyName, (Object)this.parseDate(ObjectUtils.clean((String)searchValue)));
                continue;
            }
            jpaCriteria.eq(propertyName, (Object)searchValue);
        }
        return new QueryByCriteria(this.entityManager, jpaCriteria).toQuery().getSingleResult();
    }

    private void addCriteria(String propertyName, String propertyValue, Class propertyType, boolean caseInsensitive, boolean treatWildcardsAndOperatorsAsLiteral, Criteria criteria) {
        String alias = "";
        String[] keySplit = propertyName.split("\\.");
        if (keySplit.length > 1) {
            alias = keySplit[keySplit.length - 2];
            String variableKey = keySplit[keySplit.length - 1];
            for (int j = 0; j < keySplit.length - 1; ++j) {
                if (StringUtils.contains((String)keySplit[j], (String)"__JPA_ALIAS[[")) {
                    String tempKey = keySplit[j].substring(keySplit[j].indexOf(39, keySplit[j].indexOf("__JPA_ALIAS[[")) + 1, keySplit[j].lastIndexOf(39, keySplit[j].indexOf("]]__")));
                    if (criteria.getAliasIndex(tempKey) != -1) continue;
                    criteria.join(tempKey, tempKey, false, true);
                    continue;
                }
                if (criteria.getAliasIndex(keySplit[j]) != -1) continue;
                criteria.join(keySplit[j], keySplit[j], false, true);
            }
            if (!StringUtils.contains((String)propertyName, (String)"__JPA_ALIAS[[")) {
                propertyName = "__JPA_ALIAS[['" + alias + "']]__." + variableKey;
            }
        }
        if (!treatWildcardsAndOperatorsAsLiteral && StringUtils.contains((String)propertyValue, (String)SearchOperator.OR.op())) {
            this.addOrCriteria(propertyName, propertyValue, propertyType, caseInsensitive, criteria);
            return;
        }
        if (!treatWildcardsAndOperatorsAsLiteral && StringUtils.contains((String)propertyValue, (String)SearchOperator.AND.op())) {
            this.addAndCriteria(propertyName, propertyValue, propertyType, caseInsensitive, criteria);
            return;
        }
        if (StringUtils.containsIgnoreCase((String)propertyValue, (String)SearchOperator.NULL.op())) {
            if (StringUtils.contains((String)propertyValue, (String)SearchOperator.NOT.op())) {
                criteria.notNull(propertyName);
            } else {
                criteria.isNull(propertyName);
            }
        } else if (TypeUtils.isStringClass((Class)propertyType)) {
            if (caseInsensitive) {
                propertyName = StringUtils.contains((String)propertyName, (String)"__JPA_ALIAS[[") ? "UPPER(" + propertyName + ")" : "UPPER(__JPA_ALIAS[[0]]__." + propertyName + ")";
                propertyValue = propertyValue.toUpperCase();
            }
            if (!treatWildcardsAndOperatorsAsLiteral && StringUtils.contains((String)propertyValue, (String)SearchOperator.NOT.op())) {
                this.addNotCriteria(propertyName, propertyValue, propertyType, caseInsensitive, criteria);
            } else if (!treatWildcardsAndOperatorsAsLiteral && propertyValue != null && (StringUtils.contains((String)propertyValue, (String)SearchOperator.BETWEEN.op()) || propertyValue.startsWith(">") || propertyValue.startsWith("<"))) {
                this.addStringRangeCriteria(propertyName, propertyValue, criteria);
            } else {
                if (treatWildcardsAndOperatorsAsLiteral) {
                    propertyValue = StringUtils.replace((String)propertyValue, (String)"*", (String)"\\*");
                }
                criteria.like(propertyName, (Object)propertyValue);
            }
        } else if (TypeUtils.isIntegralClass((Class)propertyType) || TypeUtils.isDecimalClass((Class)propertyType)) {
            this.addNumericRangeCriteria(propertyName, propertyValue, criteria);
        } else if (TypeUtils.isTemporalClass((Class)propertyType)) {
            this.addDateRangeCriteria(propertyName, propertyValue, criteria);
        } else if (TypeUtils.isBooleanClass((Class)propertyType)) {
            String temp = ObjectUtils.clean((String)propertyValue);
            criteria.eq(propertyName, (Object)("Y".equalsIgnoreCase(temp) || "T".equalsIgnoreCase(temp) || "1".equalsIgnoreCase(temp) || "true".equalsIgnoreCase(temp) ? 1 : 0));
        } else {
            LOG.error((Object)("not adding criterion for: " + propertyName + "," + propertyType + "," + propertyValue));
        }
    }

    protected void addInactivateableFromToActiveCriteria(Object example, String activeSearchValue, Criteria criteria, Map searchValues) {
        Timestamp activeTimestamp = org.kuali.rice.krad.lookup.LookupUtils.getActiveDateTimestampForCriteria((Map)searchValues);
        String activeBooleanStr = (String)new OjbCharBooleanConversion().javaToSql((Object)activeSearchValue);
        if ("Y".equals(activeBooleanStr)) {
            Criteria criteriaBeginDate = new Criteria(example.getClass().getName());
            criteriaBeginDate.lte("activeFromDate", (Object)activeTimestamp);
            Criteria criteriaBeginDateNull = new Criteria(example.getClass().getName());
            criteriaBeginDateNull.isNull("activeFromDate");
            criteriaBeginDate.or(criteriaBeginDateNull);
            criteria.and(criteriaBeginDate);
            Criteria criteriaEndDate = new Criteria(example.getClass().getName());
            criteriaEndDate.gt("activeToDate", (Object)activeTimestamp);
            Criteria criteriaEndDateNull = new Criteria(example.getClass().getName());
            criteriaEndDateNull.isNull("activeToDate");
            criteriaEndDate.or(criteriaEndDateNull);
            criteria.and(criteriaEndDate);
        } else if ("N".equals(activeBooleanStr)) {
            Criteria criteriaNonActive = new Criteria(example.getClass().getName());
            criteriaNonActive.gt("activeFromDate", (Object)activeTimestamp);
            Criteria criteriaBeginDateNull = new Criteria(example.getClass().getName());
            criteriaBeginDateNull.isNull("activeFromDate");
            criteriaNonActive.or(criteriaBeginDateNull);
            Criteria criteriaEndDate = new Criteria(example.getClass().getName());
            criteriaEndDate.lte("activeToDate", (Object)activeTimestamp);
            criteriaNonActive.or(criteriaEndDate);
            criteria.and(criteriaNonActive);
        }
    }

    protected void addInactivateableFromToCurrentCriteria(Object example, String currentSearchValue, Criteria criteria, Map searchValues) {
        Timestamp activeTimestamp = org.kuali.rice.krad.lookup.LookupUtils.getActiveDateTimestampForCriteria((Map)searchValues);
        List groupByFieldList = this.dataDictionaryService.getGroupByAttributesForEffectiveDating(example.getClass());
        if (groupByFieldList == null) {
            return;
        }
        String alias = "c";
        String jpql = " (select max(" + alias + "." + "activeFromDate" + ") from " + example.getClass().getName() + " as " + alias + " where ";
        String activeDateDBStr = KRADServiceLocator.getDatabasePlatform().getDateSQL(this.dateTimeService.toDateTimeString((java.util.Date)activeTimestamp), null);
        jpql = jpql + alias + "." + "activeFromDate" + " <= '" + activeDateDBStr + "'";
        boolean firstGroupBy = true;
        String groupByJpql = "";
        for (String groupByField : groupByFieldList) {
            if (!firstGroupBy) {
                groupByJpql = groupByJpql + ", ";
            }
            jpql = jpql + " AND " + alias + "." + groupByField + " = " + criteria.getAlias() + "." + groupByField + " ";
            groupByJpql = groupByJpql + alias + "." + groupByField;
            firstGroupBy = false;
        }
        jpql = jpql + " group by " + groupByJpql + " )";
        String currentBooleanStr = (String)new OjbCharBooleanConversion().javaToSql((Object)currentSearchValue);
        if ("Y".equals(currentBooleanStr)) {
            jpql = criteria.getAlias() + "." + "activeFromDate" + " in " + jpql;
        } else if ("N".equals(currentBooleanStr)) {
            jpql = criteria.getAlias() + "." + "activeFromDate" + " not in " + jpql;
        }
        criteria.rawJpql(jpql);
    }

    private void addOrCriteria(String propertyName, String propertyValue, Class propertyType, boolean caseInsensitive, Criteria criteria) {
        this.addLogicalOperatorCriteria(propertyName, propertyValue, propertyType, caseInsensitive, criteria, SearchOperator.OR.op());
    }

    private void addAndCriteria(String propertyName, String propertyValue, Class propertyType, boolean caseInsensitive, Criteria criteria) {
        this.addLogicalOperatorCriteria(propertyName, propertyValue, propertyType, caseInsensitive, criteria, SearchOperator.AND.op());
    }

    private void addNotCriteria(String propertyName, String propertyValue, Class propertyType, boolean caseInsensitive, Criteria criteria) {
        Object[] splitPropVal = StringUtils.split((String)propertyValue, (String)SearchOperator.NOT.op());
        int strLength = splitPropVal.length;
        if (strLength > 1) {
            String expandedNot = "!" + StringUtils.join((Object[])splitPropVal, (String)(SearchOperator.AND.op() + SearchOperator.NOT.op()));
            this.addCriteria(propertyName, expandedNot, propertyType, caseInsensitive, false, criteria);
        } else {
            criteria.notLike(propertyName, (Object)splitPropVal[0]);
        }
    }

    private void addLogicalOperatorCriteria(String propertyName, String propertyValue, Class propertyType, boolean caseInsensitive, Criteria criteria, String splitValue) {
        String[] splitPropVal = StringUtils.split((String)propertyValue, (String)splitValue);
        Criteria subCriteria = new Criteria("N/A");
        for (int i = 0; i < splitPropVal.length; ++i) {
            Criteria predicate = new Criteria("N/A");
            this.addCriteria(propertyName, splitPropVal[i], propertyType, caseInsensitive, false, predicate);
            if (splitValue == SearchOperator.OR.op()) {
                subCriteria.or(predicate);
            }
            if (splitValue != SearchOperator.AND.op()) continue;
            subCriteria.and(predicate);
        }
        criteria.and(subCriteria);
    }

    private Date parseDate(String dateString) {
        dateString = dateString.trim();
        try {
            return this.dateTimeService.convertToSqlDate(dateString);
        }
        catch (ParseException ex) {
            return null;
        }
    }

    private void addDateRangeCriteria(String propertyName, String propertyValue, Criteria criteria) {
        if (StringUtils.contains((String)propertyValue, (String)SearchOperator.BETWEEN.op())) {
            String[] rangeValues = StringUtils.split((String)propertyValue, (String)SearchOperator.BETWEEN.op());
            criteria.between(propertyName, (Object)this.parseDate(ObjectUtils.clean((String)rangeValues[0])), (Object)this.parseDate(ObjectUtils.clean((String)rangeValues[1])));
        } else if (propertyValue.startsWith(">=")) {
            criteria.gte(propertyName, (Object)this.parseDate(ObjectUtils.clean((String)propertyValue)));
        } else if (propertyValue.startsWith("<=")) {
            criteria.lte(propertyName, (Object)this.parseDate(ObjectUtils.clean((String)propertyValue)));
        } else if (propertyValue.startsWith(">")) {
            criteria.gt(propertyName, (Object)this.parseDate(ObjectUtils.clean((String)propertyValue)));
        } else if (propertyValue.startsWith("<")) {
            criteria.lt(propertyName, (Object)this.parseDate(ObjectUtils.clean((String)propertyValue)));
        } else {
            criteria.eq(propertyName, (Object)this.parseDate(ObjectUtils.clean((String)propertyValue)));
        }
    }

    private BigDecimal cleanNumeric(String value) {
        String cleanedValue = value.replaceAll("[^-0-9.]", "");
        if (cleanedValue.lastIndexOf(45) > 0) {
            cleanedValue = cleanedValue.charAt(0) == '-' ? "-" + cleanedValue.replaceAll("-", "") : cleanedValue.replaceAll("-", "");
        }
        int decimalLoc = cleanedValue.lastIndexOf(46);
        if (cleanedValue.indexOf(46) != decimalLoc) {
            cleanedValue = cleanedValue.substring(0, decimalLoc).replaceAll("\\.", "") + cleanedValue.substring(decimalLoc);
        }
        try {
            return new BigDecimal(cleanedValue);
        }
        catch (NumberFormatException ex) {
            GlobalVariables.getMessageMap().putError("document.document*,document.explanation*,document.reversal*,document.selected*,document.header*", "error.custom", new String[]{"Invalid Numeric Input: " + value});
            return null;
        }
    }

    private void addNumericRangeCriteria(String propertyName, String propertyValue, Criteria criteria) {
        if (StringUtils.contains((String)propertyValue, (String)SearchOperator.BETWEEN.op())) {
            String[] rangeValues = StringUtils.split((String)propertyValue, (String)SearchOperator.BETWEEN.op());
            criteria.between(propertyName, (Object)this.cleanNumeric(rangeValues[0]), (Object)this.cleanNumeric(rangeValues[1]));
        } else if (propertyValue.startsWith(">=")) {
            criteria.gte(propertyName, (Object)this.cleanNumeric(propertyValue));
        } else if (propertyValue.startsWith("<=")) {
            criteria.lte(propertyName, (Object)this.cleanNumeric(propertyValue));
        } else if (propertyValue.startsWith(">")) {
            criteria.gt(propertyName, (Object)this.cleanNumeric(propertyValue));
        } else if (propertyValue.startsWith("<")) {
            criteria.lt(propertyName, (Object)this.cleanNumeric(propertyValue));
        } else {
            criteria.eq(propertyName, (Object)this.cleanNumeric(propertyValue));
        }
    }

    private void addStringRangeCriteria(String propertyName, String propertyValue, Criteria criteria) {
        if (StringUtils.contains((String)propertyValue, (String)SearchOperator.BETWEEN.op())) {
            String[] rangeValues = StringUtils.split((String)propertyValue, (String)SearchOperator.BETWEEN.op());
            criteria.between(propertyName, (Object)rangeValues[0], (Object)rangeValues[1]);
        } else if (propertyValue.startsWith(">=")) {
            criteria.gte(propertyName, (Object)ObjectUtils.clean((String)propertyValue));
        } else if (propertyValue.startsWith("<=")) {
            criteria.lte(propertyName, (Object)ObjectUtils.clean((String)propertyValue));
        } else if (propertyValue.startsWith(">")) {
            criteria.gt(propertyName, (Object)ObjectUtils.clean((String)propertyValue));
        } else if (propertyValue.startsWith("<")) {
            criteria.lt(propertyName, (Object)ObjectUtils.clean((String)propertyValue));
        }
    }

    public void setDateTimeService(DateTimeService dateTimeService) {
        this.dateTimeService = dateTimeService;
    }

    public EntityManager getEntityManager() {
        return this.entityManager;
    }

    public void setEntityManager(EntityManager entityManager) {
        this.entityManager = entityManager;
    }

    public void setPersistenceStructureService(PersistenceStructureService persistenceStructureService) {
        this.persistenceStructureService = persistenceStructureService;
    }

    public void setDataDictionaryService(DataDictionaryService dataDictionaryService) {
        this.dataDictionaryService = dataDictionaryService;
    }
}

