/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.rice.krad.dao.proxy;

import java.util.HashMap;
import javax.persistence.EntityManager;
import org.apache.commons.lang.StringUtils;
import org.apache.ojb.broker.core.proxy.ProxyHelper;
import org.hibernate.proxy.HibernateProxy;
import org.kuali.rice.core.framework.persistence.jpa.OrmUtils;
import org.kuali.rice.krad.bo.ModuleConfiguration;
import org.kuali.rice.krad.dao.PersistenceDao;
import org.kuali.rice.krad.dao.impl.PersistenceDaoOjb;
import org.kuali.rice.krad.service.KRADServiceLocatorWeb;
import org.kuali.rice.krad.service.KualiModuleService;
import org.kuali.rice.krad.service.ModuleService;
import org.kuali.rice.krad.util.ObjectUtils;
import org.springframework.transaction.annotation.Transactional;

@Transactional
public class PersistenceDaoProxy
implements PersistenceDao {
    private PersistenceDao persistenceDaoJpa;
    private PersistenceDao persistenceDaoOjb;
    private static KualiModuleService kualiModuleService;
    private static HashMap<String, PersistenceDao> persistenceDaoValues;

    public void setPersistenceDaoJpa(PersistenceDao persistenceDaoJpa) {
        this.persistenceDaoJpa = persistenceDaoJpa;
    }

    public void setPersistenceDaoOjb(PersistenceDao persistenceDaoOjb) {
        this.persistenceDaoOjb = persistenceDaoOjb;
    }

    private PersistenceDao getDao(Class clazz) {
        ModuleService moduleService = PersistenceDaoProxy.getKualiModuleService().getResponsibleModuleService(clazz);
        if (moduleService != null) {
            ModuleConfiguration moduleConfig = moduleService.getModuleConfiguration();
            String dataSourceName = "";
            EntityManager entityManager = null;
            if (moduleConfig != null) {
                dataSourceName = moduleConfig.getDataSourceName();
                entityManager = moduleConfig.getEntityManager();
            }
            if (StringUtils.isNotEmpty((String)dataSourceName)) {
                if (persistenceDaoValues.get(dataSourceName) != null) {
                    return persistenceDaoValues.get(dataSourceName);
                }
                if (OrmUtils.isJpaAnnotated((Class)clazz) && (OrmUtils.isJpaEnabled() || OrmUtils.isJpaEnabled((String)"rice.krad"))) {
                    persistenceDaoValues.put(dataSourceName, this.persistenceDaoJpa);
                    return this.persistenceDaoJpa;
                }
                PersistenceDaoOjb persistDaoOjb = new PersistenceDaoOjb();
                persistDaoOjb.setJcdAlias(dataSourceName);
                persistenceDaoValues.put(dataSourceName, persistDaoOjb);
                return persistDaoOjb;
            }
        }
        return OrmUtils.isJpaAnnotated((Class)clazz) && (OrmUtils.isJpaEnabled() || OrmUtils.isJpaEnabled((String)"rice.krad")) ? this.persistenceDaoJpa : this.persistenceDaoOjb;
    }

    @Override
    public void clearCache() {
        this.persistenceDaoJpa.clearCache();
        this.persistenceDaoOjb.clearCache();
    }

    @Override
    public Object resolveProxy(Object o) {
        return this.getDao(ObjectUtils.materializeClassForProxiedObject((Object)o)).resolveProxy(o);
    }

    @Override
    public void retrieveAllReferences(Object o) {
        this.getDao(ObjectUtils.materializeClassForProxiedObject((Object)o)).retrieveAllReferences(o);
    }

    @Override
    public void retrieveReference(Object o, String referenceName) {
        this.getDao(ObjectUtils.materializeClassForProxiedObject((Object)o)).retrieveReference(o, referenceName);
    }

    @Override
    public boolean isProxied(Object object) {
        if (object instanceof HibernateProxy) {
            return true;
        }
        return ProxyHelper.isProxy((Object)object);
    }

    private static KualiModuleService getKualiModuleService() {
        if (kualiModuleService == null) {
            kualiModuleService = KRADServiceLocatorWeb.getKualiModuleService();
        }
        return kualiModuleService;
    }

    static {
        persistenceDaoValues = new HashMap();
    }
}

