/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.rice.krad.service.impl;

import org.apache.commons.lang.StringUtils;
import org.apache.log4j.Logger;
import org.kuali.rice.krad.bo.DocumentHeader;
import org.kuali.rice.krad.bo.PersistableBusinessObject;
import org.kuali.rice.krad.dao.DocumentHeaderDao;
import org.kuali.rice.krad.service.DocumentHeaderService;
import org.kuali.rice.krad.service.KRADServiceLocator;
import org.springframework.transaction.annotation.Transactional;

@Transactional
public class DocumentHeaderServiceImpl
implements DocumentHeaderService {
    private static Logger LOG = Logger.getLogger(DocumentHeaderServiceImpl.class);
    private DocumentHeaderDao documentHeaderDao;

    public Class<? extends DocumentHeader> getDocumentHeaderBaseClass() {
        Class documentHeaderClass = this.documentHeaderDao.getDocumentHeaderBaseClass();
        if (documentHeaderClass == null || !DocumentHeader.class.isAssignableFrom(documentHeaderClass)) {
            throw new RuntimeException("invalid document header base class '" + documentHeaderClass + "' returned by dao '" + this.documentHeaderDao.getClass().getName() + "'");
        }
        return documentHeaderClass;
    }

    public DocumentHeader getDocumentHeaderById(String documentHeaderId) {
        if (StringUtils.isBlank((String)documentHeaderId)) {
            throw new IllegalArgumentException("document header id given is blank");
        }
        return this.documentHeaderDao.getByDocumentHeaderId(documentHeaderId);
    }

    public void saveDocumentHeader(DocumentHeader documentHeader) {
        KRADServiceLocator.getBusinessObjectService().save((PersistableBusinessObject)documentHeader);
    }

    public void deleteDocumentHeader(DocumentHeader documentHeader) {
        KRADServiceLocator.getBusinessObjectService().delete((PersistableBusinessObject)documentHeader);
    }

    public void setDocumentHeaderDao(DocumentHeaderDao documentHeaderDao) {
        this.documentHeaderDao = documentHeaderDao;
    }
}

