/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.rice.krad.service.impl;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.kuali.rice.core.api.criteria.Predicate;
import org.kuali.rice.core.api.criteria.PredicateFactory;
import org.kuali.rice.core.api.search.SearchOperator;

class PredicateFactoryLookup {
    private static final Pattern FLAGS_PATTERN = Pattern.compile("^\\(\\?[a-z]+\\)");

    private PredicateFactoryLookup() {
        throw new IllegalArgumentException("do not call");
    }

    static Predicate fromCriteriaMap(Class<?> clazz, Map<String, ?> criteria) {
        if (clazz == null) {
            throw new IllegalArgumentException("clazz is null");
        }
        if (criteria == null || criteria.isEmpty()) {
            throw new IllegalArgumentException("criteria is null or empty");
        }
        ArrayList<Predicate> toAnd = new ArrayList<Predicate>();
        for (Map.Entry<String, ?> entry : criteria.entrySet()) {
            String key = entry.getKey();
            if (key == null) {
                throw new IllegalArgumentException("criteria contains a null key");
            }
            toAnd.add(PredicateFactoryLookup.createPredicate(clazz, key, entry.getValue()));
        }
        return PredicateFactory.and((Predicate[])toAnd.toArray(new Predicate[0]));
    }

    private static Predicate createPredicate(Class<?> clazz, String key, Object value) {
        if (value == null) {
            return PredicateFactory.isNull((String)key);
        }
        if (value instanceof String) {
            String flagStr = PredicateFactoryLookup.getFlagsStr((String)value);
            String strValue = PredicateFactoryLookup.removeFlag((String)value, flagStr);
            return PredicateFactoryLookup.containsOperator(strValue) ? PredicateFactoryLookup.createFromComplexCriteriaValue(clazz, key, strValue, flagStr) : PredicateFactoryLookup.createFromSimpleCriteriaValue(clazz, key, strValue, flagStr);
        }
        if (value instanceof Collection) {
            ArrayList<Predicate> ps = new ArrayList<Predicate>();
            for (Object v : (Collection)value) {
                ps.add(PredicateFactoryLookup.createPredicate(clazz, key, v));
            }
            return PredicateFactory.and((Predicate[])ps.toArray(new Predicate[0]));
        }
        throw new IllegalArgumentException("criteria map contained a value that was non supported :" + value.getClass().getName());
    }

    private static Predicate createFromComplexCriteriaValue(Class<?> clazz, String key, String strValue, String flagStr) {
        boolean caseInsensitive = PredicateFactoryLookup.isCaseInsensitive(flagStr);
        return null;
    }

    private static Predicate createFromSimpleCriteriaValue(Class<?> clazz, String key, String strValue, String flagStr) {
        boolean caseInsensitive = PredicateFactoryLookup.isCaseInsensitive(flagStr);
        return caseInsensitive ? PredicateFactory.equalIgnoreCase((String)key, (CharSequence)strValue) : PredicateFactory.equal((String)key, (Object)strValue);
    }

    private static String removeFlag(String strValue, String flagStr) {
        return flagStr.length() > 1 ? strValue.substring(flagStr.length() - 1) : strValue;
    }

    private static boolean containsOperator(String value) {
        for (SearchOperator o : SearchOperator.values()) {
            if (!value.contains(o.op())) continue;
            return true;
        }
        return false;
    }

    private static String getFlagsStr(String criteria) {
        Matcher m = FLAGS_PATTERN.matcher(criteria);
        if (m.find()) {
            return m.group();
        }
        return "";
    }

    private static boolean isCaseInsensitive(String flagStr) {
        return flagStr.contains("i");
    }
}

