/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.rice.krad.service.impl;

import java.sql.Date;
import java.sql.Timestamp;
import java.text.ParseException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.beanutils.PropertyUtils;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.lang.Validate;
import org.apache.log4j.Logger;
import org.kuali.rice.core.api.criteria.Predicate;
import org.kuali.rice.core.api.criteria.PredicateFactory;
import org.kuali.rice.core.api.criteria.QueryByCriteria;
import org.kuali.rice.core.api.datetime.DateTimeService;
import org.kuali.rice.core.api.search.SearchOperator;
import org.kuali.rice.core.api.util.type.TypeUtils;
import org.kuali.rice.core.framework.persistence.ojb.conversion.OjbCharBooleanConversion;
import org.kuali.rice.core.framework.persistence.platform.DatabasePlatform;
import org.kuali.rice.krad.bo.InactivatableFromTo;
import org.kuali.rice.krad.data.DataObjectService;
import org.kuali.rice.krad.lookup.LookupInputField;
import org.kuali.rice.krad.lookup.LookupUtils;
import org.kuali.rice.krad.lookup.LookupView;
import org.kuali.rice.krad.service.DataDictionaryService;
import org.kuali.rice.krad.service.impl.LookupCriteriaGenerator;
import org.kuali.rice.krad.uif.UifConstants;
import org.kuali.rice.krad.uif.component.Component;
import org.kuali.rice.krad.uif.view.View;
import org.kuali.rice.krad.util.GlobalVariables;
import org.kuali.rice.krad.util.KRADUtils;

public class LookupCriteriaGeneratorImpl
implements LookupCriteriaGenerator {
    private static final Logger LOG = Logger.getLogger(LookupCriteriaGeneratorImpl.class);
    private DateTimeService dateTimeService;
    private DataDictionaryService dataDictionaryService;
    private DatabasePlatform dbPlatform;
    private DataObjectService dataObjectService;

    public DateTimeService getDateTimeService() {
        return this.dateTimeService;
    }

    public void setDateTimeService(DateTimeService dateTimeService) {
        this.dateTimeService = dateTimeService;
    }

    public DataDictionaryService getDataDictionaryService() {
        return this.dataDictionaryService;
    }

    public void setDataDictionaryService(DataDictionaryService dataDictionaryService) {
        this.dataDictionaryService = dataDictionaryService;
    }

    public DatabasePlatform getDbPlatform() {
        return this.dbPlatform;
    }

    public void setDbPlatform(DatabasePlatform dbPlatform) {
        this.dbPlatform = dbPlatform;
    }

    public DataObjectService getDataObjectService() {
        return this.dataObjectService;
    }

    public void setDataObjectService(DataObjectService dataObjectService) {
        this.dataObjectService = dataObjectService;
    }

    @Deprecated
    public QueryByCriteria.Builder generateCriteria(Class<?> type, Map<String, String> formProps, boolean usePrimaryKeysOnly) {
        if (usePrimaryKeysOnly) {
            return this.getCollectionCriteriaFromMapUsingPrimaryKeysOnly(type, this.instantiateLookupDataObject(type), formProps).toQueryBuilder();
        }
        return this.getCollectionCriteriaFromMap(type, this.instantiateLookupDataObject(type), formProps).toQueryBuilder();
    }

    public QueryByCriteria.Builder generateCriteria(Class<?> type, Map<String, String> formProps, List<String> wildcardAsLiteralPropertyNames, boolean usePrimaryKeysOnly) {
        if (usePrimaryKeysOnly) {
            return this.getCollectionCriteriaFromMapUsingPrimaryKeysOnly(type, this.instantiateLookupDataObject(type), formProps, wildcardAsLiteralPropertyNames).toQueryBuilder();
        }
        return this.getCollectionCriteriaFromMap(type, this.instantiateLookupDataObject(type), formProps, wildcardAsLiteralPropertyNames).toQueryBuilder();
    }

    public QueryByCriteria.Builder createObjectCriteriaFromMap(Object example, Map<String, String> formProps) {
        Predicates criteria = new Predicates();
        for (Map.Entry<String, String> formProp : formProps.entrySet()) {
            String propertyName = formProp.getKey();
            String searchValue = "";
            if (formProp.getValue() != null) {
                searchValue = formProp.getValue();
            }
            Object instanObject = this.instantiateLookupDataObject((Class)example);
            if (!(StringUtils.isNotBlank((String)searchValue) & PropertyUtils.isWriteable((Object)instanObject, (String)propertyName))) continue;
            Class<?> propertyType = this.getPropertyType(instanObject, propertyName);
            if (TypeUtils.isIntegralClass(propertyType) || TypeUtils.isDecimalClass(propertyType)) {
                this.addEqualNumeric(criteria, propertyName, propertyType, searchValue);
                continue;
            }
            if (TypeUtils.isTemporalClass(propertyType)) {
                this.addEqualTemporal(criteria, propertyName, searchValue);
                continue;
            }
            this.addEqual(criteria, propertyName, searchValue);
        }
        return criteria.toQueryBuilder();
    }

    protected Object instantiateLookupDataObject(Class<?> type) {
        Validate.notNull(type, (String)"DataObject type passed to lookup was null");
        try {
            return type.newInstance();
        }
        catch (IllegalAccessException e) {
            throw new RuntimeException("Could not create instance of " + type, e);
        }
        catch (InstantiationException e) {
            throw new RuntimeException("Could not create instance of " + type, e);
        }
    }

    protected boolean createCriteria(Object example, String searchValue, String propertyName, Predicates criteria) {
        return this.createCriteria(example, searchValue, propertyName, false, false, criteria);
    }

    public boolean createCriteria(Object example, String searchValue, String propertyName, boolean caseInsensitive, boolean treatWildcardsAndOperatorsAsLiteral, Predicates criteria) {
        return this.createCriteria(example, searchValue, propertyName, caseInsensitive, treatWildcardsAndOperatorsAsLiteral, criteria, null);
    }

    @Deprecated
    protected boolean createCriteria(Object example, String searchValue, String propertyName, boolean caseInsensitive, boolean treatWildcardsAndOperatorsAsLiteral, Predicates criteria, Map<String, String> searchValues) {
        if (StringUtils.isBlank((String)searchValue) || !this.isWriteable(example, propertyName)) {
            return false;
        }
        Class<Object> propertyType = this.getPropertyType(example, propertyName);
        if (propertyType == null) {
            propertyType = String.class;
        }
        if (example instanceof InactivatableFromTo) {
            if ("active".equals(propertyName)) {
                this.addInactivateableFromToActiveCriteria(example, searchValue, criteria, searchValues);
            } else if ("current".equals(propertyName)) {
                this.addInactivateableFromToCurrentCriteria(example, searchValue, criteria, searchValues);
            } else if (!"activeAsOfDate".equals(propertyName)) {
                this.addCriteria(propertyName, searchValue, propertyType, caseInsensitive, treatWildcardsAndOperatorsAsLiteral, criteria);
            }
        } else {
            this.addCriteria(propertyName, searchValue, propertyType, caseInsensitive, treatWildcardsAndOperatorsAsLiteral, criteria);
        }
        return true;
    }

    @Deprecated
    protected Predicates getCollectionCriteriaFromMap(Class<?> type, Object example, Map<String, String> formProps) {
        Predicates criteria = new Predicates();
        for (String propertyName : formProps.keySet()) {
            boolean caseInsensitive = this.determineIfAttributeSearchShouldBeCaseInsensitive(type, propertyName);
            boolean treatWildcardsAndOperatorsAsLiteral = this.doesLookupFieldTreatWildcardsAndOperatorsAsLiteral(type, propertyName);
            String searchValue = formProps.get(propertyName);
            this.addCriteriaForPropertyValues(example, propertyName, caseInsensitive, treatWildcardsAndOperatorsAsLiteral, criteria, formProps, searchValue);
        }
        return criteria;
    }

    protected Predicates getCollectionCriteriaFromMap(Class<?> type, Object example, Map<String, String> formProps, List<String> wildcardAsLiteralPropertyNames) {
        Predicates criteria = new Predicates();
        for (String propertyName : formProps.keySet()) {
            boolean caseInsensitive = this.determineIfAttributeSearchShouldBeCaseInsensitive(type, propertyName);
            boolean treatWildcardsAndOperatorsAsLiteral = wildcardAsLiteralPropertyNames.contains(propertyName);
            String searchValue = formProps.get(propertyName);
            this.addCriteriaForPropertyValues(example, propertyName, caseInsensitive, treatWildcardsAndOperatorsAsLiteral, criteria, formProps, searchValue);
        }
        return criteria;
    }

    protected boolean determineIfAttributeSearchShouldBeCaseInsensitive(Class<?> type, String propertyName) {
        Boolean caseInsensitive = Boolean.TRUE;
        if (this.dataDictionaryService.isAttributeDefined(type, propertyName).booleanValue()) {
            caseInsensitive = this.dataDictionaryService.getAttributeForceUppercase(type, propertyName) == false;
        }
        if (caseInsensitive == null) {
            caseInsensitive = Boolean.TRUE;
        }
        return caseInsensitive;
    }

    protected boolean addCriteriaForPropertyValues(Object example, String propertyName, boolean caseInsensitive, boolean treatWildcardsAndOperatorsAsLiteral, Predicates criteria, Map formProps, String ... searchValues) {
        for (String searchValue : searchValues) {
            if (this.createCriteria(example, searchValue, propertyName, caseInsensitive, treatWildcardsAndOperatorsAsLiteral, criteria, formProps)) continue;
            return false;
        }
        return true;
    }

    @Deprecated
    protected Predicates getCollectionCriteriaFromMapUsingPrimaryKeysOnly(Class<?> type, Object dataObject, Map<String, String> formProps) {
        Predicates criteria = new Predicates();
        List<String> pkFields = this.listPrimaryKeyFieldNames(type);
        for (String pkFieldName : pkFields) {
            String pkValue = formProps.get(pkFieldName);
            if (StringUtils.isBlank((String)pkValue)) {
                throw new RuntimeException("Missing pk value for field " + pkFieldName + " when a search based on PK values only is performed.");
            }
            for (SearchOperator op : SearchOperator.QUERY_CHARACTERS) {
                if (!pkValue.contains(op.op())) continue;
                throw new RuntimeException("Value \"" + pkValue + "\" for PK field " + pkFieldName + " contains wildcard/operator characters.");
            }
            boolean treatWildcardsAndOperatorsAsLiteral = this.doesLookupFieldTreatWildcardsAndOperatorsAsLiteral(type, pkFieldName);
            this.createCriteria(dataObject, pkValue, pkFieldName, false, treatWildcardsAndOperatorsAsLiteral, criteria);
        }
        return criteria;
    }

    protected Predicates getCollectionCriteriaFromMapUsingPrimaryKeysOnly(Class<?> type, Object dataObject, Map<String, String> formProps, List<String> wildcardAsLiteralPropertyNames) {
        Predicates criteria = new Predicates();
        List<String> pkFields = this.listPrimaryKeyFieldNames(type);
        for (String pkFieldName : pkFields) {
            String pkValue = formProps.get(pkFieldName);
            if (StringUtils.isBlank((String)pkValue)) {
                throw new RuntimeException("Missing pk value for field " + pkFieldName + " when a search based on PK values only is performed.");
            }
            for (SearchOperator op : SearchOperator.QUERY_CHARACTERS) {
                if (!pkValue.contains(op.op())) continue;
                throw new RuntimeException("Value \"" + pkValue + "\" for PK field " + pkFieldName + " contains wildcard/operator characters.");
            }
            boolean treatWildcardsAndOperatorsAsLiteral = wildcardAsLiteralPropertyNames.contains(pkFieldName);
            this.createCriteria(dataObject, pkValue, pkFieldName, false, treatWildcardsAndOperatorsAsLiteral, criteria);
        }
        return criteria;
    }

    @Deprecated
    protected boolean doesLookupFieldTreatWildcardsAndOperatorsAsLiteral(Class<?> type, String fieldName) {
        HashMap<String, String> indexKey = new HashMap<String, String>();
        indexKey.put("viewName", "default");
        indexKey.put("dataObjectClassName", type.getName());
        View view = this.getDataDictionaryService().getDataDictionary().getViewByTypeIndex(UifConstants.ViewType.LOOKUP, indexKey);
        if (view != null && view instanceof LookupView) {
            LookupView lookupView = (LookupView)view;
            List criteriaFields = lookupView.getCriteriaFields();
            for (Component criteriaField : criteriaFields) {
                LookupInputField lookupInputField;
                if (!(criteriaField instanceof LookupInputField) || !fieldName.equals((lookupInputField = (LookupInputField)criteriaField).getPropertyName())) continue;
                return lookupInputField.isDisableWildcardsAndOperators();
            }
        }
        return false;
    }

    protected Number cleanNumeric(String value, Class<?> propertyType) {
        Object rv;
        String cleanedValue = value.replaceAll("[^-0-9.]", "");
        if (cleanedValue.lastIndexOf(45) > 0) {
            cleanedValue = cleanedValue.charAt(0) == '-' ? "-" + cleanedValue.replaceAll("-", "") : cleanedValue.replaceAll("-", "");
        }
        int decimalLoc = cleanedValue.lastIndexOf(46);
        if (cleanedValue.indexOf(46) != decimalLoc) {
            cleanedValue = cleanedValue.substring(0, decimalLoc).replaceAll("\\.", "") + cleanedValue.substring(decimalLoc);
        }
        if (!((rv = KRADUtils.hydrateAttributeValue(propertyType, (String)cleanedValue)) instanceof Number)) {
            throw new NumberFormatException("Value: " + cleanedValue + " cannot be converted into number type");
        }
        return (Number)rv;
    }

    protected void addOrCriteria(String propertyName, String propertyValue, Class propertyType, boolean caseInsensitive, Predicates criteria) {
        this.addLogicalOperatorCriteria(propertyName, propertyValue, propertyType, caseInsensitive, criteria, SearchOperator.OR.op());
    }

    protected void addAndCriteria(String propertyName, String propertyValue, Class propertyType, boolean caseInsensitive, Predicates criteria) {
        this.addLogicalOperatorCriteria(propertyName, propertyValue, propertyType, caseInsensitive, criteria, SearchOperator.AND.op());
    }

    protected void addCriteria(String propertyName, String propertyValue, Class<?> propertyType, boolean caseInsensitive, boolean treatWildcardsAndOperatorsAsLiteral, Predicates criteria) {
        propertyName = this.parsePropertyName(criteria, propertyName);
        if (!treatWildcardsAndOperatorsAsLiteral && StringUtils.contains((String)propertyValue, (String)SearchOperator.OR.op())) {
            this.addOrCriteria(propertyName, propertyValue, propertyType, caseInsensitive, criteria);
            return;
        }
        if (!treatWildcardsAndOperatorsAsLiteral && StringUtils.contains((String)propertyValue, (String)SearchOperator.AND.op())) {
            this.addAndCriteria(propertyName, propertyValue, propertyType, caseInsensitive, criteria);
            return;
        }
        if (StringUtils.equalsIgnoreCase((String)propertyValue, (String)SearchOperator.NULL.op()) || StringUtils.equalsIgnoreCase((String)propertyValue, (String)SearchOperator.NOT_NULL.op())) {
            if (StringUtils.contains((String)propertyValue, (String)SearchOperator.NOT.op())) {
                this.addIsNotNull(criteria, propertyName);
            } else {
                this.addIsNull(criteria, propertyName);
            }
        } else if (TypeUtils.isStringClass(propertyType)) {
            if (!treatWildcardsAndOperatorsAsLiteral && StringUtils.contains((String)propertyValue, (String)SearchOperator.NOT.op())) {
                this.addNotCriteria(propertyName, propertyValue, propertyType, caseInsensitive, criteria);
            } else if (!treatWildcardsAndOperatorsAsLiteral && propertyValue != null && (StringUtils.contains((String)propertyValue, (String)SearchOperator.BETWEEN.op()) || propertyValue.startsWith(">") || propertyValue.startsWith("<"))) {
                this.addStringRangeCriteria(propertyName, propertyValue, caseInsensitive, criteria);
            } else {
                if (treatWildcardsAndOperatorsAsLiteral) {
                    propertyValue = StringUtils.replace((String)propertyValue, (String)"*", (String)"\\*");
                    propertyValue = StringUtils.replace((String)propertyValue, (String)"%", (String)"\\%");
                    propertyValue = StringUtils.replace((String)propertyValue, (String)"?", (String)"\\?");
                    propertyValue = StringUtils.replace((String)propertyValue, (String)"_", (String)"\\_");
                }
                this.addLike(criteria, propertyName, propertyValue, caseInsensitive);
            }
        } else if (TypeUtils.isIntegralClass(propertyType) || TypeUtils.isDecimalClass(propertyType)) {
            this.addNumericRangeCriteria(propertyName, propertyValue, propertyType, treatWildcardsAndOperatorsAsLiteral, criteria);
        } else if (TypeUtils.isTemporalClass(propertyType)) {
            this.addDateRangeCriteria(propertyName, propertyValue, treatWildcardsAndOperatorsAsLiteral, criteria);
        } else if (TypeUtils.isBooleanClass(propertyType)) {
            this.addEqualToBoolean(criteria, propertyName, propertyValue);
        } else {
            LOG.error((Object)("not adding criterion for: " + propertyName + "," + propertyType + "," + propertyValue));
        }
    }

    protected void addNotCriteria(String propertyName, String propertyValue, Class propertyType, boolean caseInsensitive, Predicates criteria) {
        Object[] splitPropVal = StringUtils.split((String)propertyValue, (String)SearchOperator.NOT.op());
        try {
            int strLength = splitPropVal.length;
            if (strLength == 0) {
                throw new IllegalArgumentException("Improper syntax of NOT operator in " + propertyName);
            }
            if (strLength > 1) {
                String expandedNot = SearchOperator.NOT + StringUtils.join((Object[])splitPropVal, (String)(SearchOperator.AND.op() + SearchOperator.NOT.op()));
                this.addCriteria(propertyName, expandedNot, propertyType, caseInsensitive, false, criteria);
            } else {
                this.addNotLike(criteria, propertyName, splitPropVal[0], caseInsensitive);
            }
        }
        catch (IllegalArgumentException ex) {
            GlobalVariables.getMessageMap().putError("lookupCriteria[" + propertyName + "]", "error.notSyntax", new String[]{propertyName});
        }
    }

    protected void addDateRangeCriteria(String propertyName, String propertyValue, boolean treatWildcardsAndOperatorsAsLiteral, Predicates criteria) {
        try {
            if (StringUtils.contains((String)propertyValue, (String)SearchOperator.BETWEEN.op())) {
                if (treatWildcardsAndOperatorsAsLiteral) {
                    throw new RuntimeException("Wildcards and operators are not allowed on this date field: " + propertyName);
                }
                String[] rangeValues = StringUtils.split((String)propertyValue, (String)SearchOperator.BETWEEN.op());
                if (rangeValues.length < 2) {
                    throw new IllegalArgumentException("Improper syntax of BETWEEN operator in " + propertyName);
                }
                this.addBetween(criteria, propertyName, this.parseDate(LookupUtils.scrubQueryCharacters((String)rangeValues[0])), this.parseDateUpperBound(LookupUtils.scrubQueryCharacters((String)rangeValues[1])));
            } else if (propertyValue.startsWith(SearchOperator.GREATER_THAN_EQUAL.op())) {
                if (treatWildcardsAndOperatorsAsLiteral) {
                    throw new RuntimeException("Wildcards and operators are not allowed on this date field: " + propertyName);
                }
                this.addGreaterThanOrEqual(criteria, propertyName, this.parseDate(LookupUtils.scrubQueryCharacters((String)propertyValue)));
            } else if (propertyValue.startsWith(SearchOperator.LESS_THAN_EQUAL.op())) {
                if (treatWildcardsAndOperatorsAsLiteral) {
                    throw new RuntimeException("Wildcards and operators are not allowed on this date field: " + propertyName);
                }
                this.addLessThanOrEqual(criteria, propertyName, this.parseDateUpperBound(LookupUtils.scrubQueryCharacters((String)propertyValue)));
            } else if (propertyValue.startsWith(SearchOperator.GREATER_THAN.op())) {
                if (treatWildcardsAndOperatorsAsLiteral) {
                    throw new RuntimeException("Wildcards and operators are not allowed on this date field: " + propertyName);
                }
                this.addGreaterThan(criteria, propertyName, this.parseDate(LookupUtils.scrubQueryCharacters((String)propertyValue)));
            } else if (propertyValue.startsWith(SearchOperator.LESS_THAN.op())) {
                if (treatWildcardsAndOperatorsAsLiteral) {
                    throw new RuntimeException("Wildcards and operators are not allowed on this date field: " + propertyName);
                }
                this.addLessThan(criteria, propertyName, this.parseDate(LookupUtils.scrubQueryCharacters((String)propertyValue)));
            } else {
                this.addBetween(criteria, propertyName, this.parseDate(LookupUtils.scrubQueryCharacters((String)propertyValue)), this.parseDateUpperBound(LookupUtils.scrubQueryCharacters((String)propertyValue)));
            }
        }
        catch (ParseException ex) {
            GlobalVariables.getMessageMap().putError("lookupCriteria[" + propertyName + "]", "error.invalidDate", new String[]{propertyValue});
        }
        catch (IllegalArgumentException ex) {
            GlobalVariables.getMessageMap().putError("lookupCriteria[" + propertyName + "]", "error.betweenSyntax", new String[]{propertyName});
        }
    }

    protected void addNumericRangeCriteria(String propertyName, String propertyValue, Class<?> propertyType, boolean treatWildcardsAndOperatorsAsLiteral, Predicates criteria) {
        try {
            if (StringUtils.contains((String)propertyValue, (String)SearchOperator.BETWEEN.op())) {
                if (treatWildcardsAndOperatorsAsLiteral) {
                    throw new RuntimeException("Cannot use wildcards and operators on numeric field " + propertyName);
                }
                String[] rangeValues = StringUtils.split((String)propertyValue, (String)SearchOperator.BETWEEN.op());
                if (rangeValues.length < 2) {
                    throw new IllegalArgumentException("Improper syntax of BETWEEN operator in " + propertyName);
                }
                this.addBetween(criteria, propertyName, this.cleanNumeric(rangeValues[0], propertyType), this.cleanNumeric(rangeValues[1], propertyType));
            } else if (propertyValue.startsWith(SearchOperator.GREATER_THAN_EQUAL.op())) {
                if (treatWildcardsAndOperatorsAsLiteral) {
                    throw new RuntimeException("Cannot use wildcards and operators on numeric field " + propertyName);
                }
                this.addGreaterThanOrEqual(criteria, propertyName, this.cleanNumeric(propertyValue, propertyType));
            } else if (propertyValue.startsWith(SearchOperator.LESS_THAN_EQUAL.op())) {
                if (treatWildcardsAndOperatorsAsLiteral) {
                    throw new RuntimeException("Cannot use wildcards and operators on numeric field " + propertyName);
                }
                this.addLessThanOrEqual(criteria, propertyName, this.cleanNumeric(propertyValue, propertyType));
            } else if (propertyValue.startsWith(SearchOperator.GREATER_THAN.op())) {
                if (treatWildcardsAndOperatorsAsLiteral) {
                    throw new RuntimeException("Cannot use wildcards and operators on numeric field " + propertyName);
                }
                this.addGreaterThan(criteria, propertyName, this.cleanNumeric(propertyValue, propertyType));
            } else if (propertyValue.startsWith(SearchOperator.LESS_THAN.op())) {
                if (treatWildcardsAndOperatorsAsLiteral) {
                    throw new RuntimeException("Cannot use wildcards and operators on numeric field " + propertyName);
                }
                this.addLessThan(criteria, propertyName, this.cleanNumeric(propertyValue, propertyType));
            } else {
                this.addEqual(criteria, propertyName, this.cleanNumeric(propertyValue, propertyType));
            }
        }
        catch (NumberFormatException ex) {
            GlobalVariables.getMessageMap().putError("lookupCriteria[" + propertyName + "]", "error.invalidNumber", new String[]{propertyValue});
        }
        catch (IllegalArgumentException ex) {
            GlobalVariables.getMessageMap().putError("lookupCriteria[" + propertyName + "]", "error.betweenSyntax", new String[]{propertyName});
        }
    }

    protected void addStringRangeCriteria(String propertyName, String propertyValue, boolean caseInsensitive, Predicates criteria) {
        try {
            if (StringUtils.contains((String)propertyValue, (String)SearchOperator.BETWEEN.op())) {
                String[] rangeValues = StringUtils.split((String)propertyValue, (String)SearchOperator.BETWEEN.op());
                if (rangeValues.length < 2) {
                    throw new IllegalArgumentException("Improper syntax of BETWEEN operator in " + propertyName);
                }
                this.addBetween(criteria, propertyName, rangeValues[0], rangeValues[1], caseInsensitive);
            } else if (propertyValue.startsWith(SearchOperator.GREATER_THAN_EQUAL.op())) {
                this.addGreaterThanOrEqual(criteria, propertyName, LookupUtils.scrubQueryCharacters((String)propertyValue), caseInsensitive);
            } else if (propertyValue.startsWith(SearchOperator.LESS_THAN_EQUAL.op())) {
                this.addLessThanOrEqual(criteria, propertyName, LookupUtils.scrubQueryCharacters((String)propertyValue), caseInsensitive);
            } else if (propertyValue.startsWith(SearchOperator.GREATER_THAN.op())) {
                this.addGreaterThan(criteria, propertyName, LookupUtils.scrubQueryCharacters((String)propertyValue), caseInsensitive);
            } else if (propertyValue.startsWith(SearchOperator.LESS_THAN.op())) {
                this.addLessThan(criteria, propertyName, LookupUtils.scrubQueryCharacters((String)propertyValue), caseInsensitive);
            } else {
                this.addEqual(criteria, propertyName, LookupUtils.scrubQueryCharacters((String)propertyValue), caseInsensitive);
            }
        }
        catch (IllegalArgumentException ex) {
            GlobalVariables.getMessageMap().putError("lookupCriteria[" + propertyName + "]", "error.betweenSyntax", new String[]{propertyName});
        }
    }

    protected void addInactivateableFromToActiveCriteria(Object example, String activeSearchValue, Predicates criteria, Map<String, String> searchValues) {
        Timestamp activeTimestamp = LookupUtils.getActiveDateTimestampForCriteria(searchValues);
        String activeBooleanStr = (String)new OjbCharBooleanConversion().javaToSql((Object)activeSearchValue);
        if ("Y".equals(activeBooleanStr)) {
            Predicates criteriaBeginDate = new Predicates();
            this.addLessThanOrEqual(criteriaBeginDate, "activeFromDate", activeTimestamp);
            Predicates criteriaBeginDateNull = new Predicates();
            this.addIsNull(criteriaBeginDateNull, "activeFromDate");
            this.addOr(criteriaBeginDate, criteriaBeginDateNull);
            this.addAnd(criteria, criteriaBeginDate);
            Predicates criteriaEndDate = new Predicates();
            this.addGreaterThan(criteriaEndDate, "activeToDate", activeTimestamp);
            Predicates criteriaEndDateNull = new Predicates();
            this.addIsNull(criteriaEndDateNull, "activeToDate");
            this.addOr(criteriaEndDate, criteriaEndDateNull);
            this.addAnd(criteria, criteriaEndDate);
        } else if ("N".equals(activeBooleanStr)) {
            Predicates criteriaNonActive = new Predicates();
            this.addGreaterThan(criteriaNonActive, "activeFromDate", activeTimestamp);
            Predicates criteriaEndDate = new Predicates();
            this.addLessThanOrEqual(criteriaEndDate, "activeToDate", activeTimestamp);
            this.addOr(criteriaNonActive, criteriaEndDate);
            this.addAnd(criteria, criteriaNonActive);
        }
    }

    protected void addLogicalOperatorCriteria(String propertyName, String propertyValue, Class<?> propertyType, boolean caseInsensitive, Predicates criteria, String splitValue) {
        Predicates subCriteria;
        String[] splitPropVal = StringUtils.split((String)propertyValue, (String)splitValue);
        if (SearchOperator.OR.op().equals(splitValue)) {
            subCriteria = new OrPredicates();
        } else if (SearchOperator.AND.op().equals(splitValue)) {
            subCriteria = new Predicates();
        } else {
            throw new IllegalArgumentException("Invalid split value: " + splitValue);
        }
        for (int i = 0; i < splitPropVal.length; ++i) {
            Predicates predicate = new Predicates();
            this.addCriteria(propertyName, splitPropVal[i], propertyType, caseInsensitive, false, subCriteria);
        }
        this.addAnd(criteria, subCriteria);
    }

    protected Date parseDate(String dateString) throws ParseException {
        dateString = dateString.trim();
        return this.dateTimeService.convertToSqlDate(dateString);
    }

    protected Date parseDateUpperBound(String dateString) throws ParseException {
        dateString = dateString.trim();
        return this.dateTimeService.convertToSqlDateUpperBound(dateString);
    }

    protected List<String> listPrimaryKeyFieldNames(Class<?> type) {
        return this.getDataObjectService().getMetadataRepository().getMetadata(type).getPrimaryKeyAttributeNames();
    }

    protected Class<?> getPropertyType(Object example, String propertyName) {
        return this.getDataObjectService().wrap(example).getPropertyType(propertyName);
    }

    protected boolean isWriteable(Object o, String p) throws IllegalArgumentException {
        if (null == o || null == p) {
            throw new IllegalArgumentException("Cannot check writable status with null arguments.");
        }
        boolean b = false;
        if (!PropertyUtils.isWriteable((Object)o, (String)p)) {
            if (-1 != p.indexOf(46)) {
                String[] parts = p.split("\\.");
                Class c = this.getPropertyType(o, parts[0]);
                Object i = null;
                if (Collection.class.isAssignableFrom(c)) {
                    c = this.getDataObjectService().getMetadataRepository().getMetadata(o.getClass()).getCollection(parts[0]).getRelatedType();
                }
                try {
                    i = c.newInstance();
                    StringBuffer sb = new StringBuffer();
                    for (int x = 1; x < parts.length; ++x) {
                        sb.append(1 == x ? "" : ".").append(parts[x]);
                    }
                    b = this.isWriteable(i, sb.toString());
                }
                catch (InstantiationException ie) {
                    LOG.info((Object)ie);
                }
                catch (IllegalAccessException iae) {
                    LOG.info((Object)iae);
                }
            }
        } else {
            b = true;
        }
        return b;
    }

    protected void addEqualNumeric(Predicates criteria, String propertyName, Class<?> propertyClass, String searchValue) {
        Predicate pred = propertyClass.equals(Long.class) ? PredicateFactory.equal((String)propertyName, (Object)new Long(searchValue)) : PredicateFactory.equal((String)propertyName, (Object)new Integer(searchValue));
        criteria.addPredicate(pred);
    }

    protected void addEqualTemporal(Predicates criteria, String propertyName, String searchValue) {
        try {
            criteria.addPredicate(PredicateFactory.equal((String)propertyName, (Object)this.parseDate(LookupUtils.scrubQueryCharacters((String)searchValue))));
        }
        catch (ParseException ex) {
            GlobalVariables.getMessageMap().putError("lookupCriteria[" + propertyName + "]", "error.invalidDate", new String[]{searchValue});
        }
    }

    protected void addEqual(Predicates criteria, String propertyName, Object searchValue) {
        criteria.addPredicate(PredicateFactory.equal((String)propertyName, (Object)searchValue));
    }

    protected void addIsNull(Predicates criteria, String propertyName) {
        criteria.addPredicate(PredicateFactory.isNull((String)propertyName));
    }

    protected void addIsNotNull(Predicates criteria, String propertyName) {
        criteria.addPredicate(PredicateFactory.isNotNull((String)propertyName));
    }

    protected void addLike(Predicates criteria, String propertyName, String propertyValue) {
        criteria.addPredicate(PredicateFactory.like((String)propertyName, (CharSequence)propertyValue));
    }

    protected void addNotLike(Predicates criteria, String propertyName, String propertyValue) {
        criteria.addPredicate(PredicateFactory.notLike((String)propertyName, (CharSequence)propertyValue));
    }

    protected void addEqualToBoolean(Predicates criteria, String propertyName, String propertyValue) {
        String temp = LookupUtils.scrubQueryCharacters((String)propertyValue);
        criteria.addPredicate(PredicateFactory.equal((String)propertyName, (Object)("Y".equalsIgnoreCase(temp) || "T".equalsIgnoreCase(temp) || "1".equalsIgnoreCase(temp) || "true".equalsIgnoreCase(temp) ? 1 : 0)));
    }

    protected String uppercasePropertyName(String propertyName) {
        return this.dbPlatform.getUpperCaseFunction() + "(" + propertyName + ")";
    }

    protected void addAnd(Predicates criteria, Predicates criteria2) {
        criteria.and(criteria2);
    }

    protected void addLessThan(Predicates criteria, String propertyName, Object propertyValue) {
        criteria.addPredicate(PredicateFactory.lessThan((String)propertyName, (Object)propertyValue));
    }

    protected void addLessThanOrEqual(Predicates criteria, String propertyName, Object propertyValue) {
        criteria.addPredicate(PredicateFactory.lessThanOrEqual((String)propertyName, (Object)propertyValue));
    }

    protected void addGreaterThan(Predicates criteria, String propertyName, Object propertyValue) {
        criteria.addPredicate(PredicateFactory.greaterThan((String)propertyName, (Object)propertyValue));
    }

    protected void addGreaterThanOrEqual(Predicates criteria, String propertyName, Object propertyValue) {
        criteria.addPredicate(PredicateFactory.greaterThanOrEqual((String)propertyName, (Object)propertyValue));
    }

    protected void addBetween(Predicates criteria, String propertyName, Object value1, Object value2) {
        criteria.addPredicate(PredicateFactory.between((String)propertyName, (Object)value1, (Object)value2));
    }

    protected void addOr(Predicates criteria, Predicates criteria2) {
        criteria.or(criteria2);
    }

    protected void addEqual(Predicates criteria, String propertyName, String searchValue, boolean caseInsensitive) {
        if (caseInsensitive) {
            criteria.addPredicate(PredicateFactory.equalIgnoreCase((String)propertyName, (CharSequence)searchValue));
        } else {
            this.addEqual(criteria, propertyName, searchValue);
        }
    }

    protected void addGreaterThan(Predicates criteria, String propertyName, String propertyValue, boolean caseInsensitive) {
        this.addGreaterThan(criteria, propertyName, propertyValue);
    }

    protected void addGreaterThanOrEqual(Predicates criteria, String propertyName, String propertyValue, boolean caseInsensitive) {
        this.addGreaterThanOrEqual(criteria, propertyName, propertyValue);
    }

    protected void addLessThan(Predicates criteria, String propertyName, String propertyValue, boolean caseInsensitive) {
        this.addLessThan(criteria, propertyName, propertyValue);
    }

    protected void addLessThanOrEqual(Predicates criteria, String propertyName, String propertyValue, boolean caseInsensitive) {
        this.addLessThanOrEqual(criteria, propertyName, propertyValue);
    }

    protected void addLike(Predicates criteria, String propertyName, String propertyValue, boolean caseInsensitive) {
        if (caseInsensitive) {
            criteria.addPredicate(PredicateFactory.likeIgnoreCase((String)propertyName, (CharSequence)propertyValue));
        } else {
            this.addLike(criteria, propertyName, propertyValue);
        }
    }

    protected void addBetween(Predicates criteria, String propertyName, String value1, String value2, boolean caseInsensitive) {
        this.addBetween(criteria, propertyName, value1, value2);
    }

    protected void addNotLike(Predicates criteria, String propertyName, String propertyValue, boolean caseInsensitive) {
        this.addNotLike(criteria, propertyName, propertyValue);
    }

    protected String parsePropertyName(Predicates criteria, String fullyQualifiedPropertyName) {
        return fullyQualifiedPropertyName;
    }

    protected void addInactivateableFromToCurrentCriteria(Object example, String currentSearchValue, Predicates criteria, Map searchValues) {
    }

    static class OrPredicates
    extends Predicates {
        OrPredicates() {
        }

        @Override
        protected Predicate getCriteriaPredicate() {
            if (this.predicates.size() == 1) {
                return (Predicate)this.predicates.get(0);
            }
            return PredicateFactory.or((Predicate[])this.predicates.toArray(new Predicate[this.predicates.size()]));
        }
    }

    static class Predicates {
        protected List<Predicate> predicates = new ArrayList<Predicate>();

        Predicates() {
        }

        void addPredicate(Predicate predicate) {
            this.predicates.add(predicate);
        }

        void or(Predicates pred) {
            ArrayList<Predicate> newpredicates = new ArrayList<Predicate>();
            newpredicates.add(PredicateFactory.or((Predicate[])new Predicate[]{this.getCriteriaPredicate(), pred.getCriteriaPredicate()}));
            this.predicates = newpredicates;
        }

        void and(Predicates pred) {
            this.addPredicate(pred.getCriteriaPredicate());
        }

        protected Predicate getCriteriaPredicate() {
            if (this.predicates.size() == 1) {
                return this.predicates.get(0);
            }
            return PredicateFactory.and((Predicate[])this.predicates.toArray(new Predicate[this.predicates.size()]));
        }

        QueryByCriteria.Builder toQueryBuilder() {
            QueryByCriteria.Builder qbc = QueryByCriteria.Builder.create();
            qbc.setPredicates(new Predicate[]{this.getCriteriaPredicate()});
            return qbc;
        }
    }
}

