/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.rice.krad.uif.service.impl;

import java.util.HashMap;
import org.apache.commons.lang.StringUtils;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.kuali.rice.core.api.exception.RiceRuntimeException;
import org.kuali.rice.krad.datadictionary.DataDictionary;
import org.kuali.rice.krad.inquiry.Inquirable;
import org.kuali.rice.krad.lookup.LookupForm;
import org.kuali.rice.krad.lookup.LookupUtils;
import org.kuali.rice.krad.lookup.LookupView;
import org.kuali.rice.krad.service.DataDictionaryService;
import org.kuali.rice.krad.uif.UifConstants;
import org.kuali.rice.krad.uif.service.ViewDictionaryService;
import org.kuali.rice.krad.uif.util.ViewModelUtils;
import org.kuali.rice.krad.uif.view.View;
import org.kuali.rice.krad.uif.view.ViewSessionPolicy;
import org.kuali.rice.krad.util.KRADUtils;
import org.springframework.beans.PropertyValues;
import org.springframework.util.Assert;

public class ViewDictionaryServiceImpl
implements ViewDictionaryService {
    private static final Logger LOG = LogManager.getLogger(ViewDictionaryServiceImpl.class);
    private DataDictionaryService dataDictionaryService;

    public Inquirable getInquirable(Class<?> dataObjectClass, String viewName) {
        Inquirable inquirable = null;
        if (StringUtils.isBlank((String)viewName)) {
            viewName = "default";
        }
        HashMap<String, String> indexKey = new HashMap<String, String>();
        indexKey.put("viewName", viewName);
        indexKey.put("dataObjectClassName", dataObjectClass.getName());
        PropertyValues propertyValues = this.getDataDictionary().getViewPropertiesByType(UifConstants.ViewType.INQUIRY, indexKey);
        String viewHelperServiceClassName = ViewModelUtils.getStringValFromPVs((PropertyValues)propertyValues, (String)"viewHelperServiceClass");
        if (StringUtils.isNotBlank((String)viewHelperServiceClassName)) {
            try {
                inquirable = (Inquirable)KRADUtils.createNewObjectFromClass(Class.forName(viewHelperServiceClassName));
            }
            catch (ClassNotFoundException e) {
                throw new RiceRuntimeException("Unable to find class for inquirable classname: " + viewHelperServiceClassName, (Throwable)e);
            }
        }
        return inquirable;
    }

    public boolean isInquirable(Class<?> dataObjectClass) {
        HashMap<String, String> indexKey = new HashMap<String, String>();
        indexKey.put("viewName", "default");
        indexKey.put("dataObjectClassName", dataObjectClass.getName());
        boolean isInquirable = this.getDataDictionary().viewByTypeExist(UifConstants.ViewType.INQUIRY, indexKey);
        return isInquirable;
    }

    public boolean isLookupable(Class<?> dataObjectClass) {
        HashMap<String, String> indexKey = new HashMap<String, String>();
        indexKey.put("viewName", "default");
        indexKey.put("dataObjectClassName", dataObjectClass.getName());
        boolean isLookupable = this.getDataDictionary().viewByTypeExist(UifConstants.ViewType.LOOKUP, indexKey);
        return isLookupable;
    }

    public boolean isMaintainable(Class<?> dataObjectClass) {
        HashMap<String, String> indexKey = new HashMap<String, String>();
        indexKey.put("viewName", "default");
        indexKey.put("dataObjectClassName", dataObjectClass.getName());
        boolean isMaintainable = this.getDataDictionary().viewByTypeExist(UifConstants.ViewType.MAINTENANCE, indexKey);
        return isMaintainable;
    }

    public Integer getResultSetLimitForLookup(Class<?> dataObjectClass, LookupForm lookupForm) {
        LookupView lookupView;
        boolean multipleValueSelectSpecifiedOnURL = false;
        if (KRADUtils.isNotNull((Object)lookupForm)) {
            String multiValueSelect;
            if (lookupForm.isMultipleValuesSelect()) {
                multipleValueSelectSpecifiedOnURL = true;
            }
            if (!multipleValueSelectSpecifiedOnURL && lookupForm.getViewRequestParameters().containsKey("multipleValuesSelect") && (multiValueSelect = (String)lookupForm.getViewRequestParameters().get("multipleValuesSelect")).equalsIgnoreCase("true")) {
                multipleValueSelectSpecifiedOnURL = true;
            }
            lookupView = (LookupView)lookupForm.getView();
        } else {
            HashMap<String, String> indexKey = new HashMap<String, String>();
            indexKey.put("viewName", "default");
            indexKey.put("dataObjectClassName", dataObjectClass.getName());
            lookupView = (LookupView)this.getDataDictionary().getViewByTypeIndex(UifConstants.ViewType.LOOKUP, indexKey);
        }
        Integer limit = null;
        if (lookupView != null) {
            if (lookupView.isMultipleValuesSelect() || multipleValueSelectSpecifiedOnURL) {
                limit = lookupView.getMultipleValuesSelectResultSetLimit();
                if (limit == null) {
                    limit = LookupUtils.getApplicationMultipleValueSearchResultsLimit();
                }
            } else {
                limit = lookupView.getResultSetLimit();
                if (limit == null) {
                    limit = LookupUtils.getApplicationSearchResultsLimit();
                }
            }
        }
        return limit;
    }

    public ViewSessionPolicy getViewSessionPolicy(String viewId) {
        Assert.hasLength((String)viewId, (String)"view id is required for retrieving the view session policy");
        ViewSessionPolicy viewSessionPolicy = null;
        View view = this.getDataDictionary().getImmutableViewById(viewId);
        if (view != null) {
            viewSessionPolicy = view.getSessionPolicy();
        }
        return viewSessionPolicy;
    }

    public boolean isSessionStorageEnabled(String viewId) {
        Assert.hasLength((String)viewId, (String)"view id is required for retrieving session indicator");
        boolean sessionStorageEnabled = false;
        View view = this.getDataDictionary().getImmutableViewById(viewId);
        if (view != null) {
            sessionStorageEnabled = view.isPersistFormToSession();
        }
        return sessionStorageEnabled;
    }

    protected DataDictionary getDataDictionary() {
        return this.getDataDictionaryService().getDataDictionary();
    }

    protected DataDictionaryService getDataDictionaryService() {
        return this.dataDictionaryService;
    }

    public void setDataDictionaryService(DataDictionaryService dataDictionaryService) {
        this.dataDictionaryService = dataDictionaryService;
    }
}

