/*-
 * #%L
 * %%
 * Copyright (C) 2005 - 2024 Kuali, Inc. - All Rights Reserved
 * %%
 * You may use and modify this code under the terms of the Kuali, Inc.
 * Pre-Release License Agreement. You may not distribute it.
 * 
 * You should have received a copy of the Kuali, Inc. Pre-Release License
 * Agreement with this file. If not, please write to license@kuali.co.
 * #L%
 */

package org.kuali.rice.krad.service.impl;

import java.util.List;
import java.util.Map;

import org.kuali.rice.krad.bo.ExternalizableBusinessObject;
import org.kuali.rice.krad.util.ExternalizableBusinessObjectUtils;

/**
 * Module service implementation for the Rice KRAD module
 *
 * @author Kuali Rice Team (rice.collab@kuali.org)
 */
public class KRADModuleService extends ModuleServiceBase {
    protected List<String> businessObjects;

    @Override
    public boolean isResponsibleFor(Class businessObjectClass) {
        if (businessObjects != null) {
            if (businessObjects.contains(businessObjectClass.getName())) {
                return true;
            }
        }

        if (ExternalizableBusinessObject.class.isAssignableFrom(businessObjectClass)) {
            Class externalizableBusinessObjectInterface =
                    ExternalizableBusinessObjectUtils.determineExternalizableBusinessObjectSubInterface(
                            businessObjectClass);
            if (externalizableBusinessObjectInterface != null) {
                Map<Class, Class> validEBOs = getModuleConfiguration().getExternalizableBusinessObjectImplementations();
                if (validEBOs != null) {
                    if (validEBOs.get(externalizableBusinessObjectInterface) != null) {
                        return true;
                    }
                }
            }
        }

        return false;
    }

    public List<String> getBusinessObjects() {
        return this.businessObjects;
    }

    public void setBusinessObjects(List<String> businessObjects) {
        this.businessObjects = businessObjects;
    }
}
