/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.rice.krad.service.impl;

import java.beans.PropertyDescriptor;
import java.lang.reflect.InvocationTargetException;
import java.util.Collection;
import java.util.Collections;
import java.util.IdentityHashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.commons.beanutils.PropertyUtils;
import org.apache.commons.lang.ArrayUtils;
import org.apache.commons.lang.StringUtils;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.kuali.rice.core.api.mo.common.active.Inactivatable;
import org.kuali.rice.krad.bo.BusinessObject;
import org.kuali.rice.krad.bo.PersistableBusinessObject;
import org.kuali.rice.krad.data.DataObjectService;
import org.kuali.rice.krad.data.DataObjectWrapper;
import org.kuali.rice.krad.datadictionary.CollectionDefinition;
import org.kuali.rice.krad.datadictionary.ComplexAttributeDefinition;
import org.kuali.rice.krad.datadictionary.DataDictionaryEntry;
import org.kuali.rice.krad.datadictionary.DataDictionaryEntryBase;
import org.kuali.rice.krad.datadictionary.DataObjectEntry;
import org.kuali.rice.krad.datadictionary.ReferenceDefinition;
import org.kuali.rice.krad.datadictionary.exception.AttributeValidationException;
import org.kuali.rice.krad.datadictionary.state.StateMapping;
import org.kuali.rice.krad.datadictionary.validation.AttributeValueReader;
import org.kuali.rice.krad.datadictionary.validation.DictionaryObjectAttributeValueReader;
import org.kuali.rice.krad.datadictionary.validation.ErrorLevel;
import org.kuali.rice.krad.datadictionary.validation.capability.Constrainable;
import org.kuali.rice.krad.datadictionary.validation.constraint.Constraint;
import org.kuali.rice.krad.datadictionary.validation.constraint.provider.ConstraintProvider;
import org.kuali.rice.krad.datadictionary.validation.processor.CollectionConstraintProcessor;
import org.kuali.rice.krad.datadictionary.validation.processor.ConstraintProcessor;
import org.kuali.rice.krad.datadictionary.validation.result.ConstraintValidationResult;
import org.kuali.rice.krad.datadictionary.validation.result.DictionaryValidationResult;
import org.kuali.rice.krad.datadictionary.validation.result.ProcessorResult;
import org.kuali.rice.krad.document.Document;
import org.kuali.rice.krad.document.TransactionalDocument;
import org.kuali.rice.krad.service.DataDictionaryService;
import org.kuali.rice.krad.service.DictionaryValidationService;
import org.kuali.rice.krad.service.DocumentDictionaryService;
import org.kuali.rice.krad.service.LegacyDataAdapter;
import org.kuali.rice.krad.uif.util.ConstraintStateUtils;
import org.kuali.rice.krad.util.ErrorMessage;
import org.kuali.rice.krad.util.GlobalVariables;
import org.kuali.rice.krad.util.KRADUtils;
import org.kuali.rice.krad.util.MessageMap;
import org.springframework.beans.PropertyAccessorUtils;

public class DictionaryValidationServiceImpl
implements DictionaryValidationService {
    private static final Logger LOG = LogManager.getLogger(DictionaryValidationServiceImpl.class);
    public static final String VALIDATE_METHOD = "validate";
    protected DataDictionaryService dataDictionaryService;
    protected DocumentDictionaryService documentDictionaryService;
    @Deprecated
    private LegacyDataAdapter legacyDataAdapter;
    private List<CollectionConstraintProcessor> collectionConstraintProcessors;
    private List<ConstraintProvider> constraintProviders;
    private List<ConstraintProcessor> elementConstraintProcessors;
    private DataObjectService dataObjectService;

    protected final Set<Object> newIdentitySet() {
        return Collections.newSetFromMap(new IdentityHashMap());
    }

    public DictionaryValidationResult validate(Object object) {
        return this.validate(object, object.getClass().getName(), (String)null, true);
    }

    public DictionaryValidationResult validate(Object object, String entryName, String attributeName, boolean doOptionalProcessing) {
        StateMapping stateMapping = null;
        String validationState = null;
        DataDictionaryEntry entry = this.getDataDictionaryService().getDataDictionary().getDictionaryObjectEntry(entryName);
        if (entry != null && (stateMapping = entry.getStateMapping()) != null) {
            validationState = stateMapping.getCurrentState(object);
        }
        DictionaryObjectAttributeValueReader attributeValueReader = new DictionaryObjectAttributeValueReader(object, entryName, entry);
        attributeValueReader.setAttributeName(attributeName);
        return this.validate((AttributeValueReader)attributeValueReader, doOptionalProcessing, validationState, stateMapping);
    }

    public DictionaryValidationResult validateAgainstNextState(Object object) {
        String entryName = object.getClass().getName();
        StateMapping stateMapping = null;
        String validationState = null;
        DataDictionaryEntry entry = this.getDataDictionaryService().getDataDictionary().getDictionaryObjectEntry(entryName);
        if (entry != null && (stateMapping = entry.getStateMapping()) != null) {
            validationState = stateMapping.getNextState(object);
        }
        DictionaryObjectAttributeValueReader attributeValueReader = new DictionaryObjectAttributeValueReader(object, entryName, entry);
        return this.validate((AttributeValueReader)attributeValueReader, true, validationState, stateMapping);
    }

    public DictionaryValidationResult validateAgainstState(Object object, String validationState) {
        String entryName = object.getClass().getName();
        StateMapping stateMapping = null;
        DataDictionaryEntry entry = this.getDataDictionaryService().getDataDictionary().getDictionaryObjectEntry(entryName);
        if (entry != null && (stateMapping = entry.getStateMapping()) != null && StringUtils.isBlank((String)validationState)) {
            validationState = stateMapping.getCurrentState(object);
        }
        DictionaryObjectAttributeValueReader attributeValueReader = new DictionaryObjectAttributeValueReader(object, entryName, entry);
        return this.validate((AttributeValueReader)attributeValueReader, true, validationState, stateMapping);
    }

    public DictionaryValidationResult validate(Object object, String entryName, DataDictionaryEntry entry, boolean doOptionalProcessing) {
        StateMapping stateMapping = null;
        String validationState = null;
        if (entry != null && (stateMapping = entry.getStateMapping()) != null) {
            validationState = stateMapping.getCurrentState(object);
        }
        DictionaryObjectAttributeValueReader attributeValueReader = new DictionaryObjectAttributeValueReader(object, entryName, entry);
        return this.validate((AttributeValueReader)attributeValueReader, doOptionalProcessing, validationState, stateMapping);
    }

    public void validateDocument(Document document) {
        String documentEntryName = document.getDocumentHeader().getWorkflowDocument().getDocumentTypeName();
        this.validate((Object)document, documentEntryName, (String)null, true);
    }

    public void validateDocumentAttribute(Document document, String attributeName, String errorPrefix) {
        String documentEntryName = document.getDocumentHeader().getWorkflowDocument().getDocumentTypeName();
        this.validate((Object)document, documentEntryName, attributeName, true);
    }

    public void validateDocumentAndUpdatableReferencesRecursively(Document document, int maxDepth, boolean validateRequired) {
        this.validateDocumentAndUpdatableReferencesRecursively(document, maxDepth, validateRequired, false);
    }

    public void validateDocumentAndUpdatableReferencesRecursively(Document document, int maxDepth, boolean validateRequired, boolean chompLastLetterSFromCollectionName) {
        String documentEntryName = document.getDocumentHeader().getWorkflowDocument().getDocumentTypeName();
        this.validate((Object)document, documentEntryName, (String)null, true);
        if (maxDepth > 0) {
            this.validateUpdatabableReferencesRecursively(document, maxDepth - 1, validateRequired, chompLastLetterSFromCollectionName, this.newIdentitySet());
        }
    }

    protected void validateUpdatabableReferencesRecursively(Object businessObject, int maxDepth, boolean validateRequired, boolean chompLastLetterSFromCollectionName, Set<Object> processedBOs) {
        if (KRADUtils.isNull((Object)businessObject) || processedBOs.contains(businessObject)) {
            return;
        }
        processedBOs.add(businessObject);
        Map references = this.getLegacyDataAdapter().listReferenceObjectFields(businessObject.getClass());
        for (String referenceName : references.keySet()) {
            Object referenceObj;
            if (!this.getLegacyDataAdapter().isReferenceUpdatable(businessObject.getClass(), referenceName) || KRADUtils.isNull((Object)(referenceObj = this.getDataObjectService().wrap(businessObject).getPropertyValueNullSafe(referenceName))) || !(referenceObj instanceof PersistableBusinessObject)) continue;
            BusinessObject referenceBusinessObject = (BusinessObject)referenceObj;
            GlobalVariables.getMessageMap().addToErrorPath(referenceName);
            this.validateBusinessObject(referenceBusinessObject, validateRequired);
            if (maxDepth > 0) {
                this.validateUpdatabableReferencesRecursively(referenceBusinessObject, maxDepth - 1, validateRequired, chompLastLetterSFromCollectionName, processedBOs);
            }
            GlobalVariables.getMessageMap().removeFromErrorPath(referenceName);
        }
        Map collections = this.getLegacyDataAdapter().listCollectionObjectTypes(businessObject.getClass());
        for (String collectionName : collections.keySet()) {
            Object listObj;
            if (!this.getLegacyDataAdapter().isCollectionUpdatable(businessObject.getClass(), collectionName) || KRADUtils.isNull((Object)(listObj = this.getDataObjectService().wrap(businessObject).getPropertyValueNullSafe(collectionName)))) continue;
            if (!(listObj instanceof List)) {
                if (!LOG.isInfoEnabled()) continue;
                LOG.info("The reference named " + collectionName + " of BO class " + businessObject.getClass().getName() + " should be of type java.util.List to be validated properly.");
                continue;
            }
            List list = (List)listObj;
            KRADUtils.materializeObjects((Collection)list);
            for (int i = 0; i < list.size(); ++i) {
                Object o = list.get(i);
                if (!KRADUtils.isNotNull(o) || !(o instanceof PersistableBusinessObject)) continue;
                BusinessObject element = (BusinessObject)o;
                String errorPathAddition = chompLastLetterSFromCollectionName ? StringUtils.chomp((String)collectionName, (String)"s") + "[" + Integer.toString(i) + "]" : collectionName + "[" + Integer.toString(i) + "]";
                GlobalVariables.getMessageMap().addToErrorPath(errorPathAddition);
                this.validateBusinessObject(element, validateRequired);
                if (maxDepth > 0) {
                    this.validateUpdatabableReferencesRecursively(element, maxDepth - 1, validateRequired, chompLastLetterSFromCollectionName, processedBOs);
                }
                GlobalVariables.getMessageMap().removeFromErrorPath(errorPathAddition);
            }
        }
    }

    public boolean isBusinessObjectValid(Object businessObject) {
        return this.isBusinessObjectValid(businessObject, null);
    }

    public boolean isBusinessObjectValid(Object businessObject, String prefix) {
        MessageMap errorMap = GlobalVariables.getMessageMap();
        int originalErrorCount = errorMap.getErrorCount();
        errorMap.addToErrorPath(prefix);
        this.validateBusinessObject(businessObject);
        errorMap.removeFromErrorPath(prefix);
        return errorMap.getErrorCount() == originalErrorCount;
    }

    public void validateBusinessObjectsRecursively(Object businessObject, int depth) {
        if (KRADUtils.isNull((Object)businessObject)) {
            return;
        }
        this.validateBusinessObject(businessObject);
        this.validateBusinessObjectsFromDescriptors(businessObject, PropertyUtils.getPropertyDescriptors(businessObject.getClass()), depth);
    }

    public void validateBusinessObject(Object businessObject) {
        this.validateBusinessObject(businessObject, true);
    }

    public void validateBusinessObject(Object businessObject, boolean validateRequired) {
        if (KRADUtils.isNull((Object)businessObject)) {
            return;
        }
        this.validate(businessObject, businessObject.getClass().getName(), (String)null, validateRequired);
    }

    protected void validateBusinessObjectsFromDescriptors(Object object, PropertyDescriptor[] propertyDescriptors, int depth) {
        DataObjectWrapper wrapper = this.getDataObjectService().wrap(object);
        for (PropertyDescriptor propertyDescriptor : propertyDescriptors) {
            if (propertyDescriptor.getPropertyType() != null && PersistableBusinessObject.class.isAssignableFrom(propertyDescriptor.getPropertyType()) && wrapper.getPropertyValueNullSafe(propertyDescriptor.getName()) != null) {
                BusinessObject bo = (BusinessObject)wrapper.getPropertyValueNullSafe(propertyDescriptor.getName());
                if (depth == 0) {
                    GlobalVariables.getMessageMap().addToErrorPath(propertyDescriptor.getName());
                    this.validateBusinessObject(bo);
                    GlobalVariables.getMessageMap().removeFromErrorPath(propertyDescriptor.getName());
                    continue;
                }
                this.validateBusinessObjectsRecursively(bo, depth - 1);
                continue;
            }
            if (propertyDescriptor.getPropertyType() == null || !List.class.isAssignableFrom(propertyDescriptor.getPropertyType()) || wrapper.getPropertyValueNullSafe(propertyDescriptor.getName()) == null) continue;
            List propertyList = (List)wrapper.getPropertyValueNullSafe(propertyDescriptor.getName());
            for (int j = 0; j < propertyList.size(); ++j) {
                if (propertyList.get(j) == null || !(propertyList.get(j) instanceof PersistableBusinessObject)) continue;
                if (depth == 0) {
                    GlobalVariables.getMessageMap().addToErrorPath(StringUtils.chomp((String)propertyDescriptor.getName(), (String)"s") + "[" + Integer.valueOf(j).toString() + "]");
                    this.validateBusinessObject((BusinessObject)propertyList.get(j));
                    GlobalVariables.getMessageMap().removeFromErrorPath(StringUtils.chomp((String)propertyDescriptor.getName(), (String)"s") + "[" + Integer.valueOf(j).toString() + "]");
                    continue;
                }
                this.validateBusinessObjectsRecursively((BusinessObject)propertyList.get(j), depth - 1);
            }
        }
    }

    @Deprecated
    public void validatePrimitiveFromDescriptor(String entryName, Object object, PropertyDescriptor propertyDescriptor, String errorPrefix, boolean validateRequired) {
        if (null != propertyDescriptor) {
            this.validate(object, entryName, propertyDescriptor.getName(), validateRequired);
        }
    }

    public boolean validateReferenceExists(Object dataObject, ReferenceDefinition reference) {
        return this.validateReferenceExists(dataObject, reference.getAttributeName());
    }

    public boolean validateReferenceExists(Object dataObject, String referenceName) {
        Object referenceDataObject = this.getLegacyDataAdapter().getReferenceIfExists(dataObject, referenceName);
        return KRADUtils.isNotNull((Object)referenceDataObject);
    }

    public boolean validateReferenceIsActive(Object dataObject, ReferenceDefinition reference) {
        return this.validateReferenceIsActive(dataObject, reference.getAttributeName());
    }

    public boolean validateReferenceIsActive(Object dataObject, String referenceName) {
        Object referenceDataObject = this.getLegacyDataAdapter().getReferenceIfExists(dataObject, referenceName);
        if (referenceDataObject == null) {
            return false;
        }
        return !(referenceDataObject instanceof Inactivatable) || ((Inactivatable)referenceDataObject).isActive();
    }

    public boolean validateReferenceExistsAndIsActive(Object dataObject, ReferenceDefinition reference) {
        String displayFieldName;
        if (reference.isDisplayFieldNameSet()) {
            displayFieldName = reference.getDisplayFieldName();
        } else {
            Class<?> boClass = reference.isCollectionReference() ? reference.getCollectionBusinessObjectClass() : dataObject.getClass();
            displayFieldName = this.dataDictionaryService.getAttributeLabel(boClass, reference.getAttributeToHighlightOnFail());
        }
        boolean success = reference.isCollectionReference() ? this.validateCollectionReferenceExistsAndIsActive(dataObject, reference, displayFieldName, StringUtils.split((String)reference.getCollection(), (String)"."), null) : this.validateReferenceExistsAndIsActive(dataObject, reference.getAttributeName(), reference.getAttributeToHighlightOnFail(), displayFieldName);
        return success;
    }

    private boolean validateCollectionReferenceExistsAndIsActive(Object dataObject, ReferenceDefinition reference, String displayFieldName, String[] intermediateCollections, String pathToAttributeI) {
        Collection referenceCollection;
        boolean success = true;
        String collectionName = intermediateCollections[0];
        intermediateCollections = (String[])ArrayUtils.removeElement((Object[])intermediateCollections, (Object)collectionName);
        try {
            referenceCollection = (Collection)PropertyUtils.getProperty((Object)dataObject, (String)collectionName);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
        int pos = 0;
        Iterator iterator = referenceCollection.iterator();
        while (iterator.hasNext()) {
            String pathToAttribute = StringUtils.defaultString((String)pathToAttributeI) + collectionName + "[" + pos++ + "].";
            if (intermediateCollections.length > 0) {
                success &= this.validateCollectionReferenceExistsAndIsActive(iterator.next(), reference, displayFieldName, intermediateCollections, pathToAttribute);
                continue;
            }
            String attributeToHighlightOnFail = pathToAttribute + reference.getAttributeToHighlightOnFail();
            success &= this.validateReferenceExistsAndIsActive(iterator.next(), reference.getAttributeName(), attributeToHighlightOnFail, displayFieldName);
        }
        return success;
    }

    public boolean validateReferenceExistsAndIsActive(Object dataObject, String referenceName, String attributeToHighlightOnFail, String displayFieldName) {
        boolean referenceActive;
        if (PropertyAccessorUtils.isNestedOrIndexedProperty((String)referenceName)) {
            String nestedAttributePrefix = KRADUtils.getNestedAttributePrefix((String)referenceName);
            String nestedAttributePrimitive = KRADUtils.getNestedAttributePrimitive((String)referenceName);
            Object nestedObject = this.getDataObjectService().wrap(dataObject).getPropertyValueNullSafe(nestedAttributePrefix);
            return this.validateReferenceExistsAndIsActive(nestedObject, nestedAttributePrimitive, attributeToHighlightOnFail, displayFieldName);
        }
        boolean hasReferences = this.validateFkFieldsPopulated(dataObject, referenceName);
        boolean referenceExists = hasReferences && this.validateReferenceExists(dataObject, referenceName);
        boolean canIncludeActiveReference = referenceExists && (!(dataObject instanceof Inactivatable) || ((Inactivatable)dataObject).isActive());
        boolean bl = referenceActive = canIncludeActiveReference && this.validateReferenceIsActive(dataObject, referenceName);
        if (hasReferences && !referenceExists) {
            GlobalVariables.getMessageMap().putError(attributeToHighlightOnFail, "error.existence", new String[]{displayFieldName});
            return false;
        }
        if (canIncludeActiveReference && !referenceActive) {
            GlobalVariables.getMessageMap().putError(attributeToHighlightOnFail, "error.inactive", new String[]{displayFieldName});
            return false;
        }
        return true;
    }

    private boolean validateFkFieldsPopulated(Object dataObject, String referenceName) {
        List fkFields = this.getDataDictionaryService().getRelationshipSourceAttributes(dataObject.getClass().getName(), referenceName);
        if (fkFields != null) {
            for (String fkFieldName : fkFields) {
                Object fkFieldValue;
                try {
                    fkFieldValue = PropertyUtils.getProperty((Object)dataObject, (String)fkFieldName);
                }
                catch (IllegalAccessException | NoSuchMethodException | InvocationTargetException e) {
                    return false;
                }
                if (fkFieldValue == null) {
                    return false;
                }
                if (!String.class.isAssignableFrom(fkFieldValue.getClass()) || !StringUtils.isBlank((String)((String)fkFieldValue))) continue;
                return false;
            }
        } else {
            return this.getLegacyDataAdapter().allForeignKeyValuesPopulatedForReference(dataObject, referenceName);
        }
        return true;
    }

    public boolean validateDefaultExistenceChecks(Object dataObject) {
        boolean success = true;
        Collection references = this.getDocumentDictionaryService().getDefaultExistenceChecks(dataObject.getClass());
        for (Object o : references) {
            ReferenceDefinition reference = (ReferenceDefinition)o;
            success &= this.validateReferenceExistsAndIsActive(dataObject, reference);
        }
        return success;
    }

    public boolean validateDefaultExistenceChecksForNewCollectionItem(Object dataObject, Object newCollectionItem, String collectionName) {
        boolean success = true;
        if (StringUtils.isNotBlank((String)collectionName)) {
            Collection references = this.getDocumentDictionaryService().getDefaultExistenceChecks(dataObject.getClass());
            for (Object o : references) {
                String displayFieldName;
                ReferenceDefinition reference = (ReferenceDefinition)o;
                if (!collectionName.equals(reference.getCollection())) continue;
                if (reference.isDisplayFieldNameSet()) {
                    displayFieldName = reference.getDisplayFieldName();
                } else {
                    Class<?> boClass = reference.isCollectionReference() ? reference.getCollectionBusinessObjectClass() : dataObject.getClass();
                    displayFieldName = this.dataDictionaryService.getAttributeLabel(boClass, reference.getAttributeToHighlightOnFail());
                }
                success &= this.validateReferenceExistsAndIsActive(newCollectionItem, reference.getAttributeName(), reference.getAttributeToHighlightOnFail(), displayFieldName);
            }
        }
        return success;
    }

    public boolean validateDefaultExistenceChecksForTransDoc(TransactionalDocument document) {
        boolean success = true;
        Collection references = this.getDocumentDictionaryService().getDefaultExistenceChecks((Document)document);
        for (Object o : references) {
            ReferenceDefinition reference = (ReferenceDefinition)o;
            success &= this.validateReferenceExistsAndIsActive(document, reference);
        }
        return success;
    }

    public boolean validateDefaultExistenceChecksForNewCollectionItem(TransactionalDocument document, Object newCollectionItem, String collectionName) {
        boolean success = true;
        if (StringUtils.isNotBlank((String)collectionName)) {
            Collection references = this.getDocumentDictionaryService().getDefaultExistenceChecks((Document)document);
            for (Object o : references) {
                String displayFieldName;
                ReferenceDefinition reference = (ReferenceDefinition)o;
                if (!collectionName.equals(reference.getCollection())) continue;
                if (reference.isDisplayFieldNameSet()) {
                    displayFieldName = reference.getDisplayFieldName();
                } else {
                    Class<?> boClass = reference.isCollectionReference() ? reference.getCollectionBusinessObjectClass() : document.getClass();
                    displayFieldName = this.dataDictionaryService.getAttributeLabel(boClass, reference.getAttributeToHighlightOnFail());
                }
                success &= this.validateReferenceExistsAndIsActive(newCollectionItem, reference.getAttributeName(), reference.getAttributeToHighlightOnFail(), displayFieldName);
            }
        }
        return success;
    }

    public DictionaryValidationResult validate(AttributeValueReader valueReader, boolean doOptionalProcessing, String validationState, StateMapping stateMapping) {
        DictionaryValidationResult result = new DictionaryValidationResult();
        if (valueReader.getAttributeName() == null) {
            this.validateObject(result, valueReader, doOptionalProcessing, true, validationState, stateMapping);
        } else {
            this.validateAttribute(result, valueReader, doOptionalProcessing, validationState, stateMapping);
        }
        if (result.getNumberOfErrors() > 0) {
            String[] prefixParams = new String[1];
            String prefixMessageKey = "validation.statePrefix";
            if (stateMapping != null) {
                prefixParams[0] = stateMapping.getStateNameMessage(validationState);
            }
            if (StringUtils.isBlank((String)prefixParams[0])) {
                prefixMessageKey = null;
            }
            for (ConstraintValidationResult constraintValidationResult : result) {
                ErrorMessage errorMessage;
                if (constraintValidationResult.getStatus().getLevel() < ErrorLevel.WARN.getLevel()) continue;
                String attributePath = constraintValidationResult.getAttributePath();
                if (attributePath == null || attributePath.isEmpty()) {
                    attributePath = constraintValidationResult.getAttributeName();
                }
                if (constraintValidationResult.getConstraintLabelKey() != null) {
                    errorMessage = new ErrorMessage(constraintValidationResult.getConstraintLabelKey(), constraintValidationResult.getErrorParameters());
                    errorMessage.setMessagePrefixKey(prefixMessageKey);
                    errorMessage.setMessagePrefixParameters(prefixParams);
                    GlobalVariables.getMessageMap().putError(attributePath, errorMessage);
                    continue;
                }
                errorMessage = new ErrorMessage(constraintValidationResult.getErrorKey(), constraintValidationResult.getErrorParameters());
                errorMessage.setMessagePrefixKey(prefixMessageKey);
                errorMessage.setMessagePrefixParameters(prefixParams);
                GlobalVariables.getMessageMap().putError(attributePath, errorMessage);
            }
        }
        return result;
    }

    protected void processElementConstraints(DictionaryValidationResult result, Object value, Constrainable definition, AttributeValueReader attributeValueReader, boolean doOptionalProcessing, String validationState, StateMapping stateMapping) {
        this.processConstraints(result, this.elementConstraintProcessors, value, definition, attributeValueReader, doOptionalProcessing, validationState, stateMapping);
    }

    protected void processCollectionConstraints(DictionaryValidationResult result, Collection<?> collection, Constrainable definition, AttributeValueReader attributeValueReader, boolean doOptionalProcessing, String validationState, StateMapping stateMapping) {
        this.processConstraints(result, this.collectionConstraintProcessors, collection, definition, attributeValueReader, doOptionalProcessing, validationState, stateMapping);
    }

    private void processConstraints(DictionaryValidationResult result, List<? extends ConstraintProcessor> constraintProcessors, Object value, Constrainable definition, AttributeValueReader attributeValueReader, boolean doOptionalProcessing, String validationState, StateMapping stateMapping) {
        if (constraintProcessors != null) {
            Constrainable selectedDefinition = definition;
            AttributeValueReader selectedAttributeValueReader = attributeValueReader;
            LinkedList constraintQueue = new LinkedList();
            for (ConstraintProcessor constraintProcessor : constraintProcessors) {
                if (!doOptionalProcessing && constraintProcessor.isOptional()) {
                    result.addSkipped(attributeValueReader, constraintProcessor.getName());
                    continue;
                }
                Class constraintType = constraintProcessor.getConstraintType();
                for (ConstraintProvider constraintProvider : this.constraintProviders) {
                    List constraintList;
                    if (!constraintProvider.isSupported(selectedDefinition) || (constraintList = constraintProvider.getConstraints(selectedDefinition, constraintType)) == null) continue;
                    constraintQueue.addAll(constraintList);
                }
                if (constraintQueue.isEmpty()) {
                    result.addSkipped(attributeValueReader, constraintProcessor.getName());
                    continue;
                }
                LinkedList<Constraint> additionalConstraints = new LinkedList<Constraint>();
                while (!constraintQueue.isEmpty()) {
                    Constraint constraint = (Constraint)constraintQueue.poll();
                    if (!constraintType.isInstance(constraint)) {
                        result.addSkipped(attributeValueReader, constraintProcessor.getName());
                        additionalConstraints.add(constraint);
                        continue;
                    }
                    if ((constraint = ConstraintStateUtils.getApplicableConstraint((Constraint)constraint, (String)validationState, (StateMapping)stateMapping)) == null) continue;
                    ProcessorResult processorResult = constraintProcessor.process(result, value, constraint, selectedAttributeValueReader);
                    List processorResultContraints = processorResult.getConstraints();
                    if (processorResultContraints != null && processorResultContraints.size() > 0) {
                        constraintQueue.addAll(processorResultContraints);
                    }
                    if (processorResult.isDefinitionProvided()) {
                        selectedDefinition = processorResult.getDefinition();
                    }
                    if (!processorResult.isAttributeValueReaderProvided()) continue;
                    selectedAttributeValueReader = processorResult.getAttributeValueReader();
                }
                constraintQueue.addAll(additionalConstraints);
            }
        }
    }

    protected void validateAttribute(DictionaryValidationResult result, AttributeValueReader attributeValueReader, boolean checkIfRequired, String validationState, StateMapping stateMapping) throws AttributeValidationException {
        Constrainable definition = attributeValueReader.getDefinition(attributeValueReader.getAttributeName());
        this.validateAttribute(result, definition, attributeValueReader, checkIfRequired, validationState, stateMapping);
    }

    protected void validateAttribute(DictionaryValidationResult result, Constrainable definition, AttributeValueReader attributeValueReader, boolean checkIfRequired, String validationState, StateMapping stateMapping) throws AttributeValidationException {
        if (definition == null) {
            throw new AttributeValidationException("Unable to validate constraints for attribute \"" + attributeValueReader.getAttributeName() + "\" on entry \"" + attributeValueReader.getEntryName() + "\" because no attribute definition can be found.");
        }
        Object value = attributeValueReader.getValue();
        this.processElementConstraints(result, value, definition, attributeValueReader, checkIfRequired, validationState, stateMapping);
    }

    protected void validateObject(DictionaryValidationResult result, AttributeValueReader attributeValueReader, boolean doOptionalProcessing, boolean processAttributes, String validationState, StateMapping stateMapping) throws AttributeValidationException {
        DataObjectEntry entry;
        List complexAttrDefinitions;
        Constrainable objectEntry = attributeValueReader.getEntry();
        this.processElementConstraints(result, attributeValueReader.getObject(), objectEntry, attributeValueReader, doOptionalProcessing, validationState, stateMapping);
        List definitions = attributeValueReader.getDefinitions();
        if (null == definitions) {
            return;
        }
        if (processAttributes) {
            for (Constrainable definition : definitions) {
                String attributeName = definition.getName();
                attributeValueReader.setAttributeName(attributeName);
                if (!attributeValueReader.isReadable()) continue;
                Object value = attributeValueReader.getValue(attributeName);
                this.processElementConstraints(result, value, definition, attributeValueReader, doOptionalProcessing, validationState, stateMapping);
            }
        }
        if (objectEntry instanceof DataDictionaryEntryBase && (complexAttrDefinitions = ((DataDictionaryEntryBase)objectEntry).getComplexAttributes()) != null) {
            for (ComplexAttributeDefinition complexAttrDefinition : complexAttrDefinitions) {
                String attributeName = complexAttrDefinition.getName();
                attributeValueReader.setAttributeName(attributeName);
                if (!attributeValueReader.isReadable()) continue;
                Object value = attributeValueReader.getValue();
                DataDictionaryEntry childEntry = complexAttrDefinition.getDataObjectEntry();
                if (value != null) {
                    DictionaryObjectAttributeValueReader nestedAttributeValueReader = new DictionaryObjectAttributeValueReader(value, childEntry.getFullClassName(), childEntry, attributeValueReader.getPath());
                    nestedAttributeValueReader.setAttributeName(attributeValueReader.getAttributeName());
                    this.validateObject(result, (AttributeValueReader)nestedAttributeValueReader, doOptionalProcessing, false, validationState, stateMapping);
                }
                this.processElementConstraints(result, value, (Constrainable)complexAttrDefinition, attributeValueReader, doOptionalProcessing, validationState, stateMapping);
            }
        }
        if ((entry = (DataObjectEntry)attributeValueReader.getEntry()) != null) {
            for (CollectionDefinition collectionDefinition : entry.getCollections()) {
                DataDictionaryEntry childEntry;
                String childEntryName = collectionDefinition.getDataObjectClass();
                String attributeName = collectionDefinition.getName();
                attributeValueReader.setAttributeName(attributeName);
                if (!attributeValueReader.isReadable()) continue;
                Collection collectionObject = (Collection)attributeValueReader.getValue();
                DataDictionaryEntry dataDictionaryEntry = childEntry = childEntryName != null ? this.getDataDictionaryService().getDataDictionary().getDictionaryObjectEntry(childEntryName) : null;
                if (collectionObject != null) {
                    int index = 0;
                    for (Object value : collectionObject) {
                        String objectAttributePath = attributeValueReader.getPath() + "[" + index + "]";
                        DictionaryObjectAttributeValueReader nestedAttributeValueReader = new DictionaryObjectAttributeValueReader(value, childEntryName, childEntry, objectAttributePath);
                        this.validateObject(result, (AttributeValueReader)nestedAttributeValueReader, doOptionalProcessing, true, validationState, stateMapping);
                        ++index;
                    }
                }
                this.processCollectionConstraints(result, collectionObject, (Constrainable)collectionDefinition, attributeValueReader, doOptionalProcessing, validationState, stateMapping);
            }
        }
    }

    public List<CollectionConstraintProcessor> getCollectionConstraintProcessors() {
        return this.collectionConstraintProcessors;
    }

    public void setCollectionConstraintProcessors(List<CollectionConstraintProcessor> collectionConstraintProcessors) {
        this.collectionConstraintProcessors = collectionConstraintProcessors;
    }

    public List<ConstraintProvider> getConstraintProviders() {
        return this.constraintProviders;
    }

    public void setConstraintProviders(List<ConstraintProvider> constraintProviders) {
        this.constraintProviders = constraintProviders;
    }

    public List<ConstraintProcessor> getElementConstraintProcessors() {
        return this.elementConstraintProcessors;
    }

    public void setElementConstraintProcessors(List<ConstraintProcessor> elementConstraintProcessors) {
        this.elementConstraintProcessors = elementConstraintProcessors;
    }

    public DocumentDictionaryService getDocumentDictionaryService() {
        return this.documentDictionaryService;
    }

    public DataDictionaryService getDataDictionaryService() {
        return this.dataDictionaryService;
    }

    public void setDataDictionaryService(DataDictionaryService dataDictionaryService) {
        this.dataDictionaryService = dataDictionaryService;
    }

    public DataObjectService getDataObjectService() {
        return this.dataObjectService;
    }

    public void setDataObjectService(DataObjectService dataObjectService) {
        this.dataObjectService = dataObjectService;
    }

    public void setDocumentDictionaryService(DocumentDictionaryService documentDictionaryService) {
        this.documentDictionaryService = documentDictionaryService;
    }

    @Deprecated
    public LegacyDataAdapter getLegacyDataAdapter() {
        return this.legacyDataAdapter;
    }

    public void setLegacyDataAdapter(LegacyDataAdapter legacyDataAdapter) {
        this.legacyDataAdapter = legacyDataAdapter;
    }
}

