/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.rice.krad.service.impl;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang.StringUtils;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.kuali.rice.core.api.criteria.Predicate;
import org.kuali.rice.core.api.criteria.PredicateFactory;
import org.kuali.rice.core.api.criteria.QueryByCriteria;
import org.kuali.rice.core.api.criteria.QueryResults;
import org.kuali.rice.core.api.mo.common.active.Inactivatable;
import org.kuali.rice.core.api.mo.common.active.MutableInactivatable;
import org.kuali.rice.krad.bo.BusinessObject;
import org.kuali.rice.krad.data.DataObjectService;
import org.kuali.rice.krad.data.DataObjectWrapper;
import org.kuali.rice.krad.data.KradDataServiceLocator;
import org.kuali.rice.krad.data.metadata.DataObjectAttributeRelationship;
import org.kuali.rice.krad.data.metadata.DataObjectMetadata;
import org.kuali.rice.krad.data.metadata.DataObjectRelationship;
import org.kuali.rice.krad.datadictionary.InactivationBlockingMetadata;
import org.kuali.rice.krad.datadictionary.RelationshipDefinition;
import org.kuali.rice.krad.service.DataObjectMetaDataService;
import org.kuali.rice.krad.service.InactivationBlockingDetectionService;
import org.kuali.rice.krad.service.KRADServiceLocatorWeb;
import org.kuali.rice.krad.service.LegacyDataAdapter;
import org.kuali.rice.krad.util.KRADUtils;
import org.kuali.rice.krad.util.LegacyUtils;
import org.springframework.transaction.annotation.Transactional;

@Transactional
public class InactivationBlockingDetectionServiceImpl
implements InactivationBlockingDetectionService {
    private static final Logger LOG = LogManager.getLogger(InactivationBlockingDetectionServiceImpl.class);
    protected DataObjectMetaDataService dataObjectMetaDataService;
    private volatile DataObjectService dataObjectService;
    protected LegacyDataAdapter legacyDataAdapter;

    @Deprecated
    public Collection<BusinessObject> listAllBlockerRecords(BusinessObject blockedBo, InactivationBlockingMetadata inactivationBlockingMetadata) {
        ArrayList<BusinessObject> blockingRecords = new ArrayList<BusinessObject>();
        Map<String, String> queryMap = this.buildInactivationBlockerQueryMap(blockedBo, inactivationBlockingMetadata);
        if (LOG.isDebugEnabled()) {
            LOG.debug("Checking for blocker records for object: " + String.valueOf(blockedBo));
            LOG.debug("    With Metadata: " + String.valueOf(inactivationBlockingMetadata));
            LOG.debug("    Resulting Query Map: " + String.valueOf(queryMap));
        }
        if (queryMap != null) {
            List potentialBlockingRecords = this.legacyDataAdapter.findMatching(inactivationBlockingMetadata.getBlockingReferenceBusinessObjectClass(), queryMap);
            for (MutableInactivatable businessObject : potentialBlockingRecords) {
                if (!businessObject.isActive()) continue;
                blockingRecords.add((BusinessObject)businessObject);
            }
        }
        return blockingRecords;
    }

    @Deprecated
    public boolean hasABlockingRecord(BusinessObject blockedBo, InactivationBlockingMetadata inactivationBlockingMetadata) {
        boolean hasBlockingRecord = false;
        Map<String, String> queryMap = this.buildInactivationBlockerQueryMap(blockedBo, inactivationBlockingMetadata);
        if (queryMap != null) {
            List potentialBlockingRecords = this.legacyDataAdapter.findMatching(inactivationBlockingMetadata.getBlockingReferenceBusinessObjectClass(), queryMap);
            for (MutableInactivatable businessObject : potentialBlockingRecords) {
                if (!businessObject.isActive()) continue;
                hasBlockingRecord = true;
                break;
            }
        }
        return hasBlockingRecord;
    }

    @Deprecated
    protected Map<String, String> buildInactivationBlockerQueryMap(BusinessObject blockedBo, InactivationBlockingMetadata inactivationBlockingMetadata) {
        BusinessObject blockingBo = (BusinessObject)KRADUtils.createNewObjectFromClass((Class)inactivationBlockingMetadata.getBlockingReferenceBusinessObjectClass());
        org.kuali.rice.krad.bo.DataObjectRelationship dataObjectRelationship = this.legacyDataAdapter.getDataObjectRelationship((Object)blockingBo, blockedBo.getClass(), inactivationBlockingMetadata.getBlockedReferencePropertyName(), "", true, false, false);
        RelationshipDefinition relationshipDefinition = KRADServiceLocatorWeb.getLegacyDataAdapter().getDictionaryRelationship(blockedBo.getClass(), inactivationBlockingMetadata.getBlockedReferencePropertyName());
        if (dataObjectRelationship != null) {
            Map parentToChildReferences = dataObjectRelationship.getParentToChildReferences();
            HashMap<String, String> queryMap = new HashMap<String, String>();
            for (Map.Entry parentToChildReference : parentToChildReferences.entrySet()) {
                String fieldName = (String)parentToChildReference.getKey();
                Object fieldValue = KradDataServiceLocator.getDataObjectService().wrap((Object)blockedBo).getPropertyValueNullSafe((String)parentToChildReference.getValue());
                if (fieldValue != null && StringUtils.isNotBlank((String)fieldValue.toString())) {
                    queryMap.put(fieldName, fieldValue.toString());
                    continue;
                }
                LOG.error("Found null value for foreign key field " + fieldName + " while building inactivation blocking query map.");
                throw new RuntimeException("Found null value for foreign key field '" + fieldName + "' while building inactivation blocking query map.");
            }
            return queryMap;
        }
        return null;
    }

    public boolean detectBlockingRecord(Object dataObject, InactivationBlockingMetadata inactivationBlockingMetadata) {
        if (LegacyUtils.useLegacyForObject((Object)dataObject)) {
            return this.hasABlockingRecord((BusinessObject)dataObject, inactivationBlockingMetadata);
        }
        QueryByCriteria criteria = this.buildInactivationBlockerCriteria(dataObject, inactivationBlockingMetadata);
        if (criteria != null) {
            Class blockingType = inactivationBlockingMetadata.getBlockingDataObjectClass();
            QueryResults potentialBlockingRecords = this.getDataObjectService().findMatching(blockingType, criteria);
            for (Object result : potentialBlockingRecords.getResults()) {
                if (!(result instanceof Inactivatable)) {
                    throw new IllegalStateException("Blocking records must implement Inactivatable, but encountered one which does not: " + String.valueOf(result));
                }
                Inactivatable inactivatable = (Inactivatable)result;
                if (!inactivatable.isActive()) continue;
                return true;
            }
        }
        return false;
    }

    public Collection<?> detectAllBlockingRecords(Object dataObject, InactivationBlockingMetadata inactivationBlockingMetadata) {
        if (LegacyUtils.useLegacyForObject((Object)dataObject)) {
            return this.listAllBlockerRecords((BusinessObject)dataObject, inactivationBlockingMetadata);
        }
        ArrayList blockingRecords = new ArrayList();
        QueryByCriteria criteria = this.buildInactivationBlockerCriteria(dataObject, inactivationBlockingMetadata);
        if (LOG.isDebugEnabled()) {
            LOG.debug("Checking for blocker records for object: " + String.valueOf(dataObject));
            LOG.debug("    With Metadata: " + String.valueOf(inactivationBlockingMetadata));
            LOG.debug("    Resulting QueryByCriteria: " + String.valueOf(criteria));
        }
        if (criteria != null) {
            Class blockingType = inactivationBlockingMetadata.getBlockingDataObjectClass();
            QueryResults potentialBlockingRecords = this.getDataObjectService().findMatching(blockingType, criteria);
            for (Object result : potentialBlockingRecords.getResults()) {
                if (!(result instanceof Inactivatable)) {
                    throw new IllegalStateException("Blocking records must implement Inactivatable, but encountered one which does not: " + String.valueOf(result));
                }
                Inactivatable inactivatable = (Inactivatable)result;
                if (!inactivatable.isActive()) continue;
                blockingRecords.add(result);
            }
        }
        return blockingRecords;
    }

    protected QueryByCriteria buildInactivationBlockerCriteria(Object blockedObject, InactivationBlockingMetadata inactivationBlockingMetadata) {
        DataObjectMetadata blockingObjectMetadata = this.getDataObjectService().getMetadataRepository().getMetadata(inactivationBlockingMetadata.getBlockingDataObjectClass());
        DataObjectRelationship dataObjectRelationship = blockingObjectMetadata.getRelationship(inactivationBlockingMetadata.getBlockedAttributeName());
        if (dataObjectRelationship != null && !dataObjectRelationship.getAttributeRelationships().isEmpty()) {
            DataObjectWrapper wrap = this.getDataObjectService().wrap(blockedObject);
            ArrayList<Predicate> predicates = new ArrayList<Predicate>();
            for (DataObjectAttributeRelationship relationship : dataObjectRelationship.getAttributeRelationships()) {
                String fieldName = relationship.getParentAttributeName();
                Object fieldValue = wrap.getPropertyValue(relationship.getChildAttributeName());
                if (fieldValue == null || !StringUtils.isNotBlank((String)fieldValue.toString())) continue;
                predicates.add(PredicateFactory.equal((String)fieldName, (Object)fieldValue));
            }
            return QueryByCriteria.Builder.fromPredicates((Predicate[])predicates.toArray(new Predicate[predicates.size()]));
        }
        return null;
    }

    public void setDataObjectMetaDataService(DataObjectMetaDataService dataObjectMetaDataService) {
        this.dataObjectMetaDataService = dataObjectMetaDataService;
    }

    public void setLegacyDataAdapter(LegacyDataAdapter legacyDataAdapter) {
        this.legacyDataAdapter = legacyDataAdapter;
    }

    public DataObjectService getDataObjectService() {
        if (this.dataObjectService == null) {
            this.dataObjectService = KradDataServiceLocator.getDataObjectService();
        }
        return this.dataObjectService;
    }

    public void setDataObjectService(DataObjectService dataObjectService) {
        this.dataObjectService = dataObjectService;
    }
}

